/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.index;

import com.inet.search.command.SearchCondition;
import javax.annotation.Nonnull;

public class ListenerTokenMatcher {
    private final Object a;
    private final SearchCondition.SearchTermOperator b;

    public ListenerTokenMatcher(@Nonnull Object token, @Nonnull SearchCondition.SearchTermOperator operator) {
        switch (operator) {
            case Equals: 
            case IN: {
                throw new IllegalArgumentException(operator.toString());
            }
            case StartsWith: 
            case Contains: {
                token = token.toString();
            }
        }
        this.a = token;
        this.b = operator;
    }

    public boolean match(@Nonnull Comparable value) {
        switch (this.b) {
            case StartsWith: {
                if (value.getClass() != String.class) break;
                return ((String)((Object)value)).startsWith((String)this.a);
            }
            case Contains: {
                if (value.getClass() != String.class) break;
                return ((String)((Object)value)).contains((String)this.a);
            }
            case GE: {
                return value.compareTo(this.a) >= 0;
            }
            case GT: {
                return value.compareTo(this.a) > 0;
            }
            case LT: {
                return value.compareTo(this.a) < 0;
            }
            case LE: {
                return value.compareTo(this.a) <= 0;
            }
            case BETWEEN: {
                Object[] objectArray = (Object[])this.a;
                return value.compareTo(objectArray[0]) >= 0 && value.compareTo(objectArray[1]) <= 0;
            }
            case NOT_BETWEEN: {
                Object[] objectArray = (Object[])this.a;
                return value.compareTo(objectArray[0]) < 0 && value.compareTo(objectArray[1]) > 0;
            }
            case Unequals: {
                return value.equals(this.a);
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this.b) + ":" + String.valueOf(this.a) + " - " + String.valueOf(value) + " " + String.valueOf(value.getClass()));
    }

    public int hashCode() {
        return this.a.hashCode() * 31 + this.b.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListenerTokenMatcher listenerTokenMatcher = (ListenerTokenMatcher)obj;
        return this.b == listenerTokenMatcher.b && this.a.equals(listenerTokenMatcher.a);
    }

    @Nonnull
    public Object getToken() {
        return this.a;
    }

    @Nonnull
    public SearchCondition.SearchTermOperator getOperator() {
        return this.b;
    }
}

