/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.index;

import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.lib.json.Bon;
import com.inet.lib.util.IOFunctions;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.d;
import com.inet.search.index.dataseries.SortedDataSeries;
import com.inet.search.index.j;
import com.inet.search.index.k;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

class IntDiskExtendedSet
implements d,
j<Integer> {
    static final int MAX_ENTRIES_PER_PAGE = 1024;
    private static final SetPage[] a = new SetPage[0];
    private SetPage[] b;
    @Nonnull
    private final WeakReference<k<Integer>> c;
    private Integer d;

    IntDiskExtendedSet(@Nonnull WeakReference<k<Integer>> indexRef) {
        this.c = indexRef;
        this.b = a;
    }

    IntDiskExtendedSet(@Nonnull WeakReference<k<Integer>> indexRef, int[] values) throws IOException {
        this.c = indexRef;
        this.b = new SetPage[]{new SetPage(values)};
    }

    IntDiskExtendedSet(@Nonnull WeakReference<k<Integer>> indexRef, Bon bon, Integer fileID) throws IOException {
        this.c = indexRef;
        this.d = fileID;
        this.b = this.a((FileChannel fileChannel) -> {
            int n2 = (int)fileChannel.size() - 4;
            fileChannel.position(n2);
            int n3 = IOFunctions.readInt(fileChannel);
            fileChannel.position(n3);
            byte[] byArray = new byte[n2 - n3];
            fileChannel.read(ByteBuffer.wrap(byArray));
            return bon.fromBinary(byArray, SetPage[].class);
        });
    }

    Integer a() {
        return this.d;
    }

    int @Nonnull [] c() {
        SetPage setPage = this.b[0];
        return Arrays.copyOf(setPage.values, setPage.count);
    }

    /*
     * Loose catch block
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="no user input is used.")
    private <T> T a(a<T> a2) {
        String string = ((k)this.c.get()).c(this.d);
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore(string);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                T t;
                FileChannel fileChannel;
                block18: {
                    fileChannel = FileChannel.open(Paths.get(string, new String[0]), StandardOpenOption.READ);
                    t = a2.read(fileChannel);
                    if (fileChannel == null) break block18;
                    fileChannel.close();
                }
                return t;
                {
                    catch (Throwable throwable) {
                        try {
                            if (fileChannel != null) {
                                try {
                                    fileChannel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            IndexSearchEngine.LOGGER.error(String.valueOf(throwable3) + ": with file: " + string);
                            throw (RuntimeException)ErrorCode.throwAny(throwable3);
                        }
                    }
                }
            }
        }
    }

    public boolean a(Integer n2) {
        int n3 = n2;
        int n4 = this.b(n3);
        if (n4 >= 0) {
            SetPage[] setPageArray = this.b;
            SetPage setPage = setPageArray[n4];
            if (setPage.add(n3, this)) {
                if (setPage.count > 1024) {
                    SetPage setPage2 = setPage.split();
                    this.b = com.inet.search.index.a.a(setPageArray, n4 + 1, setPage2);
                }
                return this.d();
            }
            return false;
        }
        SetPage setPage = new SetPage(n3);
        this.b = new SetPage[]{setPage};
        return this.d();
    }

    @Override
    public boolean remove(Object id) {
        boolean bl;
        int n2 = (Integer)id;
        int n3 = this.b(n2);
        if (n3 >= 0 && (bl = this.b[n3].remove(n2, this))) {
            return this.d();
        }
        return false;
    }

    @Override
    public boolean contains(Object id) {
        int n2 = (Integer)id;
        int n3 = this.b(n2);
        if (n3 >= 0) {
            return this.b[n3].contains(n2, this);
        }
        return false;
    }

    @Override
    public int size() {
        int n2 = 0;
        SetPage[] setPageArray = this.b;
        int n3 = setPageArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += setPageArray[i2].count;
        }
        return n2;
    }

    @Override
    public int a(int n2) {
        int n3 = 0;
        SetPage[] setPageArray = this.b;
        int n4 = setPageArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            SetPage setPage = setPageArray[i2];
            if (setPage.values == null) continue;
            n3 += setPage.values.length;
        }
        return 40 + n3 * 4 + setPageArray.length * 40;
    }

    private boolean d() {
        if (this.b.length <= 1) {
            return true;
        }
        boolean bl = false;
        Integer n2 = this.d;
        if (n2 == null) {
            this.d = n2 = ((k)this.c.get()).a();
            bl = true;
        }
        ((k)this.c.get()).a(n2, this);
        return bl;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="no user input is used.")
    public void a(Bon bon, String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            SetPage[] setPageArray = this.b;
            int n2 = setPageArray.length;
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                SetPage setPage = setPageArray[i2];
                bl = setPage.prepareSave(bon, fileChannel, bl);
            }
            b b2 = new b();
            for (int i3 = 0; i3 < n2; ++i3) {
                SetPage setPage = setPageArray[i3];
                setPage.flushSave(bon, fileChannel, b2);
            }
            long l2 = b2.a;
            fileChannel.position(l2);
            byte[] byArray = bon.toBinary(setPageArray);
            fileChannel.write(ByteBuffer.wrap(byArray));
            IOFunctions.writeInt(fileChannel, (int)l2);
            fileChannel.truncate(l2 + (long)byArray.length + 4L);
        }
    }

    private int b(int n2) {
        SetPage[] setPageArray = this.b;
        int n3 = 0;
        int n4 = setPageArray.length - 1;
        if (n4 < 0) {
            return -1;
        }
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            SetPage setPage = setPageArray[n5];
            int n6 = setPage.compare(n2);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return n4 < 0 ? 0 : n3 - 1;
    }

    @Override
    @Nonnull
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private SetPage[] b;
            private int c;
            private int d;
            private int[] e;
            private int f;
            private int g;
            private Integer h;
            {
                this.b = IntDiskExtendedSet.this.b;
                this.c = this.b.length;
            }

            @Override
            public boolean hasNext() {
                if (this.h != null) {
                    return true;
                }
                while (true) {
                    if (this.g < this.f) {
                        this.h = this.e[this.g++];
                        return true;
                    }
                    if (this.d >= this.c) break;
                    SetPage setPage = this.b[this.d++];
                    this.e = setPage.getValues(IntDiskExtendedSet.this);
                    this.f = setPage.count;
                    this.g = 0;
                }
                return false;
            }

            public Integer a() {
                if (this.hasNext()) {
                    Integer n2 = this.h;
                    this.h = null;
                    return n2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    @Override
    @Nonnull
    public SortedDataSeries<Integer> b() {
        return new SortedDataSeries<Integer>(){
            private SetPage[] b;
            private int c;
            private int[] d;
            private int e;
            {
                this.b = IntDiskExtendedSet.this.b;
                this.c = this.b.length - 1;
            }

            public Integer a() {
                while (true) {
                    if (this.e > 0) {
                        return this.d[--this.e];
                    }
                    if (this.c < 0) break;
                    SetPage setPage = this.b[this.c--];
                    this.d = setPage.getValues(IntDiskExtendedSet.this);
                    this.e = setPage.count;
                }
                return null;
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        return this.a((Integer)object);
    }

    @JsonData
    private static class SetPage {
        private int start;
        private long pos;
        private int length;
        private transient int[] values;
        private transient int count;
        private transient boolean modified;
        private transient byte[] data;

        private SetPage() {
        }

        SetPage(int id) {
            this.start = id;
            this.values = new int[]{id};
            this.count = 1;
            this.modified = true;
        }

        SetPage(int[] values) {
            this.values = values;
            this.start = values[0];
            this.count = values.length;
        }

        boolean prepareSave(Bon bon, FileChannel file, boolean override) throws IOException {
            if (this.modified || override) {
                int[] nArray = this.getValues(file);
                nArray = Arrays.copyOf(this.values, this.count);
                this.data = bon.toBinary(nArray);
                byte[] byArray = this.data;
                int n2 = byArray.length;
                if (this.length == 0 || n2 > this.length) {
                    override = true;
                }
            }
            return override;
        }

        void flushSave(Bon bon, FileChannel file, b state) throws IOException {
            byte[] byArray = this.data;
            if (byArray != null) {
                int n2 = byArray.length;
                if (state.b || this.length == 0 || n2 > this.length) {
                    this.pos = state.a;
                    this.length = Math.max(n2, this.count > 0 ? n2 * 1025 / this.count : n2 * 1024);
                    state.b = true;
                }
                file.write(ByteBuffer.wrap(byArray), this.pos);
                this.data = null;
            }
            state.a += (long)this.length;
        }

        int[] getValues(FileChannel file) throws IOException {
            int[] nArray = this.values;
            if (nArray == null) {
                nArray = this.loadValues(file);
            }
            return nArray;
        }

        int[] getValues(IntDiskExtendedSet set) {
            int[] nArray = this.values;
            if (nArray == null) {
                try {
                    nArray = set.a(file -> this.loadValues(file));
                }
                catch (Throwable throwable) {
                    IndexSearchEngine.LOGGER.error(throwable);
                    ((k)set.c.get()).a(throwable);
                    nArray = this.values = new int[0];
                }
            }
            return nArray;
        }

        private int[] loadValues(FileChannel file) throws IOException {
            try {
                file.position(this.pos);
                byte[] byArray = new byte[this.length];
                file.read(ByteBuffer.wrap(byArray));
                this.values = new Bon().fromBinary(byArray, int[].class);
                int[] nArray = this.values;
                this.count = nArray.length;
                return nArray;
            }
            catch (Exception exception) {
                IndexSearchEngine.LOGGER.error(String.valueOf(exception) + ": at pos: " + this.pos + " -> " + this.length + " file size: " + file.size());
                throw exception;
            }
        }

        int compare(int id) {
            return Integer.compare(this.start, id);
        }

        boolean add(int id, IntDiskExtendedSet set) {
            int n2;
            int[] nArray = this.getValues(set);
            int n3 = Arrays.binarySearch(nArray, 0, n2 = this.count, id);
            if (n3 < 0) {
                int[] nArray2;
                n3 = -n3 - 1;
                if (nArray.length <= n2) {
                    nArray2 = new int[n2 == 0 ? 1 : n2 * 2];
                    System.arraycopy(nArray, 0, nArray2, 0, n3);
                } else {
                    nArray2 = nArray;
                }
                if (n2 > n3) {
                    System.arraycopy(nArray, n3, nArray2, n3 + 1, n2 - n3);
                }
                nArray2[n3] = id;
                this.values = nArray2;
                ++this.count;
                this.modified = true;
                if (n3 == 0) {
                    this.start = id;
                }
                return true;
            }
            return false;
        }

        private boolean remove(int id, IntDiskExtendedSet set) {
            int n2;
            int[] nArray = this.getValues(set);
            int n3 = Arrays.binarySearch(nArray, 0, n2 = this.count, id);
            if (n3 >= 0) {
                int n4 = n2 - n3 - 1;
                if (n4 > 0) {
                    System.arraycopy(nArray, n3 + 1, nArray, n3, n4);
                    if (n3 == 0) {
                        this.start = nArray[0];
                    }
                }
                --this.count;
                this.modified = true;
                return true;
            }
            return false;
        }

        boolean contains(int id, IntDiskExtendedSet set) {
            int n2;
            int[] nArray = this.getValues(set);
            return Arrays.binarySearch(nArray, 0, n2 = this.count, id) >= 0;
        }

        @Nonnull
        SetPage split() {
            SetPage setPage = new SetPage();
            int n2 = this.count / 2;
            setPage.start = this.values[n2];
            setPage.count = this.count - n2;
            setPage.values = Arrays.copyOfRange(this.values, n2, n2 + this.count);
            setPage.modified = true;
            this.count = n2;
            this.modified = true;
            return setPage;
        }
    }

    @FunctionalInterface
    private static interface a<T> {
        public T read(FileChannel var1) throws IOException;
    }

    private static class b {
        long a;
        boolean b;

        private b() {
        }
    }
}

