/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.command;

import com.inet.annotations.InternalApi;
import com.inet.http.servlet.ClientLocale;
import com.inet.search.SearchTag;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class SearchCondition
implements SearchExpression {
    private final String a;
    @Nonnull
    private final SearchTermOperator b;
    private final Object c;
    private final boolean d;

    public SearchCondition(@Nullable String leftOperand, @Nonnull SearchTermOperator searchTermOperator, @Nullable Object rightOperand) {
        this(leftOperand, searchTermOperator, rightOperand, false);
    }

    public SearchCondition(@Nullable String leftOperand, @Nonnull SearchTermOperator searchTermOperator, @Nullable Object rightOperand, boolean fromTextParser) {
        Objects.requireNonNull(searchTermOperator);
        if (leftOperand == null) {
            Objects.requireNonNull(rightOperand);
        }
        this.a = leftOperand;
        this.b = searchTermOperator;
        this.c = rightOperand;
        this.d = fromTextParser;
    }

    public SearchCondition(SearchCondition condition, @Nonnull SearchTermOperator searchTermOperator) {
        this(condition.a, searchTermOperator, condition.c, condition.d);
    }

    @Nullable
    public String getLeftOperand() {
        return this.a;
    }

    @Nonnull
    public SearchTermOperator getOperator() {
        return this.b;
    }

    @Nullable
    public Object getRightOperand() {
        return this.c;
    }

    @Override
    public SearchExpression.Type getType() {
        return SearchExpression.Type.Condition;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.a, this.b, this.c});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SearchCondition searchCondition = (SearchCondition)obj;
        return Objects.equals(this.a, searchCondition.a) && Objects.equals((Object)this.b, (Object)searchCondition.b) && Objects.deepEquals(this.c, searchCondition.c);
    }

    public boolean isFromTextExpression() {
        return this.d;
    }

    @Override
    public void toPhrase(@Nonnull StringBuilder phraseBuilder, @Nonnull IndexSearchEngine<?> searchEngine, boolean toGenericLocale) {
        String string;
        if (this.a != null) {
            string = toGenericLocale ? this.a : searchEngine.getTag(this.a).getDisplayName();
            phraseBuilder.append(TextSearchCommandBuilder.normalizedTagDisplayName(string));
            phraseBuilder.append(':');
        }
        if (this.c != null) {
            Object object;
            boolean bl;
            string = this.c.toString();
            boolean bl2 = bl = string.indexOf(32) >= 0;
            if (this.a != null && (object = searchEngine.getTag(this.a)) != null) {
                block1 : switch (((SearchTag)object).getDataType()) {
                    case IntegerMap: 
                    case StringMap: {
                        bl = true;
                        if (!toGenericLocale) break;
                        Map<Comparable<?>, String> map = ((SearchTag)object).getMapData();
                        string = PhraseSearchExpression.normalize(string);
                        for (Map.Entry<Comparable<?>, String> entry : map.entrySet()) {
                            String string2 = PhraseSearchExpression.normalize(entry.getValue());
                            if (!string.equals(string2)) continue;
                            string = entry.getKey().toString();
                            break block1;
                        }
                        break;
                    }
                    case Double: {
                        try {
                            string = NumberFormat.getInstance(ClientLocale.getThreadLocale()).format(this.c);
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
            switch (this.b) {
                case StartsWith: {
                    bl = false;
                    break;
                }
                case Equals: {
                    bl = true;
                    break;
                }
                case GT: {
                    phraseBuilder.append('>');
                    break;
                }
                case GE: {
                    phraseBuilder.append(">=");
                    break;
                }
                case LT: {
                    phraseBuilder.append('<');
                    break;
                }
                case LE: {
                    phraseBuilder.append("<=");
                    break;
                }
                case Unequals: {
                    phraseBuilder.append("<>");
                    break;
                }
                case Contains: {
                    phraseBuilder.append('*');
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Operation: " + String.valueOf((Object)this.b));
                }
            }
            object = bl ? (string.indexOf(34) < 0 ? "\"" : "'") : "";
            phraseBuilder.append((String)object).append(string).append((String)object);
        }
    }

    public static final class SearchTermOperator
    extends Enum<SearchTermOperator> {
        public static final /* enum */ SearchTermOperator Equals = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator StartsWith = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator Contains = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator GT = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator GE = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator LT = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator LE = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator Unequals = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator BETWEEN = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator NOT_BETWEEN = new SearchTermOperator();
        public static final /* enum */ SearchTermOperator IN = new SearchTermOperator();
        private static final /* synthetic */ SearchTermOperator[] a;

        public static SearchTermOperator[] values() {
            return (SearchTermOperator[])a.clone();
        }

        public static SearchTermOperator valueOf(String name) {
            return Enum.valueOf(SearchTermOperator.class, name);
        }

        private static /* synthetic */ SearchTermOperator[] a() {
            return new SearchTermOperator[]{Equals, StartsWith, Contains, GT, GE, LT, LE, Unequals, BETWEEN, NOT_BETWEEN, IN};
        }

        static {
            a = SearchTermOperator.a();
        }
    }
}

