/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.fs;

import com.inet.logging.LogManager;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.UrlArchiveFile;
import jakarta.servlet.ServletContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class ServletResourceFile
implements ResourceFile {
    @Nonnull
    private final ServletContext a;
    @Nonnull
    private final String b;

    public ServletResourceFile(@Nonnull ServletContext context, @Nonnull String path) {
        this.a = context;
        this.b = path;
    }

    @Override
    public ResourceFile createChild(@Nonnull String child) {
        String string = ResourceFile.createNormalizeChildPath(this.b, child);
        return new ServletResourceFile(this.a, string);
    }

    @Override
    public String getName() {
        int n2 = this.b.endsWith("/") ? this.b.length() - 1 : this.b.length();
        return this.b.substring(this.b.lastIndexOf(47, n2 - 1) + 1, n2);
    }

    @Override
    public boolean isDirectory() {
        if (this.b.endsWith("/")) {
            return true;
        }
        String string = this.b.substring(0, this.b.lastIndexOf(47) + 1);
        Set<String> set = this.a.getResourcePaths(string);
        if (set != null && set.contains(this.b + "/")) {
            return true;
        }
        set = this.a.getResourcePaths(this.b);
        return set != null && set.size() > 0;
    }

    @Override
    public boolean exists() {
        try {
            return this.a.getResource(this.b) != null || this.isDirectory();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.b;
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.b.equals(((ServletResourceFile)obj).b);
    }

    @Override
    public ResourceFile[] listFiles() {
        Set<String> set = this.a.getResourcePaths(this.b);
        if (set == null) {
            return null;
        }
        ResourceFile[] resourceFileArray = new ResourceFile[set.size()];
        Iterator<String> iterator = set.iterator();
        for (int i2 = 0; i2 < resourceFileArray.length; ++i2) {
            resourceFileArray[i2] = new ServletResourceFile(this.a, iterator.next());
        }
        return resourceFileArray;
    }

    @Override
    public ArchiveFile createArchiveFile() throws ZipException, IOException {
        return new UrlArchiveFile(this.getURL());
    }

    @Override
    public String getPath() {
        return this.b;
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check that only save URLs are used")
    public long lastModified() {
        try {
            URL uRL = this.getURL();
            return uRL.openConnection().getLastModified();
        }
        catch (IOException iOException) {
            LogManager.getConfigLogger().error(iOException);
            return 0L;
        }
    }

    @Override
    @Nonnull
    public URL getURL() throws MalformedURLException {
        URL uRL = this.a.getResource(this.b);
        if (uRL != null) {
            return uRL;
        }
        return new URL("file", "", this.getAbsolutePath());
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream = this.a.getResourceAsStream(this.b);
        if (inputStream == null) {
            throw new FileNotFoundException(this.b);
        }
        return inputStream;
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check that only save URLs are used")
    public long length() {
        try {
            URL uRL = this.getURL();
            return uRL.openConnection().getContentLength();
        }
        catch (IOException iOException) {
            LogManager.getConfigLogger().error(iOException);
            return 0L;
        }
    }
}

