/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.crypto;

import com.inet.annotations.InternalApi;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.crypto.EncryptionData;
import com.inet.persistence.crypto.RandomAccessReadInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

@InternalApi
public abstract class CryptoAlgorithm {
    public abstract void reset() throws GeneralSecurityException;

    public abstract OutputStream getEncryptingStream(OutputStream var1);

    public abstract RandomAccessRead getDecryptRA(RandomAccessRead var1);

    public abstract EncryptionData getEncryptionData();

    public InputStream getDecryptingStream(InputStream source) {
        return new RandomAccessReadInputStream(this.getDecryptRA(new b(source)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] decryptBlock(long offset, byte[] data, boolean lastBlock) throws GeneralSecurityException {
        try (a a2 = new a(data, offset);){
            byte[] byArray;
            block13: {
                RandomAccessRead randomAccessRead = this.getDecryptRA(a2);
                try {
                    randomAccessRead.seek(offset);
                    byte[] byArray2 = new byte[data.length];
                    randomAccessRead.read(byArray2);
                    byArray = byArray2;
                    if (randomAccessRead == null) break block13;
                }
                catch (Throwable throwable) {
                    if (randomAccessRead != null) {
                        try {
                            randomAccessRead.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                randomAccessRead.close();
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    private static class b
    extends RandomAccessRead {
        private InputStream a;
        private int b;

        public b(InputStream inputStream) {
            this.a = inputStream;
            try {
                this.b = inputStream.available();
            }
            catch (IOException iOException) {
                this.b = -1;
            }
        }

        @Override
        public void close() throws IOException {
            this.a.close();
        }

        @Override
        public long length() throws IOException {
            if (this.b < 0) {
                this.b = this.a.available();
            }
            return this.b;
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            return this.a.read(b2, off, len);
        }

        @Override
        public int read() throws IOException {
            return this.a.read();
        }

        @Override
        public void seek(long pos) throws IOException {
            throw new IllegalStateException("Seek is not available with a stream wrapper");
        }
    }

    private static class a
    extends RandomAccessRead {
        private byte[] a;
        private int b;
        private long c;

        public a(byte[] byArray, long l2) {
            this.a = byArray;
            this.c = l2;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public long length() throws IOException {
            return this.c + (long)this.a.length;
        }

        @Override
        public int read(byte[] b2, int off, int len) throws IOException {
            if (this.b >= this.a.length) {
                return -1;
            }
            len = Math.min(len, this.a.length - this.b);
            System.arraycopy(this.a, this.b, b2, off, len);
            this.b += len;
            return len;
        }

        @Override
        public int read() throws IOException {
            if (this.b >= this.a.length) {
                return -1;
            }
            return this.a[this.b++];
        }

        @Override
        public void seek(long pos) throws IOException {
            this.b = (int)(pos - this.c);
        }
    }
}

