/*
 * Decompiled with CFR 0.152.
 */
package com.inet.logging;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.logging.LogLevelsDefaults;
import com.inet.logging.Logger;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.Nullable;

public class JavaLogHandler
extends Handler {
    private static final Set<JavaLogHandler> a = ConcurrentHashMap.newKeySet();
    private static final ConfigValue<LogLevelsDefaults> b = new ConfigValue<LogLevelsDefaults>(ConfigKey.LOG_LEVELS){

        @Override
        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            for (JavaLogHandler javaLogHandler : a) {
                javaLogHandler.a();
            }
        }
    };
    private final java.util.logging.Logger c;
    private final Logger d;

    public JavaLogHandler(String javaLoggerName, Logger inetLogger) {
        this(javaLoggerName, inetLogger, true);
    }

    public JavaLogHandler(String javaLoggerName, Logger inetLogger, boolean useParentHandlers) {
        this.c = java.util.logging.Logger.getLogger(javaLoggerName);
        this.d = inetLogger;
        this.c.addHandler(this);
        this.c.setUseParentHandlers(useParentHandlers);
        a.add(this);
        this.a();
    }

    private void a() {
        if (!this.c.getUseParentHandlers()) {
            this.c.setLevel(Level.ALL);
            return;
        }
        this.c.setLevel(switch (this.d.getLogLevel()) {
            case 0 -> Level.OFF;
            case 1 -> Level.SEVERE;
            case 3 -> Level.INFO;
            case 2 -> Level.WARNING;
            case 4 -> Level.ALL;
            default -> Level.OFF;
        });
    }

    @Override
    public void publish(LogRecord record) {
        Level level = record.getLevel();
        this.a(level, record.getMessage());
        this.a(level, record.getThrown());
    }

    private void a(Level level, Object object) {
        if (level == null || object == null) {
            return;
        }
        int n2 = level.intValue();
        if (n2 >= Level.SEVERE.intValue()) {
            this.d.error(object);
        } else if (n2 >= Level.WARNING.intValue()) {
            this.d.warn(object);
        } else if (n2 >= Level.INFO.intValue()) {
            this.d.info(object);
        } else {
            this.d.debug(object);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

