/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

@InternalApi
public class NetworkFunctions {
    private static InitialDirContext a;
    private static MemoryStoreMap<Object, Object> b;

    private static InitialDirContext a() throws NamingException {
        if (a == null) {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            properties.put("com.sun.jndi.dns.timeout.retries", "1");
            a = new InitialDirContext(properties);
        }
        return a;
    }

    @Nonnull
    public static Set<String> getDnsServers() {
        try {
            Object obj = NetworkFunctions.a().getEnvironment().get("java.naming.provider.url");
            if (obj == null) {
                return Collections.emptySet();
            }
            return Arrays.asList(obj.toString().split(" ")).parallelStream().filter(string -> string.startsWith("dns://")).map(string -> NetworkFunctions.getCanonicalHostName(string.substring(6))).collect(Collectors.toSet());
        }
        catch (NamingException namingException) {
            return Collections.emptySet();
        }
    }

    public static String getCanonicalHostName(@Nonnull String host) {
        InetAddress[] inetAddressArray;
        String string = (String)NetworkFunctions.a((Object)host);
        if (string != null) {
            return string;
        }
        try {
            inetAddressArray = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException unknownHostException) {
            return host;
        }
        if (Arrays.asList(inetAddressArray).parallelStream().anyMatch(inetAddress -> {
            try {
                NetworkFunctions.a((Object)host, NetworkFunctions.a(inetAddress));
                return true;
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NamingException namingException) {
                LogManager.getConfigLogger().debug(namingException);
            }
            return false;
        })) {
            return (String)NetworkFunctions.a((Object)host);
        }
        return NetworkFunctions.a((Object)host, inetAddressArray[0].getCanonicalHostName());
    }

    @Nonnull
    public static String getCanonicalHostName(InetAddress addr) {
        String string = (String)NetworkFunctions.a((Object)addr);
        if (string != null) {
            return string;
        }
        try {
            return NetworkFunctions.a(addr, NetworkFunctions.a(addr));
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        catch (NamingException namingException) {
            LogManager.getConfigLogger().debug(namingException);
        }
        return NetworkFunctions.a(addr, addr.getCanonicalHostName());
    }

    @Nonnull
    private static String a(InetAddress inetAddress) throws NamingException {
        Object object;
        byte[] byArray = inetAddress.getAddress();
        StringBuilder stringBuilder = new StringBuilder();
        if (inetAddress instanceof Inet4Address) {
            for (var4_3 = byArray.length - 1; var4_3 >= 0; --var4_3) {
                stringBuilder.append(byArray[var4_3] & 0xFF).append('.');
            }
            object = String.valueOf(stringBuilder) + "in-addr.arpa.";
        } else {
            for (var4_3 = byArray.length - 1; var4_3 >= 0; --var4_3) {
                stringBuilder.append(Integer.toHexString(byArray[var4_3] & 0xFF)).append('.');
            }
            object = String.valueOf(stringBuilder) + "ip6.arpa.";
        }
        Attributes attributes = NetworkFunctions.a().getAttributes((String)object, new String[]{"PTR"});
        Attribute attribute = attributes.get("PTR");
        if (attribute == null) {
            throw new NameNotFoundException();
        }
        object = (String)attribute.get();
        return ((String)object).substring(0, ((String)object).length() - 1);
    }

    private static final InetAddress b() throws UnknownHostException {
        InetAddress inetAddress = (InetAddress)NetworkFunctions.a(InetAddress.class);
        if (inetAddress != null) {
            return inetAddress;
        }
        return NetworkFunctions.a(InetAddress.class, InetAddress.getLocalHost());
    }

    private static <T> T a(Object object) {
        if (b != null) {
            return (T)b.get(object);
        }
        return null;
    }

    private static <T> T a(Object object, T t) {
        if (b == null) {
            if (ServerPluginManager.getInstance().getCorePluginId() != null) {
                b = new MemoryStoreMap();
                b.setTimeout(300, true);
            } else {
                return t;
            }
        }
        b.put(object, t);
        return t;
    }

    public static String getLocalHostName() {
        try {
            return NetworkFunctions.b().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            LogManager.getConfigLogger().error(unknownHostException);
            return NetworkFunctions.a(unknownHostException);
        }
    }

    public static String getCanonicalLocalHostName() {
        try {
            return NetworkFunctions.b().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            LogManager.getConfigLogger().error(unknownHostException);
            return NetworkFunctions.a(unknownHostException);
        }
    }

    public static InetAddress getLocalHost() {
        try {
            return NetworkFunctions.b();
        }
        catch (UnknownHostException unknownHostException) {
            LogManager.getConfigLogger().error(unknownHostException);
            try {
                return InetAddress.getByName(NetworkFunctions.a(unknownHostException));
            }
            catch (UnknownHostException unknownHostException2) {
                LogManager.getConfigLogger().error(unknownHostException);
                return InetAddress.getLoopbackAddress();
            }
        }
    }

    private static String a(@Nonnull UnknownHostException unknownHostException) {
        String string = unknownHostException.getMessage();
        if (string != null) {
            int n2 = string.indexOf(58);
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            if (!StringFunctions.isEmpty(string) && string.indexOf(32) < 0) {
                return string;
            }
        }
        return "localhost";
    }
}

