/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.URLProtocolManagerURLStreamHandlerProvider;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class URLProtocolManager {
    private static Map<String, URLStreamHandler> a = new ConcurrentHashMap<String, URLStreamHandler>();

    public static void register(String protocol, URLStreamHandler handler) {
        Logger logger = LogManager.getConfigLogger();
        a.put(protocol, handler);
        try {
            URLProtocolManager.a(protocol, logger);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                new Runnable(){

                    @Override
                    public void run() {
                        URL.setURLStreamHandlerFactory(new URLProtocolManagerURLStreamHandlerProvider());
                    }
                }.run();
                URLProtocolManager.a(protocol, logger);
                return;
            }
            catch (Throwable throwable) {
                URLProtocolManager.a(logger);
                try {
                    URLProtocolManager.a(protocol, logger);
                    return;
                }
                catch (MalformedURLException malformedURLException2) {
                    logger.error("Could not register the URL protocol: " + protocol + "\nsee at: https://faq.inetsoftware.de/t/tomcat-with-java-17/281 - ", malformedURLException2);
                    return;
                }
            }
        }
    }

    public static void unregister(@Nonnull String protocol) {
        a.remove(protocol);
    }

    private static void a(Logger logger) {
        try {
            Field field = URL.class.getDeclaredField("handlers");
            field.setAccessible(true);
            Hashtable hashtable = (Hashtable)field.get(null);
            hashtable.putAll(a);
        }
        catch (Throwable throwable) {
            logger.error(throwable);
        }
    }

    private static void a(String string, Logger logger) throws MalformedURLException {
        new URL(string + ":x.rpt");
        if (logger.isDebug()) {
            logger.debug("URL protocol " + string + " registered.");
        }
    }

    @Nullable
    static URLStreamHandler a(String string) {
        return a.get(string);
    }
}

