/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.websocket;

import com.inet.annotations.InternalApi;
import com.inet.authentication.base.LoginManager;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.servlet.SessionStore;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebSocketServlet;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogID;
import com.inet.thread.SessionLocalScope;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;

@InternalApi
public class WebSocketEndpoint
extends Endpoint {
    public static String getPollingIDFromSession(Session session) {
        Map map;
        String string = "";
        if (session == null) {
            return string;
        }
        string = session.getQueryString();
        if (string == null) {
            string = session.getId();
        }
        if ((map = session.getRequestParameterMap()) == null) {
            return string;
        }
        List list = (List)map.get("id");
        if (list == null || list.isEmpty()) {
            return string;
        }
        for (String string2 : list) {
            if (string2 == null || string2.isEmpty()) continue;
            string = string2;
            break;
        }
        return string;
    }

    public static Locale getLocaleFromSession(Session session) {
        Object object;
        Object object2;
        if (session == null) {
            return ClientLocale.getThreadLocale();
        }
        Map map = session.getRequestParameterMap();
        if (map != null && (object2 = (List)map.get("currentlocale")) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (StringFunctions.isEmpty(string)) continue;
                return LocaleUtils.valueOf(string);
            }
        }
        if ((object2 = (HttpSession)session.getUserProperties().get(HttpSession.class.getName())) != null) {
            try {
                object = (Locale)object2.getAttribute(Locale.class.getName());
                if (object != null) {
                    return object;
                }
            }
            catch (IllegalStateException illegalStateException) {
                WebSocketServlet.LOGGER.debug(illegalStateException);
            }
        }
        return ClientLocale.getThreadLocale();
    }

    public static TimeZone getTimeZoneFromSession(Session session) {
        if (session == null) {
            return ClientTimezone.getTimeZone();
        }
        HttpSession httpSession = (HttpSession)session.getUserProperties().get(HttpSession.class.getName());
        if (httpSession != null) {
            try {
                TimeZone timeZone = (TimeZone)httpSession.getAttribute(TimeZone.class.getName());
                if (timeZone != null) {
                    return timeZone;
                }
            }
            catch (IllegalStateException illegalStateException) {
                WebSocketServlet.LOGGER.debug(illegalStateException);
            }
        }
        return ClientTimezone.getTimeZone();
    }

    public void onClose(Session session, CloseReason closeReason) {
        WebSocketEventHandler webSocketEventHandler = WebSocketEventHandler.getInstance();
        try (SessionLocalScope sessionLocalScope = SessionLocalScope.create();){
            String string = this.a(session);
            if (string == null) {
                return;
            }
            WebsocketConnection websocketConnection = webSocketEventHandler.getConnection(string);
            if (websocketConnection == null || session == null || !session.equals(websocketConnection.getSession())) {
                return;
            }
            if (WebSocketServlet.LOGGER.isInfo()) {
                URI uRI = session.getRequestURI();
                HttpSession httpSession = websocketConnection.getActiveHttpSession();
                String string2 = String.valueOf(httpSession.getAttribute("RemoteAddr")) + " \"WSCLOSE " + uRI.getPath() + " " + uRI.getScheme().toUpperCase() + "/" + session.getProtocolVersion() + "\" " + closeReason.getCloseCode().getCode() + " -1 \"" + websocketConnection.getPollingID() + "\" \"" + String.valueOf(httpSession.getAttribute("user-agent")) + "\"";
                WebSocketServlet.LOGGER.info(string2);
            }
            webSocketEventHandler.connectionClosed(string, websocketConnection);
        }
    }

    public void onOpen(final Session session, EndpointConfig config) {
        WebsocketConnection websocketConnection;
        Object object;
        final WebSocketEventHandler webSocketEventHandler = WebSocketEventHandler.getInstance();
        try (Object object2 = SessionLocalScope.create();){
            object = this.a(session);
            if (object == null) {
                return;
            }
            websocketConnection = new WebsocketConnection(session, (String)object);
            webSocketEventHandler.connectionOpened((String)object, websocketConnection);
        }
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void a(String string) {
                block13: {
                    try (SessionLocalScope sessionLocalScope = SessionLocalScope.create();){
                        String string2 = WebSocketEndpoint.this.a(session);
                        if (string2 == null) {
                            return;
                        }
                        WebsocketConnection websocketConnection = webSocketEventHandler.getConnection(string2);
                        if (websocketConnection == null) break block13;
                        try {
                            webSocketEventHandler.handleEvent(new FastStringReader(string), websocketConnection);
                        }
                        catch (Throwable throwable) {
                            WebSocketServlet.LOGGER.error(throwable);
                            websocketConnection.sendEvent("error", StringFunctions.getUserFriendlyErrorMessage(throwable));
                            if (sessionLocalScope != null) {
                                sessionLocalScope.close();
                            }
                            return;
                        }
                    }
                    catch (Error | RuntimeException throwable) {
                        WebSocketServlet.LOGGER.error(throwable);
                        throw throwable;
                    }
                }
            }

            public /* synthetic */ void onMessage(Object object) {
                this.a((String)object);
            }
        });
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<InputStream>(){

            public void a(InputStream inputStream) {
                block13: {
                    try (SessionLocalScope sessionLocalScope = SessionLocalScope.create();){
                        String string = WebSocketEndpoint.this.a(session);
                        if (string == null) {
                            return;
                        }
                        WebsocketConnection websocketConnection = webSocketEventHandler.getConnection(string);
                        if (websocketConnection == null) break block13;
                        try {
                            webSocketEventHandler.handleEvent(inputStream, websocketConnection);
                        }
                        catch (Throwable throwable) {
                            WebSocketServlet.LOGGER.error(throwable);
                            websocketConnection.sendEvent("error", StringFunctions.getUserFriendlyErrorMessage(throwable));
                            if (sessionLocalScope != null) {
                                sessionLocalScope.close();
                            }
                            return;
                        }
                    }
                    catch (Error | RuntimeException throwable) {
                        WebSocketServlet.LOGGER.error(throwable);
                        throw throwable;
                    }
                }
            }

            public /* synthetic */ void onMessage(Object object) {
                this.a((InputStream)object);
            }
        });
        if (WebSocketServlet.LOGGER.isInfo()) {
            object2 = websocketConnection.getSession().getRequestURI();
            object = websocketConnection.getActiveHttpSession();
            String string = String.valueOf(object.getAttribute("RemoteAddr")) + " \"WSOPEN " + ((URI)object2).getPath() + " " + ((URI)object2).getScheme().toUpperCase() + "/" + websocketConnection.getSession().getProtocolVersion() + "\" -1 -1 \"" + websocketConnection.getPollingID() + "\" \"" + String.valueOf(object.getAttribute("user-agent")) + "\"";
            WebSocketServlet.LOGGER.info(string);
        }
        session.setMaxBinaryMessageBufferSize(0x100000);
        session.setMaxIdleTimeout(300000L);
    }

    @Nullable
    private String a(Session session) {
        HttpSession httpSession = (HttpSession)session.getUserProperties().get(HttpSession.class.getName());
        try {
            httpSession.getCreationTime();
        }
        catch (IllegalStateException illegalStateException) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Session expired"));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return null;
        }
        LogID.reset();
        SessionStore.setWebSocketSession(session);
        ClientLocale.setThreadLocale(WebSocketEndpoint.getLocaleFromSession(session));
        ClientTimezone.setTimeZone(WebSocketEndpoint.getTimeZoneFromSession(session));
        LoginManager.initUserAccount(httpSession);
        return WebSocketEndpoint.getPollingIDFromSession(session);
    }
}

