/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.unicode;

import com.inet.annotations.JsonData;
import com.inet.font.unicode.IUnicodeRange;
import com.inet.font.unicode.UnicodeCharBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class UnicodeCharBlockGroupList
implements IUnicodeRange {
    private static final int INTERVAL_SIZE_BITS = 32;
    private List<Integer> blockGroupList;
    private int groupIDWithMaxFrequentOccurence;

    private UnicodeCharBlockGroupList() {
    }

    private UnicodeCharBlockGroupList(@Nonnull List<Integer> blockGroupList) {
        this.blockGroupList = blockGroupList;
    }

    private void setGroupIdWithMaxFrequentOccurence(int groupId) {
        this.groupIDWithMaxFrequentOccurence = groupId;
    }

    public int getGroupIdWithMaxFrequentOccurence() {
        return this.groupIDWithMaxFrequentOccurence;
    }

    @Nonnull
    public static UnicodeCharBlockGroupList getUnicodeCharBlockGroupList(int @Nonnull [] unicodeIntervals) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        for (int i2 = 0; i2 < unicodeIntervals.length; ++i2) {
            int n3 = unicodeIntervals[i2];
            int n4 = 0;
            while (n3 != 0) {
                if ((n3 & 1) == 1) {
                    arrayList.add(n2 + n4);
                }
                n3 >>>= 1;
                ++n4;
            }
            n2 += 32;
        }
        return new UnicodeCharBlockGroupList(arrayList);
    }

    public boolean contains(IUnicodeRange unicodeRange) {
        if (unicodeRange instanceof UnicodeCharBlock) {
            return this.blockGroupList.contains(((UnicodeCharBlock)unicodeRange).getBlockGroupID());
        }
        if (unicodeRange instanceof UnicodeCharBlockGroupList) {
            return this.blockGroupList.containsAll(((UnicodeCharBlockGroupList)unicodeRange).blockGroupList);
        }
        return false;
    }

    public static UnicodeCharBlockGroupList getUnicodeCharBlockGroupList(String text) {
        int n2;
        int[] nArray = new int[128];
        int n3 = 0;
        int n4 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n5 = text.length();
        int n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n7 = text.charAt(n2);
            n6 = n2 < n5 - 1 && Character.isHighSurrogate((char)n7) ? Character.toCodePoint((char)n7, text.charAt(++n2)) : n7;
            UnicodeCharBlock unicodeCharBlock = UnicodeCharBlock.getUnicodeBlock(n6);
            int n8 = unicodeCharBlock.getBlockGroupID();
            if (n8 >= UnicodeCharBlock.RESERVED1.getBlockGroupID()) continue;
            if (!arrayList.contains(n8)) {
                arrayList.add(n8);
            }
            int n9 = n8;
            nArray[n9] = nArray[n9] + 1;
        }
        for (n2 = 0; n2 < 128; ++n2) {
            if (nArray[n2] <= n4) continue;
            n3 = n2;
            n4 = nArray[n2];
        }
        UnicodeCharBlockGroupList unicodeCharBlockGroupList = new UnicodeCharBlockGroupList(arrayList);
        unicodeCharBlockGroupList.setGroupIdWithMaxFrequentOccurence(n3);
        return unicodeCharBlockGroupList;
    }

    public static List<UnicodeCharBlock> getUnicodeCharBlocksWithDuplicates(String text) {
        ArrayList<UnicodeCharBlock> arrayList = new ArrayList<UnicodeCharBlock>();
        int n2 = text.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = text.charAt(i2);
            n3 = i2 < n2 - 1 && Character.isHighSurrogate((char)n4) ? Character.toCodePoint((char)n4, text.charAt(++i2)) : n4;
            UnicodeCharBlock unicodeCharBlock = UnicodeCharBlock.getUnicodeBlock(n3);
            arrayList.add(unicodeCharBlock);
        }
        return arrayList;
    }

    public int hashCode() {
        return this.blockGroupList.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnicodeCharBlockGroupList)) {
            return false;
        }
        return ((UnicodeCharBlockGroupList)obj).blockGroupList.equals(this.blockGroupList);
    }

    public List<Integer> getListOfUnicodeRanges() {
        return this.blockGroupList;
    }

    public void addID(int id) {
        this.blockGroupList.add(id);
    }
}

