/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.type1;

import com.inet.font.truetype.FontCollection;
import com.inet.font.truetype.ReplacingFontFinder;
import com.inet.font.truetype.SubFontTT;
import com.inet.font.truetype.TTFont;
import com.inet.font.type1.structs.CFFSubFontGenerator;
import com.inet.font.type1.structs.CffDataReader;
import com.inet.logging.LogManager;
import com.inet.shared.utils.MemoryStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.SuppressFBWarnings;

public class SubFontType1
extends SubFontTT {
    private List<String> f;
    private boolean g;

    public SubFontType1(TTFont ttFont, ReplacingFontFinder fontFinder) {
        super(ttFont, fontFinder);
        if (fontFinder != null && fontFinder.getPostscript() != null) {
            this.g = true;
        }
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    public byte[] toByteArray(boolean compress, boolean useGlyphIdAsCharCode) throws IOException, IllegalStateException {
        Object object;
        super.setUsingGlyphAsCharCode(useGlyphIdAsCharCode);
        RandomAccessFile randomAccessFile = null;
        MemoryStream memoryStream = null;
        try {
            object = this.getTTFont();
            FontCollection fontCollection = ((TTFont)object).getFontCollection();
            String string = fontCollection.getFontPath();
            if (((TTFont)object).isSubset()) {
                int n2;
                int n3 = this.getTTFont().getFontCollection().getCffIndexesInTTC()[this.getTTFont().getFontIndex()];
                if (n3 == -1 || (n2 = this.getTableOffset(n3)) == -1) {
                    throw new IOException("Table CFF not found");
                }
                int n4 = this.getTableLength(n3);
                if (!this.isUsingGlyphAsCharCode()) {
                    byte[] byArray = this.b(string);
                    if (compress) {
                        byArray = SubFontType1.compress(byArray, byArray.length);
                    }
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                byte[] byArray = this.a(string, n2, n4);
                memoryStream = this.b(byArray);
            } else {
                randomAccessFile = new RandomAccessFile(string, "r");
                this.assembleFontFully(randomAccessFile);
            }
            if (compress) {
                this.compress();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                catch (Throwable throwable) {}
            }
        }
        if (this.isUsingGlyphAsCharCode()) {
            return memoryStream != null ? memoryStream.toByteArray() : null;
        }
        object = this.getFontFile();
        this.setFontFile(null);
        return object;
    }

    @Override
    public boolean isForceReplacing() {
        return this.g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    byte[] a(String string, int n2, int n3) {
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            byArray = new byte[n3];
            randomAccessFile.seek(n2);
            randomAccessFile.read(byArray);
        }
        catch (IOException iOException) {
            LogManager.getLogger("Reporting").error(iOException);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    byte[] b(String string) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        try {
            fileInputStream = new FileInputStream(string);
            int n2 = fileInputStream.available();
            byArray = new byte[n2];
            fileInputStream.read(byArray);
        }
        catch (IOException iOException) {
            LogManager.getLogger("Reporting").error(iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    MemoryStream b(byte[] byArray) throws IOException {
        boolean[] blArray = this.getGlyphsUsed();
        if (blArray == null) {
            if (LogManager.getApplicationLogger().isWarning()) {
                LogManager.getApplicationLogger().warn("no used glyphs found");
            }
            return null;
        }
        CffDataReader cffDataReader = new CffDataReader(byArray);
        CFFSubFontGenerator cFFSubFontGenerator = new CFFSubFontGenerator(cffDataReader, this.getCidFontName(), this);
        if (blArray.length != 0) {
            blArray[0] = true;
        }
        cFFSubFontGenerator.parseStructures();
        MemoryStream memoryStream = cFFSubFontGenerator.generate(blArray);
        return memoryStream;
    }

    public void displayFontWarnings(String warning) {
        if (this.f == null) {
            this.f = new ArrayList<String>();
        }
        if (!this.f.contains(warning = "Font " + this.filenameOfTTFont() + ": " + (String)warning)) {
            LogManager.getApplicationLogger().warn(warning);
            this.f.add((String)warning);
        }
    }
}

