/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.truetype;

import com.inet.font.FontUtils;
import com.inet.font.truetype.FontCollection;
import com.inet.font.truetype.InstalledFontTT;
import com.inet.font.truetype.ReplacingFontFinder;
import com.inet.font.truetype.TTFont;
import com.inet.logging.LogManager;
import com.inet.shared.utils.MemoryStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public abstract class SubFontTT
extends InstalledFontTT {
    static final int[] a = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5};
    static final String[] b = new String[]{"cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep", "name", "post", "OS/2"};
    private static final String[] f = new String[]{"cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    private static final String[] g = new String[]{"CFF ", "cmap"};
    private static final String[] h = new String[]{"CFF ", "cmap", "head", "hhea", "hmtx", "maxp", "name", "post", "OS/2"};
    private static final int BYTE_SIZE = 8;
    private static final byte[] i = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    byte[] c;
    int d;
    int[] e;
    private boolean j;
    private static int k = 3;
    private String l;

    public SubFontTT(TTFont ttFont, ReplacingFontFinder fontFinder) {
        super(ttFont, fontFinder);
        this.a();
    }

    public abstract byte[] toByteArray(boolean var1, boolean var2) throws IOException, IllegalStateException;

    protected void setUsingGlyphAsCharCode(boolean useGlyphIdAsCharCode) {
        this.j = useGlyphIdAsCharCode;
    }

    protected boolean isUsingGlyphAsCharCode() {
        return this.j;
    }

    void a() {
        int n2 = this.getTTFont().d();
        this.e = new int[n2];
        Arrays.fill(this.e, 65535);
    }

    public char getCharCID(int ch) {
        char c2 = this.getTTFont().getGlyph(ch);
        if (c2 == '\uffff' && (c2 = this.getTTFont().getGlyph(65533)) == '\uffff') {
            return '\u0000';
        }
        return c2;
    }

    protected boolean[] getGlyphsUsed() {
        boolean[] blArray = null;
        blArray = new boolean[this.e.length];
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            blArray[i2] = this.e[i2] != 65535;
        }
        return blArray;
    }

    String[] b() {
        if (this.getTTFont().getFontCollection().isType1()) {
            if (this.j) {
                return g;
            }
            return h;
        }
        if (this.j) {
            return f;
        }
        return b;
    }

    public int getTableOffset(int tableIndex) throws IOException {
        TTFont tTFont = this.getTTFont();
        int n2 = tTFont.getFontCollection().getEntriesOffsetsTTC()[tTFont.a][tableIndex];
        if (n2 == -1) {
            throw new IOException("Table not found " + tTFont.a + " : " + tableIndex);
        }
        return n2;
    }

    public int getTableLength(int tableIdx) throws IOException {
        TTFont tTFont = this.getTTFont();
        int n2 = tTFont.getFontIndex();
        if (tTFont.getFontCollection().getEntriesOffsetsTTC()[n2][tableIdx] == -1) {
            throw new IOException("Table not found " + tTFont.a + " : " + tableIdx);
        }
        int n3 = tTFont.getFontCollection().getEntriesLengthsTTC()[n2][tableIdx];
        return n3;
    }

    @Override
    protected boolean setGlyph(int ch, int glyph) {
        if (this.e[glyph] == ch) {
            return false;
        }
        this.e[glyph] = ch;
        return true;
    }

    int a(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)n3;
        return n2;
    }

    int b(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)(n3 >> 24);
        byArray[n2++] = (byte)(n3 >> 16);
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)n3;
        return n2;
    }

    void a(int n2) {
        this.c[this.d++] = (byte)(n2 >> 8);
        this.c[this.d++] = (byte)n2;
    }

    void b(int n2) {
        this.c[this.d++] = (byte)(n2 >> 24);
        this.c[this.d++] = (byte)(n2 >> 16);
        this.c[this.d++] = (byte)(n2 >> 8);
        this.c[this.d++] = (byte)n2;
    }

    void a(String string) {
        byte[] byArray = FontUtils.getBytes(string);
        System.arraycopy(byArray, 0, this.c, this.d, byArray.length);
        this.d += byArray.length;
    }

    int a(byte[] byArray) {
        int n2 = byArray.length / 4;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n6 += byArray[n7++] & 0xFF;
            n5 += byArray[n7++] & 0xFF;
            n4 += byArray[n7++] & 0xFF;
            n3 += byArray[n7++] & 0xFF;
        }
        return n3 + (n4 << 8) + (n5 << 16) + (n6 << 24);
    }

    public void compress() {
        this.c = SubFontTT.compress(this.c, this.c.length);
    }

    public static byte[] compress(byte[] arrayToCompress, int length) {
        MemoryStream memoryStream = new MemoryStream();
        try {
            Deflater deflater = new Deflater();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)memoryStream, deflater);
            deflaterOutputStream.write(arrayToCompress, 0, length);
            deflaterOutputStream.close();
            deflater.end();
            return memoryStream.toByteArray();
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error("font compress failed because of exception:");
            LogManager.getApplicationLogger().error(throwable);
            return arrayToCompress;
        }
    }

    public int getCharCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            if (this.e[i2] == 65535) continue;
            ++n2;
        }
        return n2;
    }

    public int getGlyphWidth(char glyph) {
        return this.getTTFont().getGlyphWidth(glyph);
    }

    public int[] getCharsUsed() {
        return this.e;
    }

    public MemoryStream getCidSetStream() {
        byte[] byArray;
        int n2;
        int n3;
        boolean bl = false;
        for (n3 = n2 = this.e.length - 1; n3 >= 0; --n3) {
            if (this.e[n3] == 65535) continue;
            n2 = n3;
            bl = true;
            break;
        }
        if (bl) {
            n3 = n2 / 8 + 1;
            byArray = new byte[n3];
            for (int i2 = 0; i2 <= n2; ++i2) {
                if (SubFontTT.getCidCharsVar() != 4 && this.e[i2] == 65535) continue;
                int n4 = i2 / 8;
                int n5 = i2 % 8;
                int n6 = n4;
                byArray[n6] = (byte)(byArray[n6] | i[n5]);
            }
        } else {
            byArray = new byte[]{i[0]};
        }
        MemoryStream memoryStream = new MemoryStream(byArray.length);
        memoryStream.write(byArray);
        return memoryStream;
    }

    public static int getCidCharsVar() {
        return k;
    }

    protected void assembleFontFully(RandomAccessFile raFile) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        FontCollection fontCollection = this.getTTFont().getFontCollection();
        int n6 = this.getTTFont().a;
        int n7 = fontCollection.l()[n6].length;
        for (n3 = 0; n3 < n7; ++n3) {
            n5 += fontCollection.getEntriesLengthsTTC()[n6][n3] + 3 & 0xFFFFFFFC;
        }
        n3 = 16 * n7 + 12;
        this.c = new byte[n5 += n3];
        this.d = 0;
        this.b(65536);
        this.a(n7);
        int n8 = a[n7];
        this.a((1 << n8) * 16);
        this.a(n8);
        this.a((n7 - (1 << n8)) * 16);
        for (n2 = 0; n2 < n7; ++n2) {
            String string = fontCollection.l()[n6][n2];
            this.a(string);
            this.b(fontCollection.getEntriesCheckSumTTC()[n6][n2]);
            n4 = fontCollection.getEntriesLengthsTTC()[n6][n2];
            this.b(n3);
            this.b(n4);
            n3 += n4 + 3 & 0xFFFFFFFC;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            int n9 = fontCollection.getEntriesOffsetsTTC()[n6][n2];
            int n10 = fontCollection.getEntriesLengthsTTC()[n6][n2];
            this.a(raFile, n9, n10, this.c, this.d);
            this.d += n10 + 3 & 0xFFFFFFFC;
        }
    }

    protected byte[] getFontFile() {
        return this.c;
    }

    protected void setFontFile(byte[] fontfile) {
        this.c = fontfile;
    }

    public String getCidFontName() {
        return this.l;
    }

    public void setCidFontName(String cidFontName) {
        this.l = cidFontName;
    }

    void a(RandomAccessFile randomAccessFile, int n2, int n3, byte[] byArray, int n4) throws IOException {
        randomAccessFile.seek(n2);
        randomAccessFile.read(byArray, n4, n3);
    }
}

