/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeBoolean
extends FieldType<Boolean> {
    public FieldTypeBoolean(String key, Supplier<String> displayname) {
        super(key, displayname);
    }

    @Override
    public String getDisplayValue(@Nullable Boolean value) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        return Field.MSG.getMsg(value != false ? "true" : "false", new Object[0]);
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> displayname, @Nonnull FieldTypeFactory fieldTypeFactory) {
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.IntegerMap, true, GuidTokenizer.INSTANCE, 100, displayname, true){

            @Override
            @Nonnull
            public Map<? extends Comparable<?>, String> getMapData() {
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                hashMap.put(0, Field.MSG.getMsg("false", new Object[0]));
                hashMap.put(1, Field.MSG.getMsg("true", new Object[0]));
                hashMap.put(null, "");
                return hashMap;
            }

            @Override
            public boolean showAlsoNonMapValues() {
                return true;
            }
        });
    }

    public static FieldTypeBoolean withoutSearchtag(String key) {
        return new FieldTypeBoolean(key, () -> null){

            @Override
            public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory fieldTypeFactory) {
                return null;
            }
        };
    }

    @Override
    @Nullable
    public String asString(@Nullable Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "1" : "0";
    }

    @Override
    @Nullable
    public Boolean valueOf(@Nullable String value) {
        return value == null ? null : (value.equalsIgnoreCase("1") ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT);
    }
}

