/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.provider;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.process.ProcessStarter;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import java.io.File;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ConfigValidator {
    private ArrayList<ConfigValidationMsg> a;
    private ConfigStructureSettings b;
    private NumberFormat c = NumberFormat.getNumberInstance();

    public ConfigValidator(@Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        this.c.setMaximumFractionDigits(2);
        this.a = messages;
        this.b = settings;
    }

    public void validateNumberRange(@Nonnull ConfigKey key, long min, long max) {
        this.validateNumberRange(key.getKey(), this.b.getValue(key), min, max);
    }

    public void validateUnitNumberRangeWholeNumbers(@Nonnull ConfigKey key, long min, long max, String unit) {
        long l2;
        try {
            l2 = Long.parseLong(this.b.getValue(key));
        }
        catch (NumberFormatException numberFormatException) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage(numberFormatException), key));
            return;
        }
        if (l2 < min) {
            String string = unit == null ? String.valueOf(min) : min + " " + CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.units." + unit, min);
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.min", string), key));
            return;
        }
        if (l2 > max) {
            String string = unit == null ? String.valueOf(max) : max + " " + CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.units." + unit, max);
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.max", string), key));
            return;
        }
    }

    public void validateNumberRange(@Nonnull String key, String value, long min, long max) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage(numberFormatException), key));
            return;
        }
        if (bigDecimal.compareTo(new BigDecimal(min)) < 0) {
            String string = String.valueOf(min);
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.min", string), key));
            return;
        }
        if (bigDecimal.compareTo(new BigDecimal(max)) > 0) {
            String string = String.valueOf(max);
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.max", string), key));
            return;
        }
    }

    public void validateUnitNumberRange(@Nonnull ConfigKey key, double min, double max, String unit) {
        this.validateUnitNumberRange(key.getKey(), this.b.getValue(key), min, max, unit);
    }

    public void validateUnitNumberRange(@Nonnull String key, String value, double min, double max, String unit) {
        double d2;
        try {
            d2 = Double.parseDouble(value);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage(runtimeException), key));
            return;
        }
        if (d2 < min) {
            String string = unit == null ? this.c.format(min) : this.c.format(min) + " " + unit;
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.min", string), key));
            return;
        }
        if (d2 > max) {
            String string = unit == null ? this.c.format(max) : this.c.format(max) + " " + unit;
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.range.max", string), key));
            return;
        }
    }

    public void validateStringLength(@Nonnull ConfigKey key, int minLength, int maxLength) {
        this.validateStringLength(key.getKey(), minLength, maxLength);
    }

    public void validateStringLength(@Nonnull String key, int minLength, int maxLength) {
        String string = this.b.getValue(key);
        if (string == null && minLength == 0) {
            return;
        }
        if (string == null || string.length() < minLength) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.stringlength.min", minLength), key));
        } else if (string.length() > maxLength) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.stringlength.max", maxLength), key));
        }
    }

    public void validateFileOrHttpURL(@Nonnull ConfigKey key) {
        this.validateFileOrHttpURL(key.getKey(), null);
    }

    public void validateFileOrHttpURL(@Nonnull String key) {
        this.validateFileOrHttpURL(key, null);
    }

    public void validateFileOrHttpURL(@Nonnull ConfigKey key, Path workingDir) {
        this.validateFileOrHttpURL(key.getKey(), workingDir);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public void validateFileOrHttpURL(@Nonnull String key, Path workingDir) {
        Comparable<File> comparable;
        block10: {
            String string = this.b.getValue(key);
            if (string == null || string.isEmpty()) {
                return;
            }
            comparable = null;
            try {
                URL uRL = new URL(string);
                String string2 = uRL.getProtocol();
                if (string2.startsWith("http")) {
                    return;
                }
                if (!string2.equals("file")) {
                    this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, "Not supported protocol: " + string2, key));
                    return;
                }
                comparable = IOFunctions.getFile(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                Comparable<Path> comparable2;
                try {
                    comparable2 = Paths.get(string, new String[0]);
                    if (!comparable2.isAbsolute()) {
                        if (workingDir == null) {
                            workingDir = new File(".").toPath();
                        }
                        comparable = workingDir.resolve((Path)comparable2).toFile();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (comparable != null && ((File)comparable).exists()) break block10;
                comparable2 = new File(string);
                if (comparable != null && !((File)comparable2).exists()) break block10;
                comparable = comparable2;
            }
        }
        if (!((File)comparable).isFile()) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "config.error.filenotfound", ((File)comparable).getAbsolutePath()), key));
        }
    }

    public void validateFileOrURL(@Nonnull ConfigKey key) {
        this.validateFileOrURL(key.getKey(), null);
    }

    public void validateFileOrURL(@Nonnull ConfigKey key, Path workingDir) {
        this.validateFileOrURL(key.getKey(), workingDir);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public void validateFileOrURL(@Nonnull String key, Path workingDir) {
        Comparable<File> comparable;
        String string;
        block20: {
            string = this.b.getValue(key);
            if (string == null || string.isEmpty()) {
                return;
            }
            comparable = null;
            try {
                String string2;
                URL uRL = new URL(string);
                switch (string2 = uRL.getProtocol()) {
                    case "http": 
                    case "https": {
                        return;
                    }
                    case "file": {
                        comparable = IOFunctions.getFile(uRL);
                        break;
                    }
                    case "data": {
                        return;
                    }
                    default: {
                        this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, "Not supported protocol: " + string2, key));
                        return;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                Comparable<Path> comparable2;
                try {
                    comparable2 = Paths.get(string, new String[0]);
                    if (!comparable2.isAbsolute()) {
                        if (workingDir == null) {
                            workingDir = new File(".").toPath();
                        }
                        comparable = workingDir.resolve((Path)comparable2).toFile();
                    } else {
                        comparable = comparable2.toFile();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (comparable != null && comparable.exists() || !((File)(comparable2 = new File(string))).exists()) break block20;
                comparable = comparable2;
            }
        }
        if (comparable == null || !comparable.isFile()) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "config.error.filenotfound", string), key));
        }
    }

    public boolean validateHttpURL(@Nonnull ConfigKey key) {
        String string = this.b.getValue(key);
        if (string == null || string.isEmpty()) {
            return true;
        }
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("http") || string2.equals("https")) {
                return true;
            }
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, "Not supported protocol: " + string2, key));
        }
        catch (MalformedURLException malformedURLException) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage(malformedURLException), key));
        }
        return false;
    }

    public boolean checkNotEmpty(@Nonnull ConfigKey key) {
        return this.checkNotEmpty(key.getKey());
    }

    public boolean checkNotEmpty(@Nonnull String key) {
        String string = this.b.getValue(key);
        return this.checkNotEmpty(string, key);
    }

    public boolean checkNotEmpty(@Nonnull String value, String key) {
        if (value == null || value.trim().isEmpty()) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.empty", new Object[0]), key));
            return false;
        }
        return true;
    }

    public boolean checkFileExists(@Nonnull ConfigKey key) {
        return this.checkFileExists(this.b.getValue(key), key.getKey());
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public boolean checkFileExists(String filename, String key) {
        if (filename == null || filename.isEmpty()) {
            return true;
        }
        if (!new File(filename).isFile()) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "config.error.filenotfound", filename), key));
            return false;
        }
        return true;
    }

    public void checkDirectoryExists(@Nonnull ConfigKey key) {
        String string = this.b.getValue(key);
        this.checkDirectoryExists(key, string);
    }

    public void checkDirectoryExists(@Nonnull ConfigKey key, String directory) {
        this.checkDirectoryExists(key.getKey(), directory);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public void checkDirectoryExists(@Nonnull String key, String directory) {
        if (directory == null || directory.isEmpty()) {
            return;
        }
        if (!new File(directory).isDirectory()) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "config.error.directorynotfound", directory), key));
        }
    }

    public boolean checkWritableFilePossible(@Nonnull ConfigKey key) {
        String string = this.b.getValue(key);
        String string2 = ConfigValidator.checkWritableFilePossible(string, this.b.getLocale());
        if (string2 != null) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string2, key));
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public static String checkWritableFilePossible(String filename, Locale locale) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        try {
            Paths.get(filename, new String[0]);
        }
        catch (Throwable throwable) {
            return StringFunctions.getUserFriendlyErrorMessage(throwable);
        }
        File file = new File(filename);
        if (file.isDirectory()) {
            return CoreSystemStructureProvider.INSTANCE.translate(locale, "config.error.shouldNotBeADirectory", new Object[0]);
        }
        if (file.isFile()) {
            boolean bl = Files.isWritable(Paths.get(file.toURI()));
            if (!bl) {
                return CoreSystemStructureProvider.INSTANCE.translate(locale, "config.error.fileNotWriteable", new Object[0]);
            }
        } else {
            for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                if (!file2.exists() || !file2.isFile()) continue;
                return CoreSystemStructureProvider.INSTANCE.translate(locale, "config.error.notAValidPath", file2.getAbsolutePath());
            }
        }
        return null;
    }

    public void checkNeedRestart(@Nonnull ConfigKey key) {
        this.checkNeedRestart(key, this.b.getValue(key), this.b.getOriginalValue(key));
    }

    public void checkNeedRestart(@Nonnull ConfigKey key, String currentValue, String originalValue) {
        this.checkNeedRestart(key.getKey(), currentValue, originalValue);
    }

    public void checkNeedRestart(@Nonnull String key, String currentValue, String originalValue) {
        boolean bl;
        if (!Objects.equals(currentValue, originalValue) && ((bl = this.b.isCurrentConfigurationSelected()) || ConfigurationManager.isRecoveryMode())) {
            String string;
            ConfigValidationMsg.Type type;
            if (ProcessStarter.isProcessStarterRunning()) {
                type = ConfigValidationMsg.Type.AskRestart;
                string = CoreSystemStructureProvider.INSTANCE.translate(this.b, "restart.needed", new Object[0]);
            } else {
                type = ConfigValidationMsg.Type.Restart;
                string = "Restart needed";
            }
            this.a.add(new ConfigValidationMsg(type, string, key));
        }
    }

    public void validateClassName(@Nonnull ConfigKey key, boolean multiClasses) {
        this.validateClassName(key, multiClasses, null);
    }

    public void validateClassName(@Nonnull ConfigKey key, boolean multiClasses, @Nullable Class<?> assignable) {
        CharSequence charSequence;
        String[][] stringArray = null;
        if (multiClasses) {
            stringArray = this.b.getChangedValue(key, String[][].class);
        }
        if (stringArray == null) {
            charSequence = this.b.getValue(key);
            if (charSequence == null || ((String)charSequence).trim().isEmpty()) {
                return;
            }
            if (multiClasses) {
                String[] stringArray2 = ((String)charSequence).split("[,;]");
                stringArray = new String[stringArray2.length][1];
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    stringArray[i2][0] = stringArray2[i2];
                }
            } else {
                stringArray = new String[][]{{charSequence}};
            }
        }
        if (stringArray.length == 0) {
            return;
        }
        charSequence = new StringBuilder();
        int n2 = 0;
        for (String[] stringArray3 : stringArray) {
            String string = stringArray3[0].trim();
            try {
                Class<?> clazz = LoaderUtils.classForName(string, this);
                if (assignable == null || assignable.isAssignableFrom(clazz)) continue;
                this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.class.assignable", string, assignable), key));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (((StringBuilder)charSequence).length() > 0) {
                    ((StringBuilder)charSequence).append(", ");
                }
                ((StringBuilder)charSequence).append(string);
                ++n2;
            }
            catch (Throwable throwable) {
                if (((StringBuilder)charSequence).length() > 0) {
                    ((StringBuilder)charSequence).append(", ");
                }
                ((StringBuilder)charSequence).append(string + ": " + StringFunctions.getUserFriendlyErrorMessage(throwable));
                ++n2;
            }
        }
        if (n2 > 0) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, n2 == 1 ? "error.validator.class.notfound" : "error.validator.class.notfound.plural", charSequence), key));
        }
    }

    public void validateEmails(@Nonnull ConfigKey key) {
        String string = this.b.getValue(key);
        this.validateEmails(string, key.getKey());
    }

    public void validateEmails(String emails, String configKey) {
        StringTokenizer stringTokenizer = new StringTokenizer(emails, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            this.validateEmail(string, configKey);
        }
    }

    public void validateEmail(String email, String configKey) {
        try {
            if (email == null || email.length() == 0) {
                this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, CoreSystemStructureProvider.INSTANCE.translate(this.b, "error.validator.empty", new Object[0]), configKey));
                return;
            }
            EmailAddressHelper.get().validateSingleAddress(email);
        }
        catch (Exception exception) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, exception.getMessage() + " in " + email, configKey));
        }
    }

    public void validateLocale(@Nonnull ConfigKey key) {
        String string = this.b.getValue(key);
        String string2 = LocaleUtils.checkLocaleString(string);
        if (string2 != null) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, string2, key));
        }
    }

    public void validateURL(@Nonnull ConfigKey key) {
        String string = this.b.getValue(key);
        if (string == null || string.isEmpty()) {
            return;
        }
        this.validateURL(string, key);
    }

    public void validateURL(String urlStr, @Nonnull ConfigKey key) {
        try {
            new URL(urlStr.trim());
        }
        catch (Throwable throwable) {
            this.a.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage(throwable), key));
        }
    }
}

