/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.internal;

import com.inet.cache.CacheStrategy;
import com.inet.cache.CacheTimeoutListener;
import com.inet.cache.StoreMap;
import com.inet.cache.internal.ExternalData;
import com.inet.cache.internal.ExternalDataMapEntry;
import com.inet.cache.internal.ExternalDataWriterFactory;
import com.inet.cache.internal.MemoryExternalDataWriterFactory;
import com.inet.cache.internal.MemoryObserver;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExternalDataMap<K, V>
implements StoreMap<K, V> {
    @Nonnull
    private final ExternalDataWriterFactory<K, V> a;
    private int b;
    private boolean c;
    private Predicate<ExternalDataMapEntry<K, V>> d;
    @Nonnull
    private final CacheStrategy e;
    private Map<K, ExternalDataMapEntry<K, V>> f = new ConcurrentHashMap<K, ExternalDataMapEntry<K, V>>();
    private Set<CacheTimeoutListener<K, V>> g;
    private Set<K> h;
    private Set<Map.Entry<K, V>> i;

    ExternalDataMap(@Nonnull ExternalDataWriterFactory<K, V> factory, @Nonnull CacheStrategy cacheStrategy) {
        this.a = factory;
        this.e = cacheStrategy;
    }

    @Override
    public long swapAll() throws Exception {
        long l2 = 0L;
        for (ExternalDataMapEntry<K, V> externalDataMapEntry : this.f.values()) {
            l2 += this.b(externalDataMapEntry);
        }
        return l2;
    }

    @Override
    public void setTimeout(int timeout, boolean restartTimeoutAfterUse) {
        this.b = timeout;
        this.c = restartTimeoutAfterUse && timeout > 0;
    }

    @Override
    public void setTimeoutCheck(Predicate<ExternalDataMapEntry<K, V>> timeoutCheck) {
        this.d = timeoutCheck;
    }

    Predicate<ExternalDataMapEntry<K, V>> a() {
        return this.d;
    }

    @Override
    @Nonnull
    public CacheStrategy getStrategy() {
        return this.e;
    }

    boolean b() {
        return this.a.getClass() == MemoryExternalDataWriterFactory.class;
    }

    @Nullable
    ExternalData<K, V> a(K k2, V v) throws Exception {
        return this.a.a(k2, v);
    }

    @Override
    public int size() {
        return this.f.size();
    }

    @Override
    public boolean isEmpty() {
        return this.f.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.get(key);
        if (externalDataMapEntry == null) {
            return false;
        }
        if (this.c ? externalDataMapEntry.isExpired(this.b) : externalDataMapEntry.isExpired()) {
            this.a(externalDataMapEntry);
            return false;
        }
        return true;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.get(key);
        if (externalDataMapEntry == null) {
            return null;
        }
        if (this.c ? externalDataMapEntry.isExpired(this.b) : externalDataMapEntry.isExpired()) {
            this.a(externalDataMapEntry);
            return null;
        }
        V v = externalDataMapEntry.getValue();
        MemoryObserver.markUse(externalDataMapEntry);
        return v;
    }

    @Override
    public V getIfInMemeory(Object key) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.get(key);
        if (externalDataMapEntry == null) {
            return null;
        }
        return externalDataMapEntry.a();
    }

    @Override
    public V put(K key, V value) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.get(key);
        if (externalDataMapEntry == null) {
            externalDataMapEntry = new ExternalDataMapEntry<K, V>(key, value, this, this.b);
            this.f.put(key, externalDataMapEntry);
            MemoryObserver.add(externalDataMapEntry);
            return null;
        }
        externalDataMapEntry.resetExpired(this.b);
        MemoryObserver.add(externalDataMapEntry);
        return externalDataMapEntry.setValue(value);
    }

    public void putExternalData(K key, ExternalData<K, V> data) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = new ExternalDataMapEntry<K, V>(key, data, this, this.b);
        this.f.put(key, externalDataMapEntry);
    }

    private long b(ExternalDataMapEntry<K, V> externalDataMapEntry) throws Exception {
        if (externalDataMapEntry == null) {
            return 0L;
        }
        if (externalDataMapEntry.isExpired()) {
            this.a(externalDataMapEntry);
            return 0L;
        }
        return externalDataMapEntry.c();
    }

    @Override
    public long getSwapSize() {
        long l2 = 0L;
        for (Map.Entry<K, ExternalDataMapEntry<K, V>> entry : this.f.entrySet()) {
            l2 += entry.getValue().d();
        }
        return l2;
    }

    @Override
    public long getSwapSize(Object key) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.get(key);
        if (externalDataMapEntry == null) {
            return 0L;
        }
        return externalDataMapEntry.d();
    }

    @Override
    public V remove(Object key) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.remove(key);
        if (externalDataMapEntry != null) {
            externalDataMapEntry.a(true, true);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.a(true);
    }

    void a(boolean bl) {
        for (Map.Entry<K, ExternalDataMapEntry<K, V>> entry : this.f.entrySet()) {
            MemoryObserver.remove(entry.getValue());
        }
        Iterator<Map.Entry<K, ExternalDataMapEntry<K, V>>> iterator = this.f.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, ExternalDataMapEntry<K, V>> entry;
            entry = iterator.next();
            iterator.remove();
            entry.getValue().a(true, bl);
        }
        this.f.clear();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        b b2 = this.h;
        return b2 == null ? (this.h = new b()) : b2;
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public @Nonnull Set<@Nonnull Map.Entry<K, V>> entrySet() {
        a a2 = this.i;
        return a2 == null ? (this.i = new a()) : a2;
    }

    @Override
    public void addTimeoutListener(CacheTimeoutListener<K, V> listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (this.g == null) {
            this.g = ConcurrentHashMap.newKeySet();
        }
        this.g.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(ExternalDataMapEntry<K, V> externalDataMapEntry) {
        boolean bl;
        V v;
        K k2;
        ExternalDataMapEntry<K, V> externalDataMapEntry2 = externalDataMapEntry;
        synchronized (externalDataMapEntry2) {
            k2 = externalDataMapEntry.getKey();
            v = externalDataMapEntry.a();
            bl = externalDataMapEntry.e();
            this.f.remove(k2);
            if (!bl) {
                externalDataMapEntry.a(false, true);
            }
        }
        if (this.g != null && !bl) {
            for (CacheTimeoutListener cacheTimeoutListener : this.g) {
                try {
                    cacheTimeoutListener.timeout(k2, v);
                }
                catch (Throwable throwable) {
                    MemoryObserver.a.error(throwable);
                }
            }
        }
    }

    @Override
    public void resetTimeout(K key) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.get(key);
        if (externalDataMapEntry == null) {
            return;
        }
        if (externalDataMapEntry.isExpired(this.b)) {
            this.a(externalDataMapEntry);
            return;
        }
        MemoryObserver.markUse(externalDataMapEntry);
    }

    @Override
    public long timeout(K key) {
        ExternalDataMapEntry<K, V> externalDataMapEntry = this.f.get(key);
        if (externalDataMapEntry == null) {
            return Long.MAX_VALUE;
        }
        return externalDataMapEntry.timeout();
    }

    @Override
    public long getMemorySize() {
        long l2 = 0L;
        for (Map.Entry<K, ExternalDataMapEntry<K, V>> entry : this.f.entrySet()) {
            l2 += entry.getValue().getMemorySize();
        }
        return l2;
    }

    private class b
    extends AbstractSet<K> {
        private b() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private final Iterator<K> b;
                private K c;
                {
                    HashSet hashSet = new HashSet(ExternalDataMap.this.f.keySet());
                    this.b = hashSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.b.hasNext();
                }

                @Override
                public K next() {
                    this.c = this.b.next();
                    return this.c;
                }

                @Override
                public void remove() {
                    ExternalDataMap.this.remove(this.c);
                    this.b.remove();
                }
            };
        }

        @Override
        public final void clear() {
            ExternalDataMap.this.clear();
        }

        @Override
        public boolean contains(Object o2) {
            return ExternalDataMap.this.containsKey(o2);
        }

        @Override
        public final boolean remove(Object key) {
            boolean bl = ExternalDataMap.this.containsKey(key);
            ExternalDataMap.this.remove(key);
            return bl;
        }

        @Override
        public int size() {
            return ExternalDataMap.this.size();
        }
    }

    private class a
    extends AbstractSet<Map.Entry<K, V>> {
        private a() {
        }

        @Override
        @Nonnull
        public @Nonnull Iterator<@Nonnull Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<ExternalDataMapEntry<K, V>> b;
                private ExternalDataMapEntry<K, V> c;
                {
                    HashSet hashSet = new HashSet();
                    for (Map.Entry entry : ExternalDataMap.this.f.entrySet()) {
                        hashSet.add(entry.getValue());
                    }
                    this.b = hashSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.b.hasNext();
                }

                public Map.Entry<K, V> a() {
                    this.c = this.b.next();
                    return this.c;
                }

                @Override
                public void remove() {
                    ExternalDataMap.this.remove(this.c.getKey());
                    this.b.remove();
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.a();
                }
            };
        }

        @Override
        public void clear() {
            ExternalDataMap.this.clear();
        }

        @Override
        public boolean contains(Object o2) {
            return ExternalDataMap.this.f.values().contains(o2);
        }

        @Override
        public int size() {
            return ExternalDataMap.this.size();
        }

        @Override
        public boolean remove(Object o2) {
            if (o2 instanceof ExternalDataMapEntry) {
                ExternalDataMapEntry externalDataMapEntry = (ExternalDataMapEntry)o2;
                externalDataMapEntry.a(true, true);
                return ExternalDataMap.this.f.remove(externalDataMapEntry.getKey()) != null;
            }
            return false;
        }
    }
}

