/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.image;

import com.inet.annotations.InternalApi;
import com.inet.cache.InetSerializable;
import com.inet.cache.MemorySize;
import com.inet.cache.PersistenceKey;
import com.inet.cache.image.ColorModelSerializer;
import com.inet.cache.image.DummyIntermediateImage;
import com.inet.cache.image.ImageSerializer;
import com.inet.cache.image.RasterSerializer;
import com.inet.classloader.ObjectStreams;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.JPanel;

@InternalApi
public class SerializableImage
extends DummyIntermediateImage
implements InetSerializable<SerializableImage, ImageSerializer>,
MemorySize,
Serializable {
    private static final long serialVersionUID = 8672966296149643075L;
    private static final int UNCOMPRESSED_WRITE_LIMIT = 1000000;
    private static final ImageSerializer a = new ImageSerializer();
    private static final JPanel b = new JPanel();
    private transient Image c;
    private transient byte[] d;
    private transient int e;
    private transient boolean f = false;
    private PersistenceKey g;
    private int h = -1;
    private transient String i;

    public SerializableImage(Image image, byte[] rawData) throws IllegalArgumentException {
        this(image, rawData, null);
    }

    public SerializableImage(Image image, byte[] rawData, @Nullable String originalFormat) throws IllegalArgumentException {
        if (image instanceof SerializableImage) {
            throw new IllegalArgumentException("Do not cascadate SerializableImage");
        }
        if (image == null && (rawData == null || rawData.length == 0)) {
            throw new IllegalArgumentException("image or rawData must not be null.");
        }
        this.c = image;
        this.d = rawData;
        this.i = originalFormat;
        this.f = rawData == null && !this.a(image);
    }

    SerializableImage(Image image, byte[] rawData, PersistenceKey key, @Nullable String originalFormat) {
        this.c = image;
        this.d = rawData;
        this.g = key;
        this.i = originalFormat;
    }

    public SerializableImage getPaintableInstance() {
        return this.f ? new SerializableImage(this.c, this.d, this.g, this.i) : this;
    }

    @Override
    public String toString() {
        if (this.c != null) {
            return "Image(" + this.c.getWidth(null) + "x" + this.c.getHeight(null) + ")";
        }
        return (this.c != null ? this.c.toString() : "No image") + " | " + (this.d != null ? "Has data" : "No raw data");
    }

    @Override
    public void addTileObserver(TileObserver to) {
        this.getBufferedImage().addTileObserver(to);
    }

    @Override
    public void coerceData(boolean isAlphaPremultiplied) {
        this.getBufferedImage().coerceData(isAlphaPremultiplied);
    }

    @Override
    public WritableRaster copyData(WritableRaster outRaster) {
        return this.getBufferedImage().copyData(outRaster);
    }

    @Override
    public Graphics2D createGraphics() {
        return this.getBufferedImage().createGraphics();
    }

    @Override
    public WritableRaster getAlphaRaster() {
        return this.getBufferedImage().getAlphaRaster();
    }

    @Override
    public ColorModel getColorModel() {
        return this.getBufferedImage().getColorModel();
    }

    @Override
    public Raster getData() {
        return this.getBufferedImage().getData();
    }

    @Override
    public Raster getData(Rectangle rect) {
        return this.getBufferedImage().getData(rect);
    }

    @Override
    public int getHeight() {
        return this.getBufferedImage().getHeight();
    }

    @Override
    public int getMinTileX() {
        return this.getBufferedImage().getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.getBufferedImage().getMinTileY();
    }

    @Override
    public int getMinX() {
        return this.getBufferedImage().getMinX();
    }

    @Override
    public int getMinY() {
        return this.getBufferedImage().getMinY();
    }

    @Override
    public int getNumXTiles() {
        return this.getBufferedImage().getNumXTiles();
    }

    @Override
    public int getNumYTiles() {
        return this.getBufferedImage().getNumYTiles();
    }

    @Override
    public Object getProperty(String name) {
        return this.getBufferedImage().getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.getBufferedImage().getPropertyNames();
    }

    @Override
    public int[] getRGB(int startX, int startY, int w, int h2, int[] rgbArray, int offset, int scansize) {
        return this.getBufferedImage().getRGB(startX, startY, w, h2, rgbArray, offset, scansize);
    }

    @Override
    public int getRGB(int x, int y) {
        return this.getBufferedImage().getRGB(x, y);
    }

    @Override
    public WritableRaster getRaster() {
        return this.getBufferedImage().getRaster();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.getBufferedImage().getSampleModel();
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.getBufferedImage().getSources();
    }

    @Override
    public BufferedImage getSubimage(int x, int y, int w, int h2) {
        return this.getBufferedImage().getSubimage(x, y, w, h2);
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return this.getBufferedImage().getTile(tileX, tileY);
    }

    @Override
    public int getTileGridXOffset() {
        return this.getBufferedImage().getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset() {
        return this.getBufferedImage().getTileGridYOffset();
    }

    @Override
    public int getTileHeight() {
        return this.getBufferedImage().getTileHeight();
    }

    @Override
    public int getTileWidth() {
        return this.getBufferedImage().getTileWidth();
    }

    @Override
    public int getTransparency() {
        return this.getBufferedImage().getTransparency();
    }

    @Override
    public int getType() {
        return this.getBufferedImage().getType();
    }

    @Override
    public int getWidth() {
        return this.getBufferedImage().getWidth();
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        return this.getBufferedImage().getWritableTile(tileX, tileY);
    }

    @Override
    public Point[] getWritableTileIndices() {
        return this.getBufferedImage().getWritableTileIndices();
    }

    @Override
    public boolean hasTileWriters() {
        return this.getBufferedImage().hasTileWriters();
    }

    @Override
    public boolean isAlphaPremultiplied() {
        return this.getBufferedImage().isAlphaPremultiplied();
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        return this.getBufferedImage().isTileWritable(tileX, tileY);
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        this.getBufferedImage().releaseWritableTile(tileX, tileY);
    }

    @Override
    public void removeTileObserver(TileObserver to) {
        this.getBufferedImage().removeTileObserver(to);
    }

    @Override
    public void setData(Raster r) {
        this.getBufferedImage().setData(r);
    }

    @Override
    public void setRGB(int startX, int startY, int w, int h2, int[] rgbArray, int offset, int scansize) {
        this.getBufferedImage().setRGB(startX, startY, w, h2, rgbArray, offset, scansize);
    }

    @Override
    public synchronized void setRGB(int x, int y, int rgb) {
        this.getBufferedImage().setRGB(x, y, rgb);
    }

    @Override
    public void flush() {
        this.getBufferedImage().flush();
    }

    @Override
    public float getAccelerationPriority() {
        return this.getBufferedImage().getAccelerationPriority();
    }

    @Override
    public ImageCapabilities getCapabilities(GraphicsConfiguration gc) {
        return this.getBufferedImage().getCapabilities(gc);
    }

    @Override
    public Image getScaledInstance(int width, int height, int hints) {
        return this.getBufferedImage().getScaledInstance(width, height, hints);
    }

    @Override
    public void setAccelerationPriority(float priority) {
        this.getBufferedImage().setAccelerationPriority(priority);
    }

    private void a() {
        Object object = this.c;
        if (this.d == null && object != null && !this.a((Image)object)) {
            Transparency transparency;
            int n2 = 2;
            if (object instanceof BufferedImage && !((ColorModel)(transparency = ((BufferedImage)object).getColorModel())).hasAlpha()) {
                n2 = 5;
                object = Toolkit.getDefaultToolkit().createImage(((BufferedImage)object).getSource());
            }
            transparency = new BufferedImage(this.getWidth(), this.getHeight(), n2);
            Graphics graphics = ((BufferedImage)transparency).getGraphics();
            graphics.drawImage((Image)object, 0, 0, null);
            graphics.dispose();
            object = transparency;
            this.f = false;
            this.c = object;
            this.e = 0;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.d == null) {
            this.a();
            BufferedImage bufferedImage = (BufferedImage)this.c;
            stream.writeBoolean(true);
            boolean bl = bufferedImage.getWidth() * bufferedImage.getHeight() > 1000000;
            stream.writeBoolean(bl);
            if (bl) {
                ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)stream, StandardCharsets.UTF_8);
                zipOutputStream.putNextEntry(new ZipEntry("raster"));
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
                RasterSerializer.write(bufferedImage.getRaster(), objectOutputStream);
                objectOutputStream.flush();
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry("colormodel"));
                ColorModelSerializer.write(bufferedImage.getColorModel(), objectOutputStream);
                objectOutputStream.flush();
                zipOutputStream.closeEntry();
            } else {
                RasterSerializer.write(bufferedImage.getRaster(), stream);
                ColorModelSerializer.write(bufferedImage.getColorModel(), stream);
            }
        } else {
            stream.writeBoolean(false);
            this.getRawData();
            if (this.c instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)this.c;
                if (bufferedImage.getColorModel().hasAlpha()) {
                    stream.writeInt(-2);
                } else {
                    ColorModel colorModel = bufferedImage.getColorModel();
                    int n2 = colorModel.getNumComponents();
                    int n3 = 1;
                    if (n2 == 1) {
                        n3 = 1;
                    } else if (n2 == 4) {
                        n3 = 2;
                    }
                    stream.writeInt(-n3);
                }
            }
            stream.writeInt(this.d.length);
            stream.write(this.d);
        }
        stream.writeUTF(this.i == null ? "" : this.i);
    }

    private boolean a(Image image) {
        return image instanceof BufferedImage && RasterSerializer.canWrite(((BufferedImage)image).getRaster()) && ColorModelSerializer.canWrite(((BufferedImage)image).getColorModel());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (stream.readBoolean()) {
            ColorModel colorModel;
            WritableRaster writableRaster;
            var2_2 = stream.readBoolean();
            if (var2_2 != 0) {
                ZipInputStream zipInputStream = new ZipInputStream(stream);
                zipInputStream.getNextEntry();
                stream = new ObjectStreams.CacheObjectInputStream(zipInputStream);
                writableRaster = RasterSerializer.read(stream);
                zipInputStream.getNextEntry();
                colorModel = ColorModelSerializer.read(stream);
            } else {
                writableRaster = RasterSerializer.read(stream);
                colorModel = ColorModelSerializer.read(stream);
            }
            this.c = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        } else {
            var2_2 = stream.readInt();
            if (var2_2 < 0) {
                this.h = Math.abs(var2_2);
                var2_2 = stream.readInt();
            }
            this.d = new byte[var2_2];
            stream.readFully(this.d);
        }
        if (stream.available() > 0) {
            String string = stream.readUTF();
            this.i = StringFunctions.isEmpty(string) ? null : string;
        }
    }

    public byte[] getRawData() throws IllegalStateException {
        if (this.d == null) {
            Object object;
            Object object2;
            if (this.c instanceof RenderedImage) {
                object2 = (RenderedImage)((Object)this.c);
            } else {
                object = new BufferedImage(this.c.getWidth(null), this.c.getHeight(null), 2);
                Graphics graphics = ((BufferedImage)object).getGraphics();
                graphics.drawImage(this.c, 0, 0, null);
                graphics.dispose();
                object2 = object;
            }
            object = new FastByteArrayOutputStream();
            boolean bl = true;
            int n2 = object2.getSampleModel().getNumBands();
            try {
                if (n2 == 4 || object2.getColorModel().hasAlpha()) {
                    bl = ImageIO.write((RenderedImage)object2, "png", new MemoryCacheImageOutputStream((OutputStream)object));
                } else {
                    this.a((RenderedImage)object2, (OutputStream)object);
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!bl) {
                BufferedImage bufferedImage = new BufferedImage(object2.getWidth(), object2.getHeight(), n2 == 4 ? 2 : 1);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage((Image)object2, 0, 0, null);
                graphics.dispose();
                bl = true;
                try {
                    if (n2 == 4) {
                        bl = ImageIO.write((RenderedImage)bufferedImage, "png", new MemoryCacheImageOutputStream((OutputStream)object));
                    } else {
                        this.a(bufferedImage, (OutputStream)object);
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException);
                }
                if (!bl) {
                    throw new IllegalStateException("Unable to write image '" + String.valueOf(object2) + "', most likely an approriate writer SPI is missing.");
                }
            }
            this.d = ((FastByteArrayOutputStream)object).toByteArray();
            this.e = 0;
        }
        return this.d;
    }

    public boolean hasRawData() {
        return this.d != null;
    }

    public Long getContentHashCode() {
        Object object;
        Object object2;
        if (this.d != null) {
            return Arrays.hashCode(this.d);
        }
        if (this.c == null) {
            return null;
        }
        if (this.c.getWidth(null) * this.c.getHeight(null) > 1000000) {
            return null;
        }
        Object object3 = this.c;
        if (!this.a((Image)object3)) {
            boolean bl = true;
            if (object3 instanceof BufferedImage) {
                bl = ((BufferedImage)object3).getColorModel().hasAlpha();
            }
            object2 = new BufferedImage(this.getWidth(), this.getHeight(), bl ? 2 : 5);
            object = ((BufferedImage)object2).getGraphics();
            ((Graphics)object).drawImage(this.getImage(), 0, 0, null);
            ((Graphics)object).dispose();
            object3 = object2;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object2 = new ObjectOutputStream(byteArrayOutputStream);
            object = (BufferedImage)object3;
            RasterSerializer.write(((BufferedImage)object).getRaster(), (ObjectOutputStream)object2);
            ColorModelSerializer.write(((BufferedImage)object).getColorModel(), (ObjectOutputStream)object2);
        }
        catch (IOException iOException) {
            return null;
        }
        return Arrays.hashCode(byteArrayOutputStream.toByteArray());
    }

    private void a(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(0.9f);
        imageWriter.setOutput(new MemoryCacheImageOutputStream(outputStream));
        IIOImage iIOImage = new IIOImage(renderedImage, null, null);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageWriter.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() throws IllegalStateException {
        if (this.c == null) {
            SerializableImage serializableImage = this;
            synchronized (serializableImage) {
                block13: {
                    if (this.c != null) {
                        return this.c;
                    }
                    try {
                        Image image = Toolkit.getDefaultToolkit().createImage(new URL("http", "localhost", 9900, "/someImage", new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL u) throws IOException {
                                return new URLConnection(u){

                                    @Override
                                    public void connect() throws IOException {
                                    }

                                    @Override
                                    public InputStream getInputStream() throws IOException {
                                        return new ByteArrayInputStream(SerializableImage.this.d);
                                    }
                                };
                            }
                        }));
                        MediaTracker mediaTracker = new MediaTracker(b);
                        mediaTracker.addImage(image, 0);
                        long l2 = System.currentTimeMillis();
                        mediaTracker.waitForAll(5000L);
                        if (mediaTracker.isErrorAny()) {
                            try {
                                this.c = ImageIO.read(new FastByteArrayInputStream(this.d));
                                break block13;
                            }
                            catch (IOException iOException) {
                                long l3 = System.currentTimeMillis();
                                this.c = null;
                                String string = "";
                                if (this.d.length > 0 && LogManager.getApplicationLogger().isDebug()) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    for (int i2 = 0; i2 < Math.min(16, this.d.length); ++i2) {
                                        byte by = this.d[i2];
                                        stringBuilder.append(Integer.toHexString(by) + "(" + (char)by + ") ");
                                    }
                                    string = stringBuilder.toString();
                                }
                                throw new IllegalStateException("Image data can not be read. Read time was " + (l3 - l2) + "ms, " + this.d.length + " bytes in buffer" + (String)(string.length() > 0 ? ": " + string : ""));
                            }
                        }
                        this.c = image;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new IllegalStateException(malformedURLException);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IllegalStateException(interruptedException);
                    }
                }
                this.e = 0;
            }
        }
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getBufferedImage() {
        if (this.c instanceof BufferedImage) {
            return (BufferedImage)this.c;
        }
        if (this.c == null && this.d == null) {
            throw new NullPointerException("There is no image data");
        }
        this.getImage();
        SerializableImage serializableImage = this;
        synchronized (serializableImage) {
            if (this.c instanceof BufferedImage) {
                return (BufferedImage)this.c;
            }
            int n2 = 2;
            if (this.h >= 0) {
                n2 = this.h;
            }
            BufferedImage bufferedImage = new BufferedImage(this.c.getWidth(null), this.c.getHeight(null), n2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(this.c, 0, 0, null);
            graphics.dispose();
            this.c = bufferedImage;
            this.e = 0;
        }
        return (BufferedImage)this.c;
    }

    @Override
    public long getSizeInMemory() {
        if (this.e > 0) {
            return this.e;
        }
        int n2 = 628;
        n2 += 864;
        if (this.c != null) {
            n2 += 187;
            if (this.c instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)this.c;
                WritableRaster writableRaster = bufferedImage.getRaster();
                DataBuffer dataBuffer = writableRaster.getDataBuffer();
                int n3 = 1;
                switch (dataBuffer.getDataType()) {
                    case 0: {
                        n3 = 1;
                        break;
                    }
                    case 3: {
                        n3 = 4;
                        break;
                    }
                    case 5: {
                        n3 = 8;
                        break;
                    }
                    case 4: {
                        n3 = 4;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                    }
                }
                n2 += writableRaster.getNumDataElements() * n3;
                n2 += dataBuffer.getSize() * n3;
                n2 += 408;
            } else {
                n2 += this.getWidth() * this.getHeight() * this.getColorModel().getNumComponents();
            }
        }
        if (this.d != null) {
            n2 += this.d.length + 24;
        }
        this.e = n2;
        return n2;
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.getBufferedImage().getWidth(observer);
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.getBufferedImage().getHeight(observer);
    }

    @Override
    public ImageProducer getSource() {
        return this.getBufferedImage().getSource();
    }

    @Override
    public Graphics getGraphics() {
        throw new IllegalStateException("Not supported call for this immutable image");
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        return this.getBufferedImage().getProperty(name, observer);
    }

    @Nullable
    public PersistenceKey getPersistenceKey() {
        return this.g;
    }

    public void setPersistenceKey(@Nullable PersistenceKey key) {
        this.g = key;
    }

    @Override
    public ImageSerializer getSerializer() {
        this.a();
        return a;
    }

    @Nullable
    public String getOriginalFormat() {
        return this.i;
    }
}

