/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.font;

import com.inet.cache.InetSerializable;
import com.inet.cache.MemorySize;
import com.inet.cache.PersistenceKey;
import com.inet.cache.font.GeneralFontSerializer;
import com.inet.cache.font.SerializableDerivedFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.HashMap;

public class SerializableGeneralFont
extends Font
implements InetSerializable<SerializableGeneralFont, GeneralFontSerializer>,
MemorySize,
Serializable {
    private static final GeneralFontSerializer a = new GeneralFontSerializer();
    private final byte[] b;
    private transient Integer c;
    private final PersistenceKey d;

    public SerializableGeneralFont(byte[] fontData, PersistenceKey persistenceKey) throws FontFormatException, IOException {
        super(Font.createFont(0, new ByteArrayInputStream(fontData)));
        this.b = fontData;
        this.d = persistenceKey;
    }

    public byte[] getFontData() {
        return this.b;
    }

    public PersistenceKey getPersistenceKey() {
        return this.d;
    }

    public SerializableDerivedFont deriveSerializableFont(HashMap<TextAttribute, Object> attributes) {
        return new SerializableDerivedFont(this.deriveFont(attributes), this.d, this.b, attributes);
    }

    @Override
    public GeneralFontSerializer getSerializer() {
        return a;
    }

    @Override
    public int hashCode() {
        if (this.c != null) {
            return this.c;
        }
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Arrays.hashCode(this.b);
        n3 = 31 * n3 + (this.d == null ? 0 : this.d.hashCode());
        this.c = n3;
        return n3;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableGeneralFont serializableGeneralFont = (SerializableGeneralFont)obj;
        if (!Arrays.equals(this.b, serializableGeneralFont.b)) {
            return false;
        }
        return !(this.d == null ? serializableGeneralFont.d != null : !this.d.equals(serializableGeneralFont.d));
    }

    private Object writeReplace() {
        return new SerilazitationReplacement(this);
    }

    @Override
    public long getSizeInMemory() {
        return this.b.length;
    }

    public static class SerilazitationReplacement
    implements Serializable {
        private byte[] a;
        private String b;

        public SerilazitationReplacement() {
        }

        public SerilazitationReplacement(SerializableGeneralFont font) {
            this.a = font.getFontData();
            this.b = font.getPersistenceKey().keyValue();
        }

        public Object readResolve() throws ObjectStreamException {
            try {
                return new SerializableGeneralFont(this.a, PersistenceKey.create(this.b));
            }
            catch (FontFormatException | IOException exception) {
                throw new StreamCorruptedException(exception.getMessage());
            }
        }
    }
}

