/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model.controls;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.controls.ControlElement;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public class ControlList
extends ControlElement {
    public static final int NO_DIFFS_FOUND = 0;
    public static final int SELECTED_ENTRIES_DIFFER = 1;
    public static final int NUMBERS_OF_ENTRIES_DIFFER = 2;
    public static final int LIST_ENTRIES_DIFFER = 3;
    private List<Option> options;

    public ControlList(List<Option> options, int selectedOption, String fieldName, String fieldValue, int pageIndex, Rectangle2D bounds, ElementID id) {
        super(fieldName, fieldValue, pageIndex, bounds, id);
        this.options = options;
        this.setStateID(selectedOption);
    }

    @Override
    public ElementType getType() {
        return ElementType.ControlList;
    }

    public int compareWith(ControlList otherList) {
        int size;
        String selectedEntry = this.getFieldValue();
        String selectedEntryInOtherControl = otherList.getFieldValue();
        if (selectedEntry != null ? selectedEntryInOtherControl == null || !selectedEntry.equals(selectedEntryInOtherControl) : selectedEntryInOtherControl != null) {
            return 1;
        }
        int n = size = this.options != null ? this.options.size() : 0;
        if (otherList.options.size() != size) {
            return 2;
        }
        for (int i = 0; i < size; ++i) {
            int j;
            String opt1 = this.options.get(i).getExportValue();
            for (j = 0; j < size && !otherList.options.get(i).getExportValue().equals(opt1); ++j) {
            }
            if (j != size) continue;
            return 3;
        }
        return 0;
    }

    @Override
    public int getCompareHash() {
        return 4713;
    }

    @InternalApi
    public static class Option {
        private String displayName;
        private String value;

        public Option(String displayName, String value) {
            this.displayName = displayName;
            this.value = value;
        }

        @Nonnull
        public String getExportValue() {
            return this.displayName != null ? this.displayName : this.value;
        }
    }
}

