/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.util.PdfcImageIO;
import com.inet.shared.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Properties;

@JsonData
@InternalApi
public class ImageMetaData
extends Properties {
    private static int[] rgbTyps = new int[]{5, 6, 7, 2, 3, 4, 1, 9, 8};
    private static int[] alphaTyps = new int[]{6, 7, 2, 3};
    private static int[] grayTyps = new int[]{10, 11, 12};

    public void setMeta(BufferedImage image, Properties metaInfoImage) {
        String[] formats = new String[]{"TIFF", "PNG", "JPG"};
        if (this.get((Object)KEY.FORMAT) == null) {
            for (String format : formats) {
                if (metaInfoImage.get("javax_imageio_" + format.toLowerCase() + "_image") == null) continue;
                this.put((Object)KEY.FORMAT, format);
                break;
            }
        }
        if (this.get((Object)KEY.COLORMODEL) == null) {
            for (int rgb : rgbTyps) {
                if (image.getType() != rgb) continue;
                this.put((Object)KEY.COLORMODEL, "RGB");
            }
            for (int gray : grayTyps) {
                if (image.getType() != gray) continue;
                this.put((Object)KEY.COLORMODEL, "GRAY");
            }
            for (int alpha : alphaTyps) {
                if (image.getType() != alpha) continue;
                this.put((Object)KEY.ALPHAMASK, (Object)true);
            }
            if (this.get((Object)KEY.ALPHAMASK) == null) {
                this.put((Object)KEY.ALPHAMASK, (Object)false);
            }
        }
        if (this.get((Object)KEY.DPI_X) == null) {
            Object object = metaInfoImage.get("javax_imageio_1.0.HorizontalPixelSize");
            if (object != null) {
                this.put((Object)KEY.DPI_X, (Object)Math.round(25.4f / Float.parseFloat((String)object)));
            } else {
                Object object2 = metaInfoImage.get("javax_imageio_1.0.Dimension.HorizontalPixelSize");
                if (object2 != null) {
                    this.put((Object)KEY.DPI_X, (Object)Math.round(25.4f / Float.parseFloat((String)object2)));
                }
            }
        }
        if (this.get((Object)KEY.DPI_Y) == null) {
            Object object = metaInfoImage.get("javax_imageio_1.0.VerticalPixelSize");
            if (object != null) {
                this.put((Object)KEY.DPI_Y, (Object)Math.round(25.4f / Float.parseFloat((String)object)));
            } else {
                Object object3 = metaInfoImage.get("javax_imageio_1.0.Dimension.VerticalPixelSize");
                if (object3 != null) {
                    this.put((Object)KEY.DPI_Y, (Object)Math.round(25.4f / Float.parseFloat((String)object3)));
                }
            }
        }
        if (this.get((Object)KEY.DPI_X) != null && this.get((Object)KEY.DPI_Y) != null) {
            int n = (Integer)this.get((Object)KEY.DPI_X);
            int dpiY = (Integer)this.get((Object)KEY.DPI_Y);
            int dpi = n > 0 ? (dpiY > 0 ? (n + dpiY) / 2 : n) : (dpiY > 0 ? dpiY : -1);
            this.put((Object)KEY.DPI, (Object)dpi);
        }
    }

    public void setDPI(int dpi) {
        this.put((Object)KEY.DPI, (Object)dpi);
    }

    public void setFormat(byte[] imageData) {
        this.put((Object)KEY.FORMAT, ImageMetaData.detectImageFormat(imageData));
        try {
            PdfcImageIO.ImageWithMeta withMeta = PdfcImageIO.readImage(new ByteArrayInputStream(imageData));
            if (withMeta != null) {
                this.setMeta(withMeta.getImage(), withMeta.getMeta());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String detectImageFormat(byte[] imageData) {
        String format = ImageUtils.detectImageFormat(imageData);
        if (format.equals("unknow")) {
            return Msg.getMsg("ImageElement.Meta.Unknown");
        }
        return format;
    }

    @InternalApi
    public static enum KEY {
        DPI,
        DPI_X,
        DPI_Y,
        FORMAT,
        COLORMODEL,
        ALPHAMASK;

    }
}

