/*
 * Decompiled with CFR 0.152.
 */
package com.inet.logging;

import com.inet.annotations.InternalApi;
import com.inet.logging.LogLevel;
import com.inet.logging.Logger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;

@InternalApi
public abstract class AbstractStaticLogger
implements Logger {
    @Nonnull
    private final String module;
    private int logLevel;
    BiPredicate<LogLevel, Object>[] filters;

    public AbstractStaticLogger(@Nonnull String module) {
        this.module = module;
        this.logLevel = 1;
    }

    @Nonnull
    public String getName() {
        return this.module;
    }

    @Override
    public void status(Object message) {
        this.log(LogLevel.STATUS, null, message);
    }

    @Override
    public void status(String prefix, Object message) {
        this.log(LogLevel.STATUS, prefix, message);
    }

    @Override
    public void debug(Object message) {
        this.log(LogLevel.DEBUG, null, message);
    }

    @Override
    public void debug(String prefix, Object message) {
        this.log(LogLevel.DEBUG, prefix, message);
    }

    @Override
    public void error(Object message) {
        this.log(LogLevel.ERROR, null, message);
    }

    @Override
    public void error(String prefix, Object message) {
        this.log(LogLevel.ERROR, prefix, message);
    }

    @Override
    public void error(Throwable th) {
        if (th != null && AbstractStaticLogger.isClientAbort(th)) {
            this.debug(th);
        } else {
            this.error((Object)th);
        }
    }

    @Override
    public void error(String prefix, Throwable th) {
        if (th != null && AbstractStaticLogger.isClientAbort(th)) {
            this.debug(prefix, th);
        } else {
            this.error(prefix, (Object)th);
        }
    }

    @Override
    public void fatal(Object message) {
        this.log(LogLevel.FATAL, null, message);
    }

    @Override
    public void info(Object message) {
        this.log(LogLevel.INFO, null, message);
    }

    @Override
    public void info(String prefix, Object message) {
        this.log(LogLevel.INFO, prefix, message);
    }

    @Override
    public void warn(Object message) {
        this.log(LogLevel.WARN, null, message);
    }

    @Override
    public void warn(String prefix, Object message) {
        this.log(LogLevel.WARN, prefix, message);
    }

    protected abstract void log(LogLevel var1, String var2, Object var3);

    @Override
    public void setLogLevel(int level) {
        if (level < -1 || level > 4) {
            throw new IllegalArgumentException(String.valueOf(level));
        }
        this.logLevel = level;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public boolean isDebug() {
        return this.logLevel >= 4;
    }

    @Override
    public boolean isInfo() {
        return this.logLevel >= 3;
    }

    @Override
    public boolean isWarning() {
        return this.logLevel >= 2;
    }

    @Override
    public boolean isError() {
        return this.logLevel >= 1;
    }

    public synchronized void addFilter(@Nonnull BiPredicate<LogLevel, Object> filter) {
        BiPredicate<LogLevel, Object>[] filterArray = this.filters;
        if (filterArray == null) {
            filterArray = new BiPredicate[]{Objects.requireNonNull(filter)};
        } else {
            int length = filterArray.length;
            filterArray = Arrays.copyOf(filterArray, length + 1);
            filterArray[length] = Objects.requireNonNull(filter);
        }
        this.filters = filterArray;
    }

    public static boolean isClientAbort(@Nonnull Throwable th) {
        Throwable cause;
        Class<?> clazz = th.getClass();
        switch (clazz.getName()) {
            case "org.eclipse.jetty.server.internal.HttpConnection$HttpEofException": 
            case "java.nio.channels.ClosedChannelException": 
            case "org.eclipse.jetty.io.EofException": 
            case "org.apache.catalina.connector.ClientAbortException": 
            case "org.eclipse.jetty.websocket.core.exception.WebSocketWriteTimeoutException": {
                return true;
            }
            case "java.lang.RuntimeException": {
                Throwable cause2 = th.getCause();
                return cause2 != null && AbstractStaticLogger.isClientAbort(cause2);
            }
        }
        return clazz == IOException.class && (cause = th.getCause()) != null && cause.getClass() == TimeoutException.class;
    }
}

