/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.json.BaseParser;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonTypeResolver;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class JsonParser
extends BaseParser {
    private final Reader reader;
    private boolean usePrevious;
    private int previous;
    private final StringBuilder cachesBuilder = new StringBuilder();

    JsonParser(@Nonnull Reader reader, @Nullable Map<Object, Map<String, String>> extraFields, @Nonnull JsonTypeResolver typeResolver) {
        super(extraFields, typeResolver, new Function<Object, Object>(){
            private HashMap<Object, Object> objectPool = new HashMap();

            @Override
            @Nonnull
            public Object apply(@Nonnull Object obj) {
                Object old = this.objectPool.get(obj);
                if (old != null) {
                    return old;
                }
                this.objectPool.put(obj, obj);
                return obj;
            }
        });
        this.reader = reader;
    }

    Object[] parseValues(@Nonnull Type[] types) throws IOException, JsonException {
        Object[] result = new Object[types.length];
        int ch = this.readNonSpace();
        if (ch == 91) {
            block5: for (int i = 0; i < types.length; ++i) {
                result[i] = this.parseValue(types[i], null);
                ch = this.readNonSpace();
                switch (ch) {
                    case 44: {
                        if (i < types.length - 1) continue block5;
                        throw new JsonException("Unexpected character: " + (char)ch);
                    }
                    case 93: {
                        if (i >= types.length - 1) continue block5;
                        throw new JsonException("Unexpected character: " + (char)ch);
                    }
                    case -1: {
                        throw new EOFException("Unexpected end of stream");
                    }
                    default: {
                        throw new JsonException("Unexpected character: " + (char)ch + " [" + ch + "]");
                    }
                }
            }
            return result;
        }
        if (ch == -1) {
            throw new EOFException("Unexpected end of stream, no data at all");
        }
        throw new JsonException("Unexpected character: " + (char)ch + " [" + ch + "]");
    }

    Object parseValue(@Nonnull Type type, @Nullable Type parentType) throws IOException {
        int ch = this.readNonSpace();
        switch (ch) {
            case -1: {
                throw new EOFException("Unexpected end of JSON data");
            }
            case 34: 
            case 39: {
                return this.convertQuoteValue(this.readQuote((char)ch), type);
            }
            case 123: {
                return this.parseObject(type, parentType);
            }
            case 91: {
                return this.parseArray(type, parentType);
            }
        }
        this.back(ch);
        return this.convertNonquotedValue(this.readValue(), type);
    }

    Object parseObject(@Nonnull Type type, @Nullable Type parentType) throws IOException {
        Object valueGenericType;
        Class<Object> keyGenericType;
        int objectType;
        Object obj;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type, parentType);
        if (wrapper.hasGetTypeFor()) {
            obj = new BaseParser.JsonObject(this, wrapper);
            objectType = 2;
            keyGenericType = String.class;
            valueGenericType = null;
        } else {
            if (type == Object.class) {
                wrapper = ClassWrapper.getWrapper(Map.class, parentType);
            }
            if ((obj = wrapper.create()) instanceof Map) {
                objectType = 1;
                @Nonnull Type @Nullable [] types = wrapper.getTypeArguments();
                if (types != null) {
                    keyGenericType = types[0];
                    valueGenericType = types[1];
                } else {
                    valueGenericType = Object.class;
                    keyGenericType = Object.class;
                }
            } else {
                objectType = 0;
                keyGenericType = String.class;
                valueGenericType = null;
            }
        }
        boolean isFirst = true;
        block13: while (true) {
            int ch = this.readNonSpace();
            switch (ch) {
                case -1: {
                    throw new EOFException("Unexpected end of JSON data");
                }
                case 125: {
                    if (objectType == 2) {
                        return ((BaseParser.JsonObject)obj).create();
                    }
                    return obj;
                }
                case 44: {
                    if (!isFirst) {
                        isFirst = true;
                        continue block13;
                    }
                    throw new JsonException("Unexpected character: " + (char)ch);
                }
            }
            this.back(ch);
            Object key = this.parseValue((Type)((Object)keyGenericType), parentType);
            ch = this.readNonSpace();
            if (ch != 58) {
                throw new JsonException("Expected a character ':' after a key name.");
            }
            try {
                switch (objectType) {
                    default: {
                        Field field = wrapper.findField(String.valueOf(key));
                        if (field == null) {
                            this.saveExtraField(obj, String.valueOf(key));
                            break;
                        }
                        Type fieldType = this.typeResolver.getGenericType(obj, field);
                        Object value = this.parseValue(fieldType, type);
                        try {
                            field.set(obj, value);
                        }
                        catch (IllegalAccessException ex) {
                            ex.printStackTrace(Json.getErrorStream());
                        }
                        break;
                    }
                    case 1: {
                        Type valueGenericType_ = this.typeResolver.getMapValueType(key, (Type)valueGenericType);
                        Object value = this.parseValue(valueGenericType_, type);
                        ((Map)obj).put(key, value);
                        break;
                    }
                    case 2: {
                        Field field = wrapper.findField(String.valueOf(key));
                        if (field == null) {
                            ((BaseParser.JsonObject)obj).extraFieldValues.put(String.valueOf(key), this.readJson());
                            break;
                        }
                        Type fieldType = field.getGenericType();
                        Object value = this.parseValue(fieldType, type);
                        ((BaseParser.JsonObject)obj).fieldValues.put(String.valueOf(key), value.toString());
                    }
                }
            }
            catch (Exception ex) {
                String message = "Can't parse value for field '" + String.valueOf(key) + "' in type '" + type.getTypeName() + "'";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    message = message + "\n" + cause.toString();
                }
                throw new JsonException(message, ex);
            }
            isFirst = false;
        }
    }

    @Override
    String parseExtraFieldValue() throws JsonException, IOException {
        return this.readJson();
    }

    private Object parseArray(@Nonnull Type type, Type parentType) throws IOException {
        Class elementType;
        Class<?> elementClass;
        Collection<Object> list;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type, parentType);
        Class<?> clazz = wrapper.getClazz();
        @Nonnull Type[] types = wrapper.getTypeArguments();
        if (clazz.isArray()) {
            list = new ArrayList();
            elementClass = clazz.getComponentType();
            elementType = types != null ? types[0] : elementClass;
        } else if (type == Object.class) {
            list = new ArrayList();
            elementClass = null;
            elementType = Object.class;
        } else {
            elementClass = null;
            elementType = types != null ? types[0] : Object.class;
            list = (Collection)ClassWrapper.getWrapper(type, parentType).create();
        }
        boolean isFirst = true;
        block5: while (true) {
            int ch = this.readNonSpace();
            switch (ch) {
                case -1: {
                    throw new EOFException("Unexpected end of JSON data");
                }
                case 93: {
                    if (elementClass != null) {
                        int length = list.size();
                        Object result = Array.newInstance(elementClass, length);
                        int i = 0;
                        for (Object value : list) {
                            Array.set(result, i++, value);
                        }
                        return result;
                    }
                    return list;
                }
                case 44: {
                    if (!isFirst) {
                        isFirst = true;
                        continue block5;
                    }
                    throw new JsonException("Unexpected character: " + (char)ch);
                }
            }
            this.back(ch);
            list.add(this.parseValue(this.typeResolver.getCollectionValueType(list, (Type)((Object)elementType)), parentType));
            isFirst = false;
        }
    }

    private int readNonSpace() throws IOException {
        int ch;
        block4: while (true) {
            ch = this.read();
            switch (ch) {
                case -1: {
                    return ch;
                }
                case 160: {
                    continue block4;
                }
            }
            if (ch > 32) break;
        }
        return ch;
    }

    private int read() throws IOException {
        if (this.usePrevious) {
            this.usePrevious = false;
            return this.previous;
        }
        return this.reader.read();
    }

    private void back(int ch) {
        this.previous = ch;
        this.usePrevious = true;
    }

    private String readQuote(char quote) throws IOException {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        while (true) {
            int ch = this.read();
            block0 : switch (ch) {
                case -1: 
                case 10: 
                case 13: {
                    throw new JsonException("Quotation mark not closed.");
                }
                case 92: {
                    int ch2;
                    int i;
                    ch = this.read();
                    switch (ch) {
                        case 98: {
                            builder.append('\b');
                            break block0;
                        }
                        case 102: {
                            builder.append('\f');
                            break block0;
                        }
                        case 110: {
                            builder.append('\n');
                            break block0;
                        }
                        case 114: {
                            builder.append('\r');
                            break block0;
                        }
                        case 116: {
                            builder.append('\t');
                            break block0;
                        }
                        case 117: {
                            StringBuilder sb = new StringBuilder();
                            for (int i2 = 0; i2 < 4; ++i2) {
                                sb.append((char)this.read());
                            }
                            builder.append((char)Integer.parseInt(sb.toString(), 16));
                            break block0;
                        }
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            builder.append((char)ch);
                            break block0;
                        }
                    }
                    builder.insert(0, quote);
                    builder.append('\\');
                    int length = builder.length();
                    builder.append((char)ch);
                    for (i = 0; i < 16 && (ch2 = this.read()) >= 0; ++i) {
                        builder.append((char)ch2);
                    }
                    builder.append('\n');
                    for (i = 0; i < length; ++i) {
                        builder.append(' ');
                    }
                    builder.append('^');
                    throw new JsonException("Illegal escape character in quoted string:" + (char)ch + " at:\n" + String.valueOf(builder));
                }
                default: {
                    if (ch == quote) {
                        return this.pool(builder.toString());
                    }
                    builder.append((char)ch);
                }
            }
        }
    }

    private String readValue() throws IOException {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        while (true) {
            int ch = this.read();
            switch (ch) {
                case 44: 
                case 93: 
                case 125: {
                    this.back(ch);
                }
                case -1: {
                    return builder.toString();
                }
            }
            builder.append((char)ch);
        }
    }

    private String readJson() throws IOException {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        Stack<Character> stack = new Stack<Character>();
        int end = -1;
        block8: while (true) {
            int ch = this.read();
            switch (ch) {
                case 123: {
                    stack.push(Character.valueOf((char)end));
                    end = 125;
                    builder.append((char)ch);
                    break;
                }
                case 91: {
                    stack.push(Character.valueOf((char)end));
                    end = 93;
                    builder.append((char)ch);
                    break;
                }
                case -1: {
                    if (stack.size() == 0) {
                        return builder.toString();
                    }
                    throw new EOFException("Unexpected end of JSON data");
                }
                case 44: {
                    if (stack.size() == 0) {
                        this.back(ch);
                        return builder.toString();
                    }
                    builder.append((char)ch);
                    break;
                }
                case 34: {
                    builder.append((char)ch);
                    boolean slash = false;
                    while (true) {
                        if ((ch = this.read()) == -1) continue block8;
                        builder.append((char)ch);
                        if (ch == 34 && !slash) continue block8;
                        slash = !slash && ch == 92;
                    }
                }
                case 93: 
                case 125: {
                    if (stack.size() == 0) {
                        this.back(ch);
                        return builder.toString();
                    }
                }
                default: {
                    if (ch == end) {
                        end = ((Character)stack.pop()).charValue();
                    }
                    builder.append((char)ch);
                }
            }
        }
    }

    private Object convertQuoteValue(String value, @Nonnull Type type) {
        return this.convertValue(value, type, true);
    }

    private Object convertNonquotedValue(String value, @Nonnull Type type) {
        if ((value = value.trim()).equalsIgnoreCase("null")) {
            return null;
        }
        return this.convertValue(value, type, false);
    }

    private Object convertValue(String value, @Nonnull Type type, boolean fallBackToString) {
        ClassWrapper wrapper = ClassWrapper.getWrapper(type, null);
        switch (wrapper.getJsonType()) {
            case 12: {
                return this.pool(Integer.valueOf(value));
            }
            case 13: {
                return this.pool(Long.valueOf(value));
            }
            case 15: {
                return this.pool(Double.valueOf(value));
            }
            case 14: {
                return this.pool(Float.valueOf(value));
            }
            case 11: {
                return this.pool(Short.valueOf(value));
            }
            case 10: {
                return this.pool(Byte.valueOf(value));
            }
            case 9: {
                return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
            }
            case 8: {
                return new Date(Long.parseLong(value));
            }
        }
        return wrapper.valueOf(value, fallBackToString);
    }
}

