/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.lib.json.DeclaredField;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.json.JsonSubTypeResolver;
import com.inet.lib.util.DebugUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ClassWrapper {
    private static final Map<Type, ClassWrapper> CLASSES = new ConcurrentHashMap<Type, ClassWrapper>();
    private static final Type @Nonnull [] EMPTY_TYPE_ARGUMENTS = new Type[0];
    public static final int JSON_NON_QUOTE = 1;
    public static final int JSON_QUOTE = 2;
    public static final int JSON_COLLECTION = 3;
    public static final int JSON_MAP = 4;
    public static final int JSON_ARRAY = 5;
    public static final int JSON_ENUM = 6;
    public static final int JSON_OBJECT = 7;
    public static final int JSON_DATE = 8;
    public static final int JSON_BOOLEAN = 9;
    public static final int JSON_BYTE = 10;
    public static final int JSON_SHORT = 11;
    public static final int JSON_INTEGER = 12;
    public static final int JSON_LONG = 13;
    public static final int JSON_FLOAT = 14;
    public static final int JSON_DOUBLE = 15;
    public static final int JSON_CHAR = 16;
    public static final int JSON_BYTES = 17;
    private final Class<?> clazz;
    private final Type type;
    private final Map<String, Field> fields = new ConcurrentHashMap<String, Field>();
    private Constructor<?> ctor;
    private Constructor<?> ctorWithSize;
    private int valueOfType;
    private Method valueOf;
    private JsonSubTypeResolver<?> subTypeResolver;
    private DeclaredField[] declaredFields;
    private int jsonType;
    private Type[] typeArguments;

    private ClassWrapper(Type type) {
        this.clazz = this.getClass(type);
        this.type = type;
    }

    @Nonnull
    public static ClassWrapper getWrapper(@Nonnull Type type, @Nullable Type parentType) {
        ClassWrapper wrapper = CLASSES.get(type);
        if (wrapper == null) {
            if (parentType != null && type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                boolean replacedType = false;
                Type[] typeArguments = paramType.getActualTypeArguments();
                for (int i = 0; i < typeArguments.length; ++i) {
                    Type typeArg = typeArguments[i];
                    if (typeArg instanceof TypeVariable) {
                        ClassWrapper parentWrapper;
                        TypeVariable varType = (TypeVariable)typeArg;
                        varType.getName();
                        Class declaringClass = (Class)varType.getGenericDeclaration();
                        ArrayList<ClassWrapper> parents = new ArrayList<ClassWrapper>();
                        Class<?> superClass = parentType;
                        do {
                            parentWrapper = ClassWrapper.getWrapper(parentType, null);
                            parents.add(parentWrapper);
                        } while ((superClass = parentWrapper.clazz.getSuperclass()) != null && superClass != declaringClass);
                        for (int p = parents.size() - 1; p >= 0; --p) {
                            ClassWrapper parentWrapper2 = (ClassWrapper)parents.get(p);
                            Type[] parentArgs = parentWrapper2.getTypeArguments();
                            if (parentArgs.length <= i) continue;
                            typeArguments[i] = parentArgs[i];
                            replacedType = true;
                            break;
                        }
                    }
                    if (!replacedType) continue;
                    type = new JsonParameterizedType(paramType.getRawType(), typeArguments);
                }
            }
            wrapper = type != Void.class ? new ClassWrapper(type) : new ClassWrapper(type){

                @Override
                @Nonnull
                Object create() throws JsonException {
                    return null;
                }
            };
            CLASSES.put(type, wrapper);
        }
        return wrapper;
    }

    @Nonnull
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Nullable
    Field findField(final @Nonnull String name) {
        Field field = this.fields.get(name);
        if (field != null) {
            return field;
        }
        for (DeclaredField df : this.getDeclaredFields()) {
            Field f = df.getField();
            this.fields.put(df.getName(), f);
        }
        field = this.fields.get(name);
        if (field != null) {
            return field;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                for (Class<?> cla = ClassWrapper.this.clazz; cla != null; cla = cla.getSuperclass()) {
                    try {
                        Field field = cla.getDeclaredField(name);
                        field.setAccessible(true);
                        ClassWrapper.this.fields.put(name, field);
                        return field;
                    }
                    catch (NoSuchFieldException ex) {
                        continue;
                    }
                }
                return null;
            }
        });
    }

    private void valueOfInit() throws JsonException {
        if (this.clazz == Character.class || this.clazz == Character.TYPE) {
            this.valueOfType = 2;
        } else if (this.clazz == String.class) {
            this.valueOfType = 3;
        } else if (Enum.class.isAssignableFrom(this.clazz)) {
            this.valueOfType = 4;
        } else {
            try {
                this.valueOf = this.clazz.getMethod("valueOf", String.class);
                this.valueOfType = (this.valueOf.getModifiers() & 8) > 0 ? 1 : 3;
            }
            catch (Exception ex) {
                this.valueOfType = 3;
            }
        }
    }

    boolean hasValueOf() {
        if (this.valueOfType == 0) {
            this.valueOfInit();
        }
        return this.valueOfType == 1;
    }

    @Nullable
    Object valueOf(String value, boolean fallBackToString) throws JsonException {
        switch (this.valueOfType) {
            default: {
                this.valueOfInit();
                return this.valueOf(value, fallBackToString);
            }
            case 1: {
                try {
                    return this.valueOf.invoke(null, value);
                }
                catch (Exception ex) {
                    throw (JsonException)new JsonException("Value '" + value + "' can't convert to type: " + String.valueOf(this.clazz)).initCause(ex);
                }
            }
            case 2: {
                return Character.valueOf(value.charAt(0));
            }
            case 3: {
                if (fallBackToString) {
                    return value;
                }
                switch (value) {
                    case "false": {
                        return Boolean.FALSE;
                    }
                    case "true": {
                        return Boolean.TRUE;
                    }
                }
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            return Double.valueOf(value);
                        }
                        catch (NumberFormatException numberFormatException3) {
                            throw new JsonException("Value '" + value + "' can't convert to type: " + String.valueOf(this.clazz));
                        }
                    }
                }
            }
            case 4: 
        }
        return Enum.valueOf(this.clazz, value);
    }

    @Nonnull
    Object create() throws JsonException {
        try {
            if (this.ctor == null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Constructor<?> constructor = ClassWrapper.this.clazz.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            Object obj = constructor.newInstance(new Object[0]);
                            ClassWrapper.this.ctor = constructor;
                            return obj;
                        }
                    });
                }
                catch (Exception ex) {
                    if (this.clazz.isAssignableFrom(ArrayList.class)) {
                        this.ctor = ArrayList.class.getConstructor(new Class[0]);
                    }
                    if (this.clazz.isAssignableFrom(Set.class)) {
                        this.ctor = HashSet.class.getConstructor(new Class[0]);
                    }
                    if (this.clazz.isAssignableFrom(Map.class)) {
                        this.ctor = HashMap.class.getConstructor(new Class[0]);
                    }
                    throw ex;
                }
            }
            return this.ctor.newInstance(new Object[0]);
        }
        catch (PrivilegedActionException ex) {
            throw JsonException.create(ex.getCause());
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nonnull
    Object create(final int initialSize) throws JsonException {
        try {
            if (this.ctorWithSize == null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            Constructor<?> constructor = ClassWrapper.this.clazz.getDeclaredConstructor(Integer.TYPE);
                            constructor.setAccessible(true);
                            Object obj = constructor.newInstance(initialSize);
                            ClassWrapper.this.ctorWithSize = constructor;
                            return obj;
                        }
                    });
                }
                catch (Exception ex) {
                    if (this.clazz.isAssignableFrom(ArrayList.class)) {
                        this.ctorWithSize = ArrayList.class.getConstructor(Integer.TYPE);
                    } else if (this.clazz.isAssignableFrom(Set.class)) {
                        this.ctorWithSize = HashSet.class.getConstructor(Integer.TYPE);
                    } else if (this.clazz.isAssignableFrom(Map.class)) {
                        this.ctorWithSize = HashMap.class.getConstructor(Integer.TYPE);
                    } else {
                        throw ex;
                    }
                    this.ctorWithSize.setAccessible(true);
                }
            }
            return this.ctorWithSize.newInstance(initialSize);
        }
        catch (PrivilegedActionException ex) {
            throw JsonException.create(ex.getCause());
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nonnull
    private Class<?> getClass(@Nonnull Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            type = aType.getGenericComponentType();
            return Array.newInstance(this.getClass(type), 0).getClass();
        }
        return (Class)type;
    }

    @Nonnull
    public DeclaredField[] getDeclaredFields() {
        if (this.declaredFields == null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    DeclaredField[] superFields;
                    String name = ClassWrapper.this.clazz.getName();
                    if (DebugUtils.DEBUG && name.startsWith("com.inet.") && ClassWrapper.this.clazz.getDeclaredAnnotation(JsonData.class) == null) {
                        throw new JsonException(String.valueOf(ClassWrapper.this.clazz) + " has no JsonData annotation");
                    }
                    Field[] fields = null;
                    try {
                        Method method = ClassWrapper.this.clazz.getMethod("getDeclaredFields", new Class[0]);
                        fields = (Field[])method.invoke(null, new Object[0]);
                    }
                    catch (Throwable method) {
                        // empty catch block
                    }
                    if (fields == null) {
                        fields = ClassWrapper.this.clazz.getDeclaredFields();
                    }
                    for (int i = 0; i < fields.length; ++i) {
                        boolean nonSerializable;
                        block12: {
                            Field field = fields[i];
                            boolean bl = nonSerializable = (field.getModifiers() & 0x88) > 0;
                            if (!nonSerializable) {
                                try {
                                    field.setAccessible(true);
                                }
                                catch (RuntimeException ex) {
                                    nonSerializable = true;
                                    if (!DebugUtils.DEBUG) break block12;
                                    throw ex;
                                }
                            }
                        }
                        if (!nonSerializable) continue;
                        Field[] copy = Arrays.copyOf(fields, fields.length - 1);
                        System.arraycopy(fields, i + 1, copy, i, copy.length - i);
                        fields = copy;
                        --i;
                    }
                    DeclaredField[] dFields = new DeclaredField[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        dFields[i] = new DeclaredField(field);
                    }
                    Class<?> superClass = ClassWrapper.this.clazz.getSuperclass();
                    if (superClass != null && (superFields = ClassWrapper.getWrapper(superClass, null).getDeclaredFields()).length > 0) {
                        int length = superFields.length;
                        superFields = Arrays.copyOf(superFields, length + dFields.length);
                        System.arraycopy(dFields, 0, superFields, length, dFields.length);
                        dFields = superFields;
                    }
                    if (DebugUtils.DEBUG && fields.length > 0) {
                        HashSet<String> set = new HashSet<String>();
                        for (Field field : fields) {
                            if (set.add(field.getName())) continue;
                            throw new JsonException(String.valueOf(ClassWrapper.this.clazz) + " has a duplicate field: " + field.getName());
                        }
                    }
                    ClassWrapper.this.declaredFields = dFields;
                    return null;
                }
            });
        }
        return this.declaredFields;
    }

    public int getJsonType() {
        if (this.jsonType == 0) {
            this.jsonType = Boolean.class == this.clazz || Boolean.TYPE == this.clazz ? 9 : (Byte.class == this.clazz || Byte.TYPE == this.clazz ? 10 : (Short.class == this.clazz || Short.TYPE == this.clazz ? 11 : (Integer.class == this.clazz || Integer.TYPE == this.clazz ? 12 : (Long.class == this.clazz || Long.TYPE == this.clazz ? 13 : (Float.class == this.clazz || Float.TYPE == this.clazz ? 14 : (Double.class == this.clazz || Double.TYPE == this.clazz ? 15 : (Number.class.isAssignableFrom(this.clazz) ? 1 : (Collection.class.isAssignableFrom(this.clazz) ? 3 : (Map.class.isAssignableFrom(this.clazz) ? 4 : (String.class == this.clazz ? 2 : (Character.class == this.clazz || Character.TYPE == this.clazz ? 16 : (byte[].class == this.clazz ? 17 : (this.clazz.isArray() ? 5 : (Enum.class.isAssignableFrom(this.clazz) ? 6 : (Date.class == this.clazz ? 8 : (this.hasValueOf() ? 2 : (CharSequence.class.isAssignableFrom(this.clazz) ? 2 : 7)))))))))))))))));
        }
        return this.jsonType;
    }

    public @Nonnull Type @Nullable [] getTypeArguments() {
        if (this.typeArguments == null) {
            Type[] typeArguments;
            if (this.type instanceof ParameterizedType) {
                typeArguments = ((ParameterizedType)this.type).getActualTypeArguments();
                try {
                    for (Type typeArg : typeArguments) {
                        ClassWrapper.getWrapper(typeArg, null);
                    }
                }
                catch (Exception ex) {
                    typeArguments = EMPTY_TYPE_ARGUMENTS;
                }
            } else {
                Type superType = this.clazz.getGenericSuperclass();
                if (superType != null) {
                    ClassWrapper wrapper = ClassWrapper.getWrapper(superType, null);
                    typeArguments = wrapper.getTypeArguments();
                    if (typeArguments == null) {
                        typeArguments = EMPTY_TYPE_ARGUMENTS;
                    }
                } else {
                    typeArguments = EMPTY_TYPE_ARGUMENTS;
                }
            }
            this.typeArguments = typeArguments;
        }
        if (this.typeArguments.length == 0) {
            return null;
        }
        return this.typeArguments;
    }

    boolean hasGetTypeFor() {
        return this.subTypeResolver != null;
    }

    void setSubTypeResolver(@Nullable JsonSubTypeResolver<?> resolver) {
        this.subTypeResolver = resolver;
    }

    @Nonnull
    Type getTypeFor(Map<String, Object> fieldValues, HashMap<String, Object> extraFieldValues) throws JsonException {
        Class<?> typeFor = this.subTypeResolver.getTypeFor(fieldValues, extraFieldValues);
        return typeFor == null ? Void.class : typeFor;
    }
}

