/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.mongodb;

import com.inet.config.ConfigKey;
import com.inet.lib.util.NetworkFunctions;
import com.inet.logging.EventLog;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.mongodb.MongoDbPersistence;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Sorts;
import java.time.Instant;
import java.util.Iterator;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDbEventLogPersistence
implements EventLogPersistence {
    private static final String TIME = "time";
    private static final String ACCOUNT_ID = "account_id";
    private static final String ACCOUNT_NAME = "account_name";
    private static final String EVENT = "event";
    private static final String MESSAGE = "message";
    private static final String DATA = "data";
    private static final String EXTRA = "extra_";
    private static final String NODE = "node";
    private final String name;
    private MongoCollection<Document> collection;

    MongoDbEventLogPersistence(String name) {
        this.name = "eventlog-" + name;
    }

    public void write(EventLog.EventData eventData) {
        Document logMessage = new Document();
        logMessage.append(TIME, (Object)PersistenceHelper.ISO_INSTANT.format(Instant.ofEpochMilli(eventData.getTimeMillis())));
        UserAccount account = eventData.getAccount();
        if (account == null) {
            logMessage.append(ACCOUNT_ID, null);
            logMessage.append(ACCOUNT_NAME, null);
        } else {
            logMessage.append(ACCOUNT_ID, (Object)account.getID().toString());
            logMessage.append(ACCOUNT_NAME, (Object)account.getDisplayName());
        }
        logMessage.append(EVENT, (Object)eventData.getEvent());
        logMessage.append(MESSAGE, (Object)eventData.getMessage());
        logMessage.append(DATA, (Object)eventData.getData());
        Object[] extra = eventData.getExtraColumns();
        if (extra != null) {
            for (int i = 0; i < extra.length; ++i) {
                Object value = extra[i];
                String str = value == null ? "" : value.toString();
                logMessage.append(EXTRA + i, (Object)str);
            }
        }
        logMessage.append(NODE, (Object)NetworkFunctions.getLocalHostName());
        this.getCollection().insertOne((Object)logMessage);
    }

    public void close() {
    }

    public void delete() {
        this.getCollection().drop();
        this.collection = null;
    }

    private MongoCollection<Document> getCollection() {
        if (this.collection == null) {
            boolean created;
            int cappedSize;
            MongoDatabase db;
            block7: {
                db = MongoDbPersistence.getDatabase();
                Integer logSize = (Integer)ConfigKey.LOG_MAXSIZE.getCurrent();
                cappedSize = Math.max(1, logSize / 10);
                cappedSize *= 1038336;
                created = false;
                try {
                    db.createCollection(this.name, new CreateCollectionOptions().capped(true).sizeInBytes((long)cappedSize));
                    created = true;
                }
                catch (MongoException ex) {
                    if (ex.getCode() == 48) break block7;
                    throw ex;
                }
            }
            Document stats = db.runCommand((Bson)new Document("collStats", (Object)this.name));
            Number maxSize = (Number)stats.get((Object)"maxSize");
            if (maxSize.intValue() != cappedSize) {
                try {
                    Document command = new Document("convertToCapped", (Object)this.name);
                    command.append("size", (Object)cappedSize);
                    db.runCommand((Bson)command);
                    created = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.collection = db.getCollection(this.name);
            if (created) {
                this.collection.createIndex((Bson)new BasicDBObject(TIME, (Object)1));
            }
        }
        return this.collection;
    }

    public Iterator<String[]> getEvents(final int columnCount) {
        return new Iterator<String[]>(){
            private String[] row;
            private MongoCursor<Document> events;
            {
                this.row = new String[columnCount];
                this.events = MongoDbEventLogPersistence.this.getCollection().find().sort(Sorts.ascending((String[])new String[]{MongoDbEventLogPersistence.TIME})).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.events.hasNext();
            }

            @Override
            public String[] next() {
                Document doc = (Document)this.events.next();
                MongoDbEventLogPersistence.set(this.row, 0, doc, MongoDbEventLogPersistence.TIME);
                MongoDbEventLogPersistence.set(this.row, 1, doc, MongoDbEventLogPersistence.ACCOUNT_ID);
                MongoDbEventLogPersistence.set(this.row, 2, doc, MongoDbEventLogPersistence.ACCOUNT_NAME);
                MongoDbEventLogPersistence.set(this.row, 3, doc, MongoDbEventLogPersistence.EVENT);
                MongoDbEventLogPersistence.set(this.row, 4, doc, MongoDbEventLogPersistence.MESSAGE);
                MongoDbEventLogPersistence.set(this.row, 5, doc, MongoDbEventLogPersistence.DATA);
                for (int i = 6; i < this.row.length - 1; ++i) {
                    MongoDbEventLogPersistence.set(this.row, i, doc, MongoDbEventLogPersistence.EXTRA + (i - 6));
                }
                MongoDbEventLogPersistence.set(this.row, this.row.length - 1, doc, MongoDbEventLogPersistence.NODE);
                return this.row;
            }
        };
    }

    private static void set(String[] row, int idx, Document doc, String key) {
        if (row.length <= idx) {
            return;
        }
        String str = doc.getString((Object)key);
        if (str == null) {
            str = "";
        }
        row[idx] = str;
    }
}

