/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.json.JsonParser;
import com.inet.lib.json.JsonSubTypeResolver;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.lib.json.JsonWriter;
import com.inet.lib.json.JsonWriterFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Json {
    public static final String JSON_DATA_PRODUCES_NULL_VALUE = "JSON data produces NULL value";
    public static final Map<Object, Map<String, String>> NULL_MAP = new HashMap<Object, Map<String, String>>(){

        @Override
        public Map<String, String> put(@Nullable Object key, @Nullable Map<String, String> value) {
            return null;
        }

        @Override
        public void putAll(@Nonnull Map<? extends Object, ? extends Map<String, String>> m) {
        }
    };
    public static final Charset UTF8 = Charset.forName("UTF8");

    @Nonnull
    public <T> T fromJson(byte @Nonnull [] input, @Nonnull Class<T> clazz) {
        try {
            return this.fromJson((InputStream)new FastByteArrayInputStream(input), (Type)clazz, null, null);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public <T> T fromJson(byte @Nonnull [] input, @Nonnull Class<T> clazz, Type ... generic) {
        try {
            return this.fromJson((InputStream)new FastByteArrayInputStream(input), clazz, generic);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Class<T> clazz) throws IOException {
        return this.fromJson(input, (Type)clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Class<T> clazz, Type ... generic) {
        try {
            return this.fromJson((Reader)new UTF8StreamReader(input), clazz, generic);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Class<T> clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(input, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson((Reader)new UTF8StreamReader(input), clazz, extraFields, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Class<T> clazz) {
        return this.fromJson(jsonData, (Type)clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Class<T> clazz, JsonTypeResolver typeResolver) {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Type clazz) {
        return this.fromJson(jsonData, clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields) {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) {
        FastStringReader reader = null;
        try {
            reader = new FastStringReader(jsonData);
            return this.fromJson((Reader)reader, clazz, extraFields, typeResolver);
        }
        catch (Exception ex) {
            JsonException jsonEx = JsonException.create(ex);
            if (reader != null) {
                int idx = reader.getIndexPosition() - 1;
                int from = Math.max(0, idx - 30);
                int to = Math.min(idx + 30, jsonData.length());
                String excerpt = jsonData.substring(from, to);
                jsonEx.addSuppressed(new JsonException("Syntax error in JSON data at position " + idx + ". Nearby excerpt: " + excerpt));
            }
            throw jsonEx;
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz) throws IOException {
        return this.fromJson(jsonData, (Type)clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz, Map<Object, Map<String, String>> extraFields) throws IOException {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz) throws IOException {
        return this.fromJson(jsonData, clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields) throws IOException {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        try {
            T result = this.fromJsonNullable(jsonData, clazz, extraFields, typeResolver);
            if (result == null) {
                throw new JsonException(JSON_DATA_PRODUCES_NULL_VALUE);
            }
            return result;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nullable
    @Deprecated
    public <T> T fromJsonNullable(@Nonnull Reader jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        try {
            if (typeResolver == null) {
                typeResolver = JsonTypeResolver.INSTANCE;
            }
            JsonParser parser = new JsonParser(jsonData, extraFields, typeResolver);
            return (T)parser.parseValue(clazz, null);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Class<T> clazz, Type ... generic) {
        return this.fromJson(jsonData, null, clazz, generic);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nullable Map<Object, Map<String, String>> extraFields, @Nonnull Class<T> clazz, Type ... generic) {
        try {
            return this.fromJson((Reader)new FastStringReader(jsonData), extraFields, clazz, generic);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz, Type ... generic) throws IOException {
        return this.fromJson(jsonData, null, clazz, generic);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, Map<Object, Map<String, String>> extraFields, @Nonnull Class<T> clazz, Type ... generic) throws IOException {
        try {
            JsonParser parser = new JsonParser(jsonData, extraFields, JsonTypeResolver.INSTANCE);
            Class<T> type = generic == null || generic.length == 0 ? clazz : new JsonParameterizedType(clazz, generic);
            Object result = parser.parseValue(type, null);
            if (result == null) {
                throw new JsonException(JSON_DATA_PRODUCES_NULL_VALUE);
            }
            return (T)result;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public Object[] fromJson(@Nonnull Reader jsonData, @Nonnull @Nonnull Type @Nonnull [] classes) throws IOException {
        try {
            JsonParser parser = new JsonParser(jsonData, null, JsonTypeResolver.INSTANCE);
            return parser.parseValues(classes);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nonnull
    public String toJson(@Nonnull Object data) {
        return this.toJson(data, (JsonWriterFilter)null);
    }

    @Nonnull
    public String toJson(@Nonnull Object data, @Nullable JsonWriterFilter filter) {
        StringBuilder buffer = new StringBuilder();
        this.toJson(data, buffer, filter);
        return buffer.toString();
    }

    public void toJson(@Nonnull Object value, @Nonnull Appendable writer) throws IOException {
        this.toJson(value, writer, null);
    }

    public void toJson(@Nonnull Object value, @Nonnull Appendable writer, @Nullable JsonWriterFilter filter) throws IOException {
        try {
            JsonWriter jsonWriter = new JsonWriter(writer);
            if (filter != null) {
                jsonWriter.setWriterFilter(filter);
            }
            jsonWriter.writeValue(value);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public void toJson(@Nonnull Object value, @Nonnull StringBuilder builder) {
        this.toJson(value, builder, null);
    }

    public void toJson(@Nonnull Object value, @Nonnull StringBuilder builder, @Nullable JsonWriterFilter filter) {
        Objects.requireNonNull(value, "value must non null");
        this.toJsonNullable(value, builder, filter);
    }

    @Deprecated
    public void toJsonNullable(@Nullable Object value, @Nonnull StringBuilder builder, @Nullable JsonWriterFilter filter) {
        try {
            JsonWriter parser = new JsonWriter(builder);
            if (filter != null) {
                parser.setWriterFilter(filter);
            }
            parser.writeValue(value);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public void toJson(@Nonnull Object value, @Nonnull OutputStream output) throws IOException {
        Objects.requireNonNull(value, "value must non null");
        UTF8StreamWriter writer = new UTF8StreamWriter(output);
        this.toJson(value, writer);
        try {
            writer.flush();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    public static <T> void registerTypeResolver(@Nonnull Class<T> clazz, @Nullable JsonSubTypeResolver<T> resolver) {
        ClassWrapper.getWrapper(clazz, null).setSubTypeResolver(resolver);
    }

    @Nonnull
    public static PrintStream getErrorStream() {
        return System.err;
    }
}

