/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParser;
import com.inet.lib.json.JsonTypeResolver;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class BaseParser {
    @Nullable
    private final @Nullable Map<@Nonnull Object, @Nonnull Map<@Nonnull String, @Nullable Object>> extraFields;
    @Nonnull
    final JsonTypeResolver typeResolver;
    @Nonnull
    private final @Nonnull Function<@Nonnull Object, @Nonnull Object> objectPool;

    BaseParser(@Nullable Map<Object, Map<String, Object>> extraFields, @Nonnull JsonTypeResolver typeResolver, @Nonnull @Nonnull Function<@Nonnull Object, @Nonnull Object> objectPool) {
        this.extraFields = extraFields;
        this.typeResolver = typeResolver;
        this.objectPool = objectPool;
    }

    @Nonnull
    <T> T pool(@Nonnull T obj) {
        return (T)this.objectPool.apply(obj);
    }

    void saveExtraField(@Nonnull Object obj, @Nonnull String fieldName) throws JsonException, IOException {
        this.saveExtraField(obj, fieldName, null, true);
    }

    void saveExtraField(@Nonnull Object obj, @Nonnull String fieldName, @Nullable Object value, boolean valueNeedParse) throws JsonException, IOException {
        Map<@Nonnull Object, @Nonnull Map<@Nonnull String, @Nullable Object>> _extraFields = this.extraFields;
        if (_extraFields == null) {
            throw new JsonException("Field '" + fieldName + "' not found in " + obj.getClass().getName() + ".");
        }
        Map<@Nonnull String, @Nullable Object> extras = _extraFields.get(obj);
        if (extras == null) {
            extras = new HashMap<String, Object>();
            _extraFields.put(obj, extras);
        }
        if (valueNeedParse) {
            value = this.parseExtraFieldValue();
        }
        extras.put(fieldName, value);
    }

    abstract Object parseExtraFieldValue() throws JsonException, IOException;

    class JsonObject {
        private ClassWrapper wrapper;
        HashMap<String, Object> fieldValues = new HashMap();
        HashMap<String, Object> extraFieldValues = new HashMap();

        JsonObject(ClassWrapper wrapper) {
            this.wrapper = wrapper;
        }

        @Nonnull
        Object create() throws IOException {
            this.wrapper = ClassWrapper.getWrapper(this.wrapper.getTypeFor(this.fieldValues, this.extraFieldValues), null);
            Object obj = this.wrapper.create();
            this.setFields(obj, this.fieldValues.entrySet(), false);
            this.setFields(obj, this.extraFieldValues.entrySet(), true);
            return obj;
        }

        private void setFields(@Nonnull Object obj, @Nonnull Set<Map.Entry<String, Object>> entrySet, boolean isExtra) throws IOException {
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                Field field = this.wrapper.findField(key);
                Object value = entry.getValue();
                if (field == null) {
                    BaseParser.this.saveExtraField(obj, key, String.valueOf(value), false);
                    continue;
                }
                Type fieldType = BaseParser.this.typeResolver.getGenericType(obj, field);
                if (isExtra && BaseParser.this.getClass() == JsonParser.class) {
                    JsonParser parser = new JsonParser(new FastStringReader((String)value), BaseParser.this.extraFields, BaseParser.this.typeResolver);
                    value = parser.parseValue(fieldType, null);
                }
                try {
                    field.set(obj, value);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace(Json.getErrorStream());
                }
            }
        }
    }
}

