/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.annotations.JsonData;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonData
public abstract class UF_Editability {
    private static List<UF_Editability> ALL = new ArrayList<UF_Editability>();
    private String key;
    public static final UF_Editability USERS_CAN_CHANGE = new UF_Editability("usersCanChange"){

        @Override
        public boolean isEditable() {
            return true;
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("editability.usersCanChange", new Object[0]);
        }
    };
    public static final UF_Editability ONLY_USER_MANAGER_CAN_CHANGE = new UF_Editability("usermanagerCanChange"){

        @Override
        public boolean isEditable() {
            return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("editability.userManagerCanChange", new Object[0]);
        }
    };
    public static final UF_Editability ONLY_USER_MANAGER_ADMIN_CAN_CHANGE = new UF_Editability("usermanagerAdminCanChange"){

        @Override
        public boolean isEditable() {
            return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("editability.userManagerAdminCanChange", new Object[0]);
        }
    };
    public static final UF_Editability READ_ONLY_FOR_ALL = new UF_Editability("readOnly"){

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public String getLabel() {
            return UsersAndGroups.MSG.getMsg("editability.readOnly", new Object[0]);
        }
    };

    public UF_Editability(String key) {
        this.key = key;
        if (ALL.stream().anyMatch(i2 -> i2.key.equals(key))) {
            throw new IllegalArgumentException("Key already exists: " + key);
        }
        ALL.add(this);
    }

    public abstract boolean isEditable();

    public abstract String getLabel();

    @Nonnull
    public String toString() {
        return this.key;
    }

    public static UF_Editability valueOf(String str) {
        Optional<UF_Editability> optional = ALL.stream().filter(i2 -> i2.key.equals(str)).findFirst();
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("No such key: " + str);
        }
        return optional.get();
    }

    public static List<UF_Editability> values() {
        return new ArrayList<UF_Editability>(ALL);
    }
}

