/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface EmailAddressHelper {
    @Nonnull
    public static EmailAddressHelper get() {
        EmailAddressHelper emailAddressHelper = EmailAddressHelperFallback.a;
        if (emailAddressHelper == null) {
            emailAddressHelper = ServerPluginManager.getInstance().getOptionalInstance(EmailAddressHelper.class);
            if (emailAddressHelper == null) {
                emailAddressHelper = new EmailAddressHelperFallback();
            }
            EmailAddressHelperFallback.a = emailAddressHelper;
        }
        return emailAddressHelper;
    }

    default public boolean isAvailable(@Nonnull GUID accountID) {
        return false;
    }

    default public String getFirstEmailAddress(String value) {
        List<String> list = this.getValidEmailAddressesFrom(value);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    default public List<String> getValidEmailAddressesFrom(String value) {
        return EmailAddressHelper.a(value).stream().filter(string -> this.testEmailAddressString((String)string)).collect(Collectors.toList());
    }

    default public List<String> getInvalidEmailAddressesFrom(String value) {
        return EmailAddressHelper.a(value).stream().filter(string -> !this.testEmailAddressString((String)string)).collect(Collectors.toList());
    }

    default public void throwIfContainsInvalidEmailAddresses(String value) {
        List<String> list = this.getInvalidEmailAddressesFrom(value);
        if (!list.isEmpty()) {
            String string = list.stream().collect(Collectors.joining(", "));
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.invalidemailaddresses", string));
        }
    }

    default public String getValidOrDefaultValue(Field<String> field, String value, int lengthLimit, @Nullable GUID entryID) {
        Runnable runnable = () -> {
            String string2 = entryID != null ? String.format("Value \"%s\" of the field \"%s\" defined for entry with ID \"%s\" does not include valid email address. Default value will be used instead.", value, field.getKey(), entryID) : String.format("Value \"%s\" of the field \"%s\" does not include valid email address. Default value will be used instead.", value, field.getKey());
            UsersAndGroups.LOGGER.warn(string2);
        };
        Runnable runnable2 = () -> {
            String string = entryID != null ? String.format("Value of the field \"%s\" defined for entry with ID \"%s\" includes at least one invalid email address, which will be ignored.", field.getKey(), entryID) : String.format("Value of the field \"%s\" includes at least one invalid email address, which will be ignored.", field.getKey());
            UsersAndGroups.LOGGER.warn(string);
        };
        Runnable runnable3 = () -> {
            String string = entryID != null ? String.format("Value of the field \"%s\" defined for entry with ID \"%s\" is too long. Shortened value \"%s\" will be used instead.", field.getKey(), entryID) : String.format("Value of the field \"%s\" is too long. Shortened value \"%s\" will be used instead.", field.getKey());
            UsersAndGroups.LOGGER.warn(string);
        };
        List<String> list = EmailAddressHelper.a(value);
        if (list.isEmpty()) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String charSequence2 : list) {
            if (this.testEmailAddressString(charSequence2)) {
                arrayList.add(charSequence2);
                continue;
            }
            arrayList2.add(charSequence2);
        }
        if (!arrayList2.isEmpty()) {
            if (arrayList.isEmpty()) {
                runnable.run();
                return field.getDefaultValue();
            }
            runnable2.run();
        }
        String string = ";";
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : arrayList) {
            if (stringBuilder.length() + string.length() + string2.length() <= lengthLimit) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
                continue;
            }
            runnable3.run();
            break;
        }
        return stringBuilder.toString();
    }

    private static List<String> a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    default public String convertEmailAddressesToString(List<String> emailAddresses, boolean filterOutInvalidEntries) {
        if (emailAddresses == null) {
            return "";
        }
        Stream<Object> stream = emailAddresses.stream();
        if (filterOutInvalidEntries) {
            stream = stream.filter(string -> this.testEmailAddressString((String)string));
        }
        return stream.collect(Collectors.joining(";"));
    }

    public boolean testEmailAddressString(String var1);

    public void validateSingleAddress(String var1) throws Exception;

    default public String extractAlias(String addr) {
        if (!this.testEmailAddressString(addr)) {
            return null;
        }
        int n2 = addr.lastIndexOf(60);
        int n3 = addr.lastIndexOf(62);
        if (n2 > -1 && n3 > n2) {
            return addr.substring(0, n2).trim();
        }
        return null;
    }

    default public String extractEmailAddress(String addr) {
        if (!this.testEmailAddressString(addr)) {
            return null;
        }
        int n2 = addr.lastIndexOf(60);
        int n3 = addr.lastIndexOf(62);
        if (n2 > -1 && n3 > n2) {
            String string = addr.substring(n2 + 1, n3).trim();
            if (this.testEmailAddressString(string)) {
                return string;
            }
        } else {
            return addr.trim();
        }
        return null;
    }

    public static class EmailAddressHelperFallback
    implements EmailAddressHelper {
        private static EmailAddressHelper a;

        @Override
        public boolean testEmailAddressString(String in) {
            return true;
        }

        @Override
        public void validateSingleAddress(String in) {
        }
    }
}

