/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.veto;

import com.inet.annotations.InternalApi;
import com.inet.plugin.veto.VetoSemaphore;
import com.inet.search.index.IndexSearchEngine;
import javax.annotation.Nonnull;

@InternalApi
public class SearchIndexVeto {
    private VetoSemaphore a;
    private String b;
    private IndexSearchEngine<?> c;

    public SearchIndexVeto(final @Nonnull String indexName) {
        this.b = indexName;
        this.a = new VetoSemaphore(IndexSearchEngine.MSG){

            @Override
            public String getStatusMessage() {
                IndexSearchEngine<?> indexSearchEngine = SearchIndexVeto.this.c;
                if (indexSearchEngine != null) {
                    return IndexSearchEngine.MSG.getMsg("executingInitOfIndex", indexName, indexSearchEngine.getRunningIndexCount());
                }
                return super.getStatusMessage();
            }
        };
        this.a.setStatusMessage("waitingForInitOfIndex", indexName);
    }

    public VetoSemaphore getVetoSemaphore() {
        return this.a;
    }

    public void setStatusToStartingInitOfIndex(IndexSearchEngine<?> searchEngine) {
        if (this.a != null) {
            this.c = searchEngine;
        }
    }

    public synchronized void setProgress(int processedEntries, int totalEntryCount) {
        if (this.a != null) {
            int n2 = 0;
            if (totalEntryCount > 0) {
                n2 = processedEntries * 100 / totalEntryCount;
            }
            this.a.setStatusPercentage(n2);
        }
    }

    public synchronized void setStatusToFinishedInitOfIndex() {
        if (this.a != null) {
            this.c = null;
            this.a.setStatusPercentage(100);
            this.a.setStatusMessage("finishedInitOfIndex", this.b);
            this.a.complete(null);
            this.a = null;
        }
    }

    public synchronized void setStatusToFailedInitOfIndex() {
        if (this.a != null) {
            this.a.setStatusMessage("failedInitOfIndex", this.b);
            this.a = null;
        }
    }
}

