/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search;

import com.inet.annotations.InternalApi;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.search.SearchDataType;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.index.SuggestedTag;
import com.inet.search.index.TagIndex;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class SearchTag
implements SuggestedTag {
    @Nonnull
    private final String a;
    private SearchTokenizer b;
    @Nonnull
    private SearchDataType c;
    private int d;
    @Nonnull
    private final Supplier<String> e;
    private boolean f;
    private boolean g;

    public SearchTag(@Nonnull String tag, int priority) {
        this(tag, TextSearchTokenizer.DEFAULT, priority);
    }

    public SearchTag(@Nonnull String tag, @Nonnull SearchTokenizer tokenizer, int priority) {
        this(tag, SearchDataType.String, true, tokenizer, priority, () -> tag, false);
    }

    public SearchTag(@Nonnull String tag, @Nonnull SearchDataType dataType, boolean supportsNullValues, int priority) {
        this(tag, dataType, supportsNullValues, null, priority, () -> tag, false);
    }

    public SearchTag(@Nonnull String tag, @Nonnull SearchDataType dataType, boolean supportsNullValues, @Nonnull SearchTokenizer tokenizer, int priority) {
        this(tag, dataType, supportsNullValues, tokenizer, priority, () -> tag, false);
    }

    public SearchTag(@Nonnull String tag, int priority, @Nonnull Supplier<String> displayName) {
        this(tag, SearchDataType.String, true, TextSearchTokenizer.DEFAULT, priority, displayName, true);
    }

    public SearchTag(@Nonnull String tag, @Nonnull SearchTokenizer tokenizer, int priority, @Nonnull Supplier<String> displayName) {
        this(tag, SearchDataType.String, true, tokenizer, priority, displayName, true);
    }

    public SearchTag(@Nonnull String tag, @Nonnull SearchDataType dataType, boolean supportsNullValues, int priority, @Nonnull Supplier<String> displayName) {
        this(tag, dataType, supportsNullValues, null, priority, displayName, true);
    }

    public SearchTag(@Nonnull String tag, @Nonnull SearchDataType dataType, boolean supportsNullValues, SearchTokenizer tokenizer, int priority, @Nonnull Supplier<String> displayName, boolean includeInTextSearch) {
        this.a = tag;
        this.e = displayName;
        this.d = priority;
        this.f = includeInTextSearch;
        this.b = tokenizer;
        this.c = dataType;
        this.g = supportsNullValues;
        switch (dataType) {
            case String: 
            case ID: 
            case StringMap: {
                Objects.requireNonNull(tokenizer, "tokenizer can't be null");
                break;
            }
        }
    }

    @Override
    @Nonnull
    public final String getTag() {
        return this.a;
    }

    public final SearchTokenizer getTokenizer() {
        return this.b;
    }

    @Override
    @Nonnull
    public final SearchDataType getDataType() {
        return this.c;
    }

    public final boolean supportsNullValues() {
        return this.g;
    }

    @Nonnull
    public Map<? extends Comparable<?>, String> getMapData() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public int getPriority() {
        return this.d;
    }

    @Override
    @Nonnull
    public final String getDisplayName() {
        return this.e.get();
    }

    @Nonnull
    public String getDisplayValue(Object value) {
        if (value == null) {
            return "";
        }
        switch (this.c) {
            case IntegerMap: {
                return this.getMapData().getOrDefault(value, "");
            }
            case StringMap: {
                Map<Comparable<?>, String> map = this.getMapData();
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : this.b.tokens(value, 1)) {
                    String string2 = map.get(string);
                    if (string2 == null) {
                        if (!this.showAlsoNonMapValues()) continue;
                        string2 = string;
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string2);
                }
                return stringBuilder.toString();
            }
            case Date: {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, ClientLocale.getThreadLocale());
                dateFormat.setTimeZone(ClientTimezone.getTimeZone());
                return dateFormat.format(value);
            }
        }
        return value.toString();
    }

    @Override
    public boolean isSuggestedTag() {
        return this.f && this.isTextSearchEnabled();
    }

    public boolean useDisplaynamesForComparisonSign() {
        return false;
    }

    public boolean showAlsoNonMapValues() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SearchTag)) {
            return false;
        }
        return this.a.equals(((SearchTag)obj).a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    protected TagIndex createTagIndex(SearchIndexPersistence persistence) throws IOException {
        return persistence.createTag(this);
    }

    public boolean isPhraseContainsIn(@Nonnull String normalizePhrase, @Nullable Object val) {
        if (val instanceof String) {
            return PhraseSearchExpression.normalize((String)val).contains(normalizePhrase);
        }
        return val != null;
    }

    public void setIncludeInTextSearch(boolean includeInTextSearch) {
        this.f = includeInTextSearch;
    }
}

