/*
 * Decompiled with CFR 0.152.
 */
package com.inet.process;

import com.inet.annotations.InternalApi;
import com.inet.classloader.BaseLocator;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import com.inet.logging.CoreLoggers;
import com.inet.logging.LogManager;
import com.inet.plugin.PluginFilter;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

@InternalApi
public class ConsoleProcessBridge {
    public static void main(String[] args) throws Exception {
        PrintStream printStream = System.out;
        try {
            System.setOut(System.err);
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            ServerPluginDescription serverPluginDescription = serverPluginManager.loadCoreServerPluginDescriptionForServerStart(null);
            CoreLoggers.addLoggers("processbridge");
            LogManager.getLogger("processbridge");
            ConfigurationManager configurationManager = ConfigurationManager.getInstance();
            Map map = (Map)ConfigKey.PLUGINS_ACTIVATED.getCurrent();
            for (String string : args[1].split(",")) {
                map.put(string, Boolean.TRUE);
            }
            serverPluginManager.setActived(map);
            serverPluginManager.register(OutputStream.class, printStream);
            serverPluginManager.register(InputStream.class, System.in);
            serverPluginManager.setPluginFilter(new PluginFilter(){

                @Override
                public boolean accept(ServerPluginDescription plugin) {
                    switch (plugin.getId()) {
                        case "webserver": 
                        case "remotegui": 
                        case "help": {
                            return false;
                        }
                    }
                    return true;
                }
            });
            serverPluginManager.init(serverPluginDescription);
            configurationManager.setCurrent(null);
            if (!serverPluginManager.isPluginLoaded("processbridge")) {
                throw new IllegalStateException("processbridge.zip plugin not loaded: " + String.valueOf(serverPluginManager.getPluginLoadError("processbridge")) + "\n\tplugins directory: " + String.valueOf(BaseLocator.getBaseDirectory().createChild("plugins")));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            String string = new Json().toJson(throwable.toString());
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = new Json().toJson(stringWriter.toString());
            printStream.println("{\"jsonrpc\":\"2.0\",\"error\":{\"code\":-32603,\"message\":" + string + ",\"data\":" + string2 + "}, \"id\": null}");
            throw throwable;
        }
    }
}

