/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions;

import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public class PermissionCheckScope {
    private final UserAccount a;
    private final UserGroupManager b;

    public PermissionCheckScope() {
        this.a = UserManager.getInstance().getCurrentUserAccount();
        this.b = UserGroupManager.getInstance();
    }

    public PermissionCheckScope(UserAccount userAccount) {
        this.a = userAccount;
        this.b = UserGroupManager.getInstance();
    }

    public PermissionCheckScope(UserAccount userAccount, UserGroupManager groupManager) {
        this.a = userAccount;
        this.b = groupManager;
    }

    public PermissionCheckScope(GUID userAccountID, UserManager userManager, UserGroupManager groupManager) {
        this.a = userManager.getUserAccount(userAccountID);
        this.b = groupManager;
    }

    public UserAccount getUserAccount() {
        return this.a;
    }

    public UserGroupInfo getAllUsersGroup() {
        return this.b.getGroup(UsersAndGroups.GROUPID_ALLUSERS);
    }

    @Nonnull
    public Set<UserGroupInfo> getUserGroups() {
        if (this.a == null) {
            return Collections.emptySet();
        }
        return this.b.getGroupsForUser(this.a.getID());
    }
}

