/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notification;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;

@JsonData
public class Notification {
    private static final int MAX_LENGTH_TITLE = 300;
    private static final int MAX_LENGTH_MESSAGE = 2000;
    private String title;
    private String message;
    private GUID id;
    private long created;
    private String groupingKey = "system";
    private String targetUrl;
    private boolean permanent;
    private boolean critical;
    private boolean unread = true;
    private boolean fromGenerator = false;

    private Notification() {
    }

    public Notification(String title, String message) {
        this.title = title;
        this.message = message;
        this.id = GUID.generateNew();
        this.created = System.currentTimeMillis();
        this.ensureMessageAndTitleLength();
    }

    private void ensureMessageAndTitleLength() {
        if (StringFunctions.isEmpty(this.title)) {
            this.title = "";
        } else if (this.title.length() > 300) {
            this.title = this.title.substring(0, 297) + "...";
        }
        if (StringFunctions.isEmpty(this.message)) {
            this.message = "";
        } else if (this.message.length() > 2000) {
            this.message = this.message.substring(0, 1997) + "...";
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.ensureMessageAndTitleLength();
    }

    public void setMessage(String message) {
        this.message = message;
        this.ensureMessageAndTitleLength();
    }

    public void setId(GUID id) {
        this.id = id;
    }

    public GUID getId() {
        return this.id;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getCreated() {
        return this.created;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getGroupingKey() {
        return this.groupingKey;
    }

    public void setGroupingKey(String groupingKey) {
        if (StringFunctions.isEmpty(groupingKey)) {
            groupingKey = "system";
        }
        this.groupingKey = groupingKey;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean isUnread() {
        return this.unread;
    }

    public void setFromGenerator(boolean fromGenerator) {
        this.fromGenerator = fromGenerator;
    }

    public boolean isFromGenerator() {
        return this.fromGenerator;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }
}

