/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.DeclaredField;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonWriterFilter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class JsonWriter {
    @Nonnull
    private final Appendable a;
    @Nonnull
    private JsonWriterFilter b = new JsonWriterFilter(){};

    JsonWriter(@Nonnull Appendable writer) {
        this.a = writer;
    }

    public void setWriterFilter(@Nonnull JsonWriterFilter filter) {
        this.b = filter;
    }

    void a(@Nullable Object object) throws IOException {
        if (object == null) {
            this.a.append("null");
        } else {
            ClassWrapper classWrapper = ClassWrapper.getWrapper(object.getClass(), null);
            switch (classWrapper.getJsonType()) {
                case 1: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.a.append(String.valueOf(object));
                    break;
                }
                case 2: 
                case 16: {
                    this.a(object.toString());
                    break;
                }
                case 3: {
                    this.a((Collection)object);
                    break;
                }
                case 4: {
                    this.a((Map)object);
                    break;
                }
                case 5: 
                case 17: {
                    this.b(object);
                    break;
                }
                case 6: {
                    this.a(((Enum)object).name());
                    break;
                }
                case 8: {
                    this.a.append(Long.toString(((Date)object).getTime()));
                    break;
                }
                default: {
                    this.a(object, classWrapper);
                }
            }
        }
    }

    private void a(@Nonnull Object object, @Nonnull ClassWrapper classWrapper) throws IOException {
        boolean bl = true;
        this.a.append('{');
        DeclaredField[] declaredFieldArray = classWrapper.getDeclaredFields();
        for (int i2 = 0; i2 < declaredFieldArray.length; ++i2) {
            Object object2;
            Object object3;
            try {
                DeclaredField declaredField = declaredFieldArray[i2];
                object3 = declaredField.getField();
                object2 = this.b.transformValue(declaredField, ((Field)object3).get(object));
                if (this.b.fieldShouldBeIgnored(declaredField, object2)) continue;
                if (bl) {
                    bl = false;
                } else {
                    this.a.append(',');
                }
                this.a(this.b.transformFieldName(declaredField));
                this.a.append(':');
                this.a(object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                continue;
            }
            catch (StackOverflowError stackOverflowError) {
                object3 = new JsonException(String.valueOf(object));
                ((Throwable)object3).setStackTrace(new StackTraceElement[0]);
                stackOverflowError.addSuppressed((Throwable)object3);
                if (stackOverflowError.getSuppressed().length == 0) {
                    object2 = new StackOverflowError(stackOverflowError.getMessage() + "|" + ((Throwable)object3).getMessage());
                    ((Throwable)object2).addSuppressed((Throwable)object3);
                    if (((Throwable)object2).getSuppressed().length > 0) {
                        ArrayList<@Nonnull StackTraceElement> arrayList = new ArrayList<StackTraceElement>(Arrays.asList(stackOverflowError.getStackTrace()));
                        int n2 = 0;
                        Iterator<@Nonnull StackTraceElement> iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            StackTraceElement stackTraceElement = iterator.next();
                            if (!stackTraceElement.getClassName().equals(this.getClass().getName()) || n2++ <= 10) continue;
                            iterator.remove();
                        }
                        ((Throwable)object2).setStackTrace(arrayList.toArray(new StackTraceElement[arrayList.size()]));
                        throw object2;
                    }
                }
                throw stackOverflowError;
            }
        }
        this.a.append('}');
    }

    private void b(@Nonnull Object object) throws IOException {
        boolean bl = true;
        int n2 = Array.getLength(object);
        this.a.append('[');
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl) {
                bl = false;
            } else {
                this.a.append(',');
            }
            Object object2 = Array.get(object, i2);
            this.a(object2);
        }
        this.a.append(']');
    }

    private void a(@Nonnull Collection<?> collection) throws IOException {
        boolean bl = true;
        this.a.append('[');
        for (Object obj : collection) {
            if (bl) {
                bl = false;
            } else {
                this.a.append(',');
            }
            this.a(obj);
        }
        this.a.append(']');
    }

    private void a(@Nonnull Map<?, ?> map) throws IOException {
        boolean bl = true;
        this.a.append('{');
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                this.a.append(',');
            }
            this.a(String.valueOf(entry.getKey()));
            this.a.append(':');
            this.a(entry.getValue());
        }
        this.a.append('}');
    }

    /*
     * Enabled aggressive block sorting
     */
    private void a(@Nonnull String string) throws IOException {
        this.a.append('\"');
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            block11: {
                if (n3 >= n2) {
                    this.a.append('\"');
                    return;
                }
                char c2 = string.charAt(n3);
                switch (c2) {
                    case '\b': {
                        c2 = 'b';
                        this.a.append('\\');
                        break;
                    }
                    case '\f': {
                        c2 = 'f';
                        this.a.append('\\');
                        break;
                    }
                    case '\n': {
                        c2 = 'n';
                        this.a.append('\\');
                        break;
                    }
                    case '\r': {
                        c2 = 'r';
                        this.a.append('\\');
                        break;
                    }
                    case '\t': {
                        c2 = 't';
                        this.a.append('\\');
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        this.a.append('\\');
                        break;
                    }
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\u000b': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': {
                        this.a.append("\\u");
                        this.a.append(Character.forDigit(c2 >> 12 & 0xF, 16));
                        this.a.append(Character.forDigit(c2 >> 8 & 0xF, 16));
                        this.a.append(Character.forDigit(c2 >> 4 & 0xF, 16));
                        this.a.append(Character.forDigit(c2 & 0xF, 16));
                        break block11;
                    }
                }
                this.a.append(c2);
            }
            ++n3;
        }
    }
}

