/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.http.servlet.SessionStore;
import com.inet.logging.LogManager;
import com.inet.logging.SecurityEventLog;
import com.inet.plugin.DynamicExtension;
import com.inet.thread.SessionLocal;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@InternalApi
public class ExpandableHttpSessionListener
implements HttpSessionListener {
    private static final Map<String, HttpSession> a = new ConcurrentHashMap<String, HttpSession>();
    private final DynamicExtension<HttpSessionListener> b = new DynamicExtension<HttpSessionListener>(HttpSessionListener.class);

    @Nonnull
    public static Collection<HttpSession> getActiveSessions() {
        return a.values();
    }

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        a.put(httpSession.getId(), httpSession);
        for (HttpSessionListener httpSessionListener : this.b.get()) {
            httpSessionListener.sessionCreated(event);
        }
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        boolean bl = SessionStore.getHttpSession(false) == null;
        try {
            HttpSession httpSession = event.getSession();
            String string = httpSession.getId();
            a.remove(string);
            LoginProcessor.LOGGER.debug("HTTP Session destroyed: " + string);
            if (bl) {
                SessionStore.setSession(httpSession);
                LoginManager.initUserAccount(httpSession);
            }
            SecurityEventLog.SessionDestroyed.log(new Object[0]);
            for (HttpSessionListener httpSessionListener : this.b.get()) {
                try {
                    httpSessionListener.sessionDestroyed(event);
                }
                catch (Throwable throwable) {
                    LogManager.getApplicationLogger().error(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error(throwable);
            throw throwable;
        }
        finally {
            if (bl) {
                SessionStore.reset();
                SessionLocal.allRemoveThreadFromSession();
            }
        }
    }
}

