/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.annotations.InternalApi;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class LicenseInfoHolder {
    static final String APP = "app";
    static final String FEATURES = "features";
    @Nonnull
    private List<LicenseInfo> a;
    @Nonnull
    private LicenseInfo b;
    private Map<String, LicenseInfo> c;

    /*
     * WARNING - void declaration
     */
    LicenseInfoHolder(@Nonnull List<LicenseInfo> licenses, @Nullable Configuration configuration) {
        this.a = Collections.unmodifiableList(licenses);
        ArrayList<LicenseInfo> arrayList = new ArrayList<LicenseInfo>();
        for (LicenseInfo object22 : licenses) {
            Map<String, String> map = object22.getAttributes();
            if (StringFunctions.isEmpty(map.get(APP))) continue;
            arrayList.add(object22);
        }
        Object object3 = ApplicationDescription.get().getActiveLicenseInfo(arrayList);
        if (object3 == null) {
            if (arrayList.size() > 0) {
                object3 = arrayList.get(0);
            } else {
                for (LicenseInfo licenseInfo : licenses) {
                    Map<String, String> map = licenseInfo.getAttributes();
                    if (!StringFunctions.isEmpty(map.get(FEATURES))) continue;
                    object3 = licenseInfo;
                    break;
                }
                if (object3 == null) {
                    void var7_23;
                    ApplicationDescription applicationDescription;
                    String string;
                    StringBuilder stringBuilder = new StringBuilder("No license key");
                    if (configuration != null) {
                        String string2 = ConfigurationManager.getScopeName(configuration.getScope());
                        String string3 = configuration.getName();
                        stringBuilder.append(" in the current configuration: \"").append(string2).append("/" + string3).append('\"');
                    }
                    if (StringFunctions.isEmpty(string = (applicationDescription = ApplicationDescription.get()).getTrialLicenseBrowserURL())) {
                        String string4 = applicationDescription.getDefaultSupportAddress();
                    }
                    stringBuilder.append(". You need to set a license key. You can request a trial license key from: ").append((String)var7_23);
                    object3 = new LicenseInfo(() -> "No license", null, () -> stringBuilder.toString(), new HashMap<String, String>());
                }
            }
        }
        this.b = object3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (((LicenseInfo)object3).isValid()) {
            for (LicenseInfo licenseInfo : licenses) {
                String string;
                Map<String, String> map = licenseInfo.getAttributes();
                if (!licenseInfo.isValid() || (string = map.get(FEATURES)) == null) continue;
                for (String string5 : string.split(",")) {
                    if (StringFunctions.isEmpty(string5) || hashMap.containsKey(string5)) continue;
                    hashMap.put(string5, licenseInfo);
                }
            }
            hashMap.put(ServerPluginManager.getInstance().getCorePluginId(), object3);
            hashMap.put(((LicenseInfo)object3).getAttributes().get(APP), object3);
            if (Boolean.parseBoolean(((LicenseInfo)object3).getAttributes().get("crplus"))) {
                hashMap.put("taskplanner", object3);
                hashMap.put("drive", object3);
            }
        }
        this.c = Collections.unmodifiableMap(hashMap);
    }

    @Nonnull
    public LicenseInfo getCurrent() {
        return this.b;
    }

    public boolean hasValidLicenseFor(String feature) {
        LicenseInfo licenseInfo = this.c.get(feature);
        return licenseInfo != null && licenseInfo.isValid();
    }

    @Nonnull
    public List<LicenseInfo> getAll() {
        return this.a;
    }

    @Nonnull
    public Map<String, LicenseInfo> getAllFeatures() {
        return this.c;
    }
}

