/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader;

import com.inet.annotations.InternalApi;
import com.inet.classloader.BaseLocator;
import com.inet.classloader.UpdateableClassLoader;
import com.inet.classloader.UpdateableClassLoaderImpl;
import com.inet.classloader.UrlUpdateableClassLoader;
import com.inet.classloader.a;
import com.inet.classloader.jnlp.BaseUpdateableClassLoader;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.io.URLProtocolManager;
import com.inet.lib.io.data.Handler;
import com.inet.lib.util.DebugUtils;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.DependencyClassLoader;
import com.inet.plugin.InetcoreServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.FileResourceFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.shared.utils.TriFunction;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.TransformerFactory;

@InternalApi
public class LoaderUtils {
    private static final TriFunction<@Nonnull String, @Nonnull Locale, @Nonnull ClassLoader, ResourceBundle> a;
    private static ClassLoader b;
    private static SAXParserFactory c;
    private static XMLOutputFactory d;
    private static final Map<String, Set<String>> e;
    private static final Set<String> f;

    public static ClassLoader getUpdateableClassLoader() {
        return b;
    }

    public static Class<?> classForName(String name, @Nullable Object caller) throws ClassNotFoundException {
        ClassLoader classLoader = LoaderUtils.getUpdateableClassLoader();
        try {
            return LoaderUtils.a(name, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader2;
            ClassLoader classLoader3;
            ClassNotFoundException classNotFoundException2 = classNotFoundException;
            if (caller != null) {
                classLoader3 = LoaderUtils.a(caller);
                if (classLoader != classLoader3) {
                    try {
                        return LoaderUtils.a(name, classLoader3);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        classNotFoundException2 = classNotFoundException3;
                    }
                }
            } else {
                classLoader3 = null;
            }
            if (classLoader != (classLoader2 = Thread.currentThread().getContextClassLoader()) && classLoader3 != classLoader2) {
                try {
                    return LoaderUtils.a(name, classLoader2);
                }
                catch (ClassNotFoundException classNotFoundException4) {
                    classNotFoundException2 = classNotFoundException4;
                }
            }
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            for (String string : serverPluginManager.getLoadedPlugins()) {
                try {
                    return LoaderUtils.a(name, serverPluginManager.getPluginDescription(string).getClassLoader());
                }
                catch (Throwable throwable) {
                }
            }
            throw classNotFoundException2;
        }
    }

    @Nonnull
    private static ClassLoader a(@Nonnull Object object) {
        if (object.getClass() == Class.class) {
            return ((Class)object).getClassLoader();
        }
        if (object instanceof ClassLoader) {
            return (ClassLoader)object;
        }
        return object.getClass().getClassLoader();
    }

    public static Enumeration<URL> getResources(String name, @Nullable Object caller) throws IOException {
        ClassLoader classLoader;
        ClassLoader classLoader2;
        HashSet<URL> hashSet = new HashSet<URL>();
        ClassLoader classLoader3 = LoaderUtils.getUpdateableClassLoader();
        Enumeration<URL> enumeration = classLoader3.getResources(name);
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        if (caller != null) {
            classLoader2 = LoaderUtils.a(caller);
            if (classLoader3 != classLoader2) {
                enumeration = classLoader2.getResources(name);
                while (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
            }
        } else {
            classLoader2 = null;
        }
        if (classLoader3 != (classLoader = Thread.currentThread().getContextClassLoader()) && classLoader2 != classLoader) {
            enumeration = classLoader.getResources(name);
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
        }
        return Collections.enumeration(hashSet);
    }

    public static URL getResource(String name, @Nullable Object caller) {
        ClassLoader classLoader;
        ClassLoader classLoader2;
        ClassLoader classLoader3 = LoaderUtils.getUpdateableClassLoader();
        URL uRL = classLoader3.getResource(name);
        if (uRL != null) {
            return uRL;
        }
        if (caller != null) {
            classLoader2 = LoaderUtils.a(caller);
            if (classLoader3 != classLoader2 && (uRL = classLoader2.getResource(name)) != null) {
                return uRL;
            }
        } else {
            classLoader2 = null;
        }
        if (classLoader3 != (classLoader = Thread.currentThread().getContextClassLoader()) && classLoader2 != classLoader) {
            return classLoader.getResource(name);
        }
        return null;
    }

    public static ResourceBundle getBundle(String resourceBundleName, Locale locale, @Nullable Object caller) throws MissingResourceException {
        ClassLoader classLoader;
        ClassLoader classLoader2;
        MissingResourceException missingResourceException = null;
        if (caller != null) {
            Object object;
            classLoader2 = LoaderUtils.a(caller);
            if (classLoader2 == InetcoreServerPlugin.class.getClassLoader() && (object = ServerPluginManager.getInstance().getPluginDescription("inetcore")) != null) {
                classLoader2 = ((ServerPluginDescription)object).getClassLoader();
            }
            try {
                object = a.apply(resourceBundleName, locale, classLoader2);
                LoaderUtils.a(classLoader2, resourceBundleName, (ResourceBundle)object);
                return object;
            }
            catch (MissingResourceException missingResourceException2) {
                missingResourceException = missingResourceException2;
            }
        } else {
            classLoader2 = null;
        }
        ClassLoader classLoader3 = LoaderUtils.getUpdateableClassLoader();
        if (classLoader3 != classLoader2) {
            try {
                ResourceBundle resourceBundle = a.apply(resourceBundleName, locale, classLoader3);
                LoaderUtils.a(classLoader3, resourceBundleName, resourceBundle);
                return resourceBundle;
            }
            catch (MissingResourceException missingResourceException3) {
                missingResourceException = missingResourceException3;
            }
        }
        if (classLoader3 != (classLoader = Thread.currentThread().getContextClassLoader()) && classLoader2 != classLoader && classLoader != null) {
            return a.apply(resourceBundleName, locale, classLoader);
        }
        throw missingResourceException;
    }

    private static void a(@Nonnull ClassLoader classLoader, String string, ResourceBundle resourceBundle) {
        ConcurrentHashMap.KeySetView keySetView;
        if (f.contains(string)) {
            return;
        }
        f.add(string);
        if (!(resourceBundle instanceof PropertyResourceBundle)) {
            return;
        }
        String string2 = classLoader.getClass() == DependencyClassLoader.class ? ((keySetView = ((DependencyClassLoader)classLoader).getClassLoaderOfResource(string.replace('.', '/') + ".properties")) != null && keySetView.getClass() == DependencyClassLoader.class ? ((DependencyClassLoader)((Object)keySetView)).getPluginId() : ((DependencyClassLoader)classLoader).getPluginId()) : "inetcore";
        keySetView = e.get(string2);
        if (keySetView == null) {
            keySetView = ConcurrentHashMap.newKeySet();
            e.put(string2, keySetView);
        }
        keySetView.add(string);
    }

    @Nonnull
    public static Map<String, Set<String>> getLoadedBundles() {
        return e;
    }

    public static void clearTranslationCache(String pluginId) {
        ServerPluginDescription serverPluginDescription = ServerPluginManager.getInstance().getPluginDescription(pluginId);
        if (serverPluginDescription != null) {
            ClassLoader classLoader = serverPluginDescription.getClassLoader();
            if (classLoader instanceof DependencyClassLoader) {
                ((DependencyClassLoader)classLoader).clearTranslation();
            }
            ResourceBundle.clearCache(classLoader);
        }
    }

    private static Class<?> a(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(string.trim(), true, classLoader);
    }

    private static void a(String string) {
        if (!(b instanceof UpdateableClassLoader) || "true".equals(System.getProperty("inetuninstall"))) {
            return;
        }
        List<URL> list = LoaderUtils.getLibDirectoryJars(string);
        for (URL uRL : list) {
            if (b instanceof UpdateableClassLoader) {
                ((UpdateableClassLoader)((Object)b)).addUrl(uRL);
                continue;
            }
            Logger logger = LogManager.getConfigLogger();
            if (!logger.isDebug()) continue;
            logger.debug("[UpdateableClassLoader] NO UpdateableClassLoader available: can not add " + uRL.toString() + " to the classpath");
        }
        if (b instanceof UpdateableClassLoader) {
            ((UpdateableClassLoader)((Object)b)).fireLibrariesLoadedEvent();
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public static List<URL> getLibDirectoryJars(String libDirectories) {
        if (libDirectories == null) {
            libDirectories = "";
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String malformedURLException : libDirectories.split(",")) {
            String object2 = malformedURLException.trim();
            if (object2.length() <= 1) continue;
            hashSet.add(object2);
        }
        ArrayList arrayList = new ArrayList();
        for (String string : hashSet) {
            File file;
            Object object;
            block9: {
                if (string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".dll") || string.endsWith(".exe")) {
                    try {
                        URL uRL = new URL(string);
                        arrayList.add(uRL);
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        object = new File(string);
                        if (!((File)object).isFile()) break block9;
                        try {
                            arrayList.add(((File)object).toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException2) {
                            LogManager.getConfigLogger().error(malformedURLException2);
                        }
                    }
                }
            }
            if ((file = new File(string)).exists() && file.isDirectory()) {
                LoaderUtils.a(arrayList, file);
                continue;
            }
            object = LogManager.getConfigLogger();
            if (!object.isDebug()) continue;
            object.debug("file or directory at location " + string + " not found.");
        }
        return arrayList;
    }

    private static void a(List<URL> list, File file) {
        Logger logger = LogManager.getConfigLogger();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            if (logger.isDebug()) {
                logger.debug("scan: " + String.valueOf(file));
            }
            for (File file2 : fileArray) {
                if (file2.isFile()) {
                    String string = file2.getName().toLowerCase();
                    if (!string.endsWith(".jar") && !string.endsWith(".zip") && !string.endsWith(".dll") && !string.endsWith(".exe")) continue;
                    try {
                        list.add(file2.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    continue;
                }
                LoaderUtils.a(list, file2);
            }
        }
    }

    @Nonnull
    public static <T> List<T> objectsForNames(String names, Class<T> clazz) {
        String[] stringArray;
        ArrayList arrayList = new ArrayList();
        if (names == null) {
            return arrayList;
        }
        for (String string : stringArray = names.split(",|;")) {
            if ((string = string.trim()).isEmpty()) continue;
            try {
                Class<?> clazz2 = LoaderUtils.classForName(string, clazz);
                if (clazz.isAssignableFrom(clazz2)) {
                    arrayList.add(clazz2.newInstance());
                    continue;
                }
                LogManager.getConfigLogger().warn("Loading of Class \"" + string + "\" failed. Reason: Not an instance of : " + clazz.getName());
            }
            catch (Throwable throwable) {
                LogManager.getConfigLogger().warn("Loading of Class \"" + string + "\" failed. Reason: " + String.valueOf(throwable));
            }
        }
        return arrayList;
    }

    @Nonnull
    public static String getLibDirectories() {
        File file;
        String string;
        Object object;
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        Object object2 = configuration.get(ConfigKey.LIB_DIRECTORY.getKey());
        ResourceFile resourceFile = BaseLocator.getBaseDirectory();
        String string2 = resourceFile instanceof FileResourceFile ? String.valueOf(resourceFile) + "/lib" : "";
        try {
            string2 = System.getProperty("clearreports.lib", string2);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!string2.isEmpty()) {
            try {
                object = BaseLocator.class.getProtectionDomain().getCodeSource().getLocation();
                string = IOFunctions.getFile((URL)object).getParent();
                if (string.startsWith(string2)) {
                    string2 = "";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object2 == null || ((String)object2).trim().length() == 0) {
            object2 = string2;
        } else {
            object2 = ((String)object2).replace('\\', '/');
            if (string2.length() > 0) {
                object2 = (String)object2 + "," + string2;
            }
        }
        object = configuration.get("designerLibraries");
        if (object != null) {
            object2 = (String)object2 + "," + (String)object;
        }
        string = System.getProperty("UserHome");
        String string3 = System.getProperty("LibraryDirectory");
        if (string != null && string3 != null && string3.startsWith(string) && (file = new File(string, "lib")).exists()) {
            object2 = (String)object2 + "," + String.valueOf(file);
        }
        return object2;
    }

    private static void a() {
        String string = LoaderUtils.getLibDirectories();
        Logger logger = LogManager.getConfigLogger();
        if (logger.isDebug()) {
            logger.debug("libraries loaded from the lib-directory/-ies " + string + " :");
        }
        LoaderUtils.a(string);
    }

    public static SAXParserFactory newSaxParserFactory() {
        SAXParserFactory sAXParserFactory = c;
        if (sAXParserFactory != null) {
            return sAXParserFactory;
        }
        try {
            sAXParserFactory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().info("SAXParserFactory: " + String.valueOf(throwable));
            sAXParserFactory = SAXParserFactory.newInstance();
        }
        try {
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error(throwable);
        }
        c = sAXParserFactory;
        return c;
    }

    public static XMLOutputFactory newXMLOutputFactory() {
        XMLOutputFactory xMLOutputFactory = d;
        if (xMLOutputFactory != null) {
            return xMLOutputFactory;
        }
        try {
            String string = "com.sun.xml.internal.stream.XMLOutputFactoryImpl";
            String string2 = System.getProperty(string);
            System.setProperty(string, "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
            xMLOutputFactory = XMLOutputFactory.newFactory(string, null);
            if (string2 == null) {
                System.clearProperty(string);
            } else {
                System.setProperty(string, string2);
            }
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().info("SAXParserFactory: " + String.valueOf(throwable));
            xMLOutputFactory = XMLOutputFactory.newInstance();
        }
        d = xMLOutputFactory;
        return d;
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null);
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().info("DocumentBuilderFactory: " + String.valueOf(throwable));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error(throwable);
        }
        return documentBuilderFactory;
    }

    public static TransformerFactory newTransformerFactory() {
        TransformerFactory transformerFactory;
        try {
            transformerFactory = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().info("TransformerFactory: " + String.valueOf(throwable));
            transformerFactory = TransformerFactory.newInstance();
        }
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }

    private static /* synthetic */ ResourceBundle a(ResourceBundle.Control control, String string, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(string, locale, classLoader, control);
    }

    static {
        Object object;
        if (LoaderUtils.class.getModule().isNamed()) {
            a = (string, locale, classLoader) -> ResourceBundle.getBundle(string, locale, classLoader);
        } else {
            object = new ResourceBundle.Control(){

                @Override
                public Locale getFallbackLocale(String baseName, Locale locale) {
                    return null;
                }

                @Override
                public List<String> getFormats(String baseName) {
                    return FORMAT_PROPERTIES;
                }

                @Override
                public long getTimeToLive(String baseName, Locale locale) {
                    return DebugUtils.DEBUG ? 5000L : super.getTimeToLive(baseName, locale);
                }
            };
            a = (arg_0, arg_1, arg_2) -> LoaderUtils.a((ResourceBundle.Control)object, arg_0, arg_1, arg_2);
        }
        b = LoaderUtils.class.getClassLoader();
        e = new ConcurrentHashMap<String, Set<String>>();
        f = ConcurrentHashMap.newKeySet();
        object = LogManager.getConfigLogger();
        AccessController.doPrivileged(new PrivilegedAction<Object>((Logger)object){
            final /* synthetic */ Logger a;
            {
                this.a = logger;
            }

            @Override
            public Object run() {
                block9: {
                    URLProtocolManager.register("data", new Handler());
                    try {
                        if (b instanceof BaseUpdateableClassLoader) {
                            if (this.a.isDebug()) {
                                this.a.debug("Use parent classloader as updatable: " + b.getClass().getName());
                            }
                            b = new UpdateableClassLoaderImpl((BaseUpdateableClassLoader)((Object)b));
                        } else {
                            if (this.a.isDebug()) {
                                this.a.debug("Parent classloader is " + String.valueOf(b) + ". Use URLUpdateableClassLoader.");
                            }
                            b = new UpdateableClassLoaderImpl(new UrlUpdateableClassLoader(b));
                        }
                    }
                    catch (SecurityException securityException) {
                        if (!this.a.isWarning()) break block9;
                        this.a.warn("[UpdateableClassLoader] no UpdateableClassLoader available");
                        this.a.warn(securityException);
                    }
                }
                LoaderUtils.a();
                DriverManager.getLoginTimeout();
                ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class, b);
                Iterator<Driver> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    try {
                        Driver driver = iterator.next();
                        this.a.debug("Register driver: " + driver.getClass().getName());
                        DriverManager.registerDriver(new a(driver));
                    }
                    catch (Throwable throwable) {
                        this.a.debug(throwable.toString());
                    }
                }
                return null;
            }
        });
    }
}

