/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.internal;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryListener;
import com.inet.cache.internal.ExternalDataMap;
import com.inet.cache.internal.ExternalDataMapEntry;
import com.inet.cache.internal.FinalizerMemoryThreshold;
import com.inet.cache.internal.h;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.thread.ThreadUtils;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

@InternalApi
public class MemoryObserver {
    static final Logger a = LogManager.getLogger("Cache");
    private static int c;
    private static final ExternalDataMapEntry d;
    private static final ExternalDataMapEntry e;
    private static final ExternalDataMapEntry f;
    private static final ExternalDataMapEntry g;
    private static final MemoryObserver h;
    private static volatile int i;
    private static long j;
    static h b;
    public static final double GOOD_MEMEORY_THRESHOLD = 0.7;
    public static final double LOW_MEMEORY_THRESHOLD;
    private static Thread[] k;
    private static boolean l;
    private static List<MemoryListener> m;
    static final int SHUTDOWN_ORDER = 1000000;
    private static final ForkJoinPool n;

    private MemoryObserver() {
        ShutdownManager.add(new ShutdownFinalizer(){

            @Override
            public void onShutdown() {
                MemoryObserver.stopMemoryObserver();
            }

            @Override
            public int order() {
                return 1000000;
            }
        });
    }

    public static long getMaxMemory() {
        return b.getMaxMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long a() {
        long l2 = b.exceedingGoodMemoryThreshold();
        if (l2 <= 0L) {
            return l2;
        }
        long l3 = l2;
        b.incThreadCount();
        try {
            long l4;
            MemoryObserver memoryObserver = h;
            synchronized (memoryObserver) {
                block13: {
                    int n2 = MemoryObserver.getEntryCount();
                    if (n2 != 0) break block13;
                    long l5 = l2;
                    return l5;
                }
                h.notifyAll();
            }
            l2 -= MemoryObserver.a(g);
            l2 -= MemoryObserver.a(e);
            l2 -= MemoryObserver.a(d);
            l2 = MemoryObserver.a(g, l2, null, false);
            if (l2 > 0L) {
                l2 = MemoryObserver.a(f, l2, null, false);
            }
            if (l2 > 0L) {
                l2 = MemoryObserver.a(e, l2, null, false);
            }
            if (l2 > 0L) {
                l2 = MemoryObserver.a(d, l2, null, false);
            }
            if (l3 == l2 && (l4 = b.exceedingLowMemoryThresholdWithGC()) > 0L) {
                l2 = b.exceedingGoodMemoryThreshold();
                long l6 = MemoryObserver.a(d, l2, null, true);
                a.warn("There was a low memory situation and possibly some jobs were canceled. Memory threshold before: " + l2 + " Memory threshold: " + l6);
                l2 = l6;
            }
        }
        finally {
            b.decThreadCount();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long a(ExternalDataMapEntry externalDataMapEntry) {
        long l2 = System.currentTimeMillis();
        AtomicLong atomicLong = new AtomicLong();
        MemoryObserver memoryObserver = h;
        synchronized (memoryObserver) {
            ExternalDataMapEntry externalDataMapEntry2 = externalDataMapEntry.j();
            while (externalDataMapEntry2 != externalDataMapEntry) {
                ExternalDataMapEntry externalDataMapEntry3 = externalDataMapEntry2.j();
                if (externalDataMapEntry2.a(l2)) {
                    MemoryObserver.remove(externalDataMapEntry2);
                    ExternalDataMapEntry externalDataMapEntry4 = externalDataMapEntry2;
                    n.execute(() -> AccessController.doPrivileged(() -> {
                        ExternalDataMap externalDataMap = externalDataMapEntry4.h();
                        atomicLong.addAndGet(externalDataMapEntry4.getMemorySize());
                        externalDataMap.a(externalDataMapEntry4);
                        return null;
                    }));
                }
                if (externalDataMapEntry3 == externalDataMapEntry2) break;
                externalDataMapEntry2 = externalDataMapEntry3;
            }
        }
        if (Thread.currentThread() instanceof a) {
            n.awaitQuiescence(10L, TimeUnit.SECONDS);
        }
        return atomicLong.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long a(long l2, ExternalDataMapEntry externalDataMapEntry) {
        MemoryObserver memoryObserver = h;
        synchronized (memoryObserver) {
            for (ExternalDataMapEntry externalDataMapEntry2 = externalDataMapEntry.j(); externalDataMapEntry2 != externalDataMapEntry; externalDataMapEntry2 = externalDataMapEntry2.j()) {
                l2 = Math.min(l2, externalDataMapEntry2.timeout());
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> long a(ExternalDataMapEntry<K, V> externalDataMapEntry, long l2, ExternalDataMapEntry<K, V> externalDataMapEntry2, boolean bl) {
        ExternalDataMapEntry<K, V> externalDataMapEntry3 = null;
        ExternalDataMapEntry<K, V> externalDataMapEntry4 = null;
        ExternalDataMapEntry<K, V> externalDataMapEntry5 = null;
        while (true) {
            Object object;
            if (externalDataMapEntry5 != null) {
                object = externalDataMapEntry5.h();
                long l3 = externalDataMapEntry5.getMemorySize();
                ((ExternalDataMap)object).a(externalDataMapEntry5);
                l2 -= l3;
                externalDataMapEntry5 = null;
            }
            if (l2 < 0L) {
                return l2;
            }
            object = h;
            synchronized (object) {
                if (externalDataMapEntry4 == null) {
                    externalDataMapEntry4 = externalDataMapEntry.j();
                }
                if (externalDataMapEntry4.h() == null || externalDataMapEntry4 == externalDataMapEntry3 || externalDataMapEntry4.j() == externalDataMapEntry4) {
                    break;
                }
                if (!externalDataMapEntry4.a(externalDataMapEntry)) {
                    externalDataMapEntry4 = null;
                    continue;
                }
                externalDataMapEntry3 = externalDataMapEntry4;
                if (externalDataMapEntry3.isExpired()) {
                    externalDataMapEntry4 = externalDataMapEntry3.j();
                    MemoryObserver.remove(externalDataMapEntry3);
                    externalDataMapEntry5 = externalDataMapEntry3;
                    continue;
                }
                if (externalDataMapEntry3.h().b()) {
                    externalDataMapEntry4 = externalDataMapEntry3.j();
                    if (bl) {
                        MemoryObserver.remove(externalDataMapEntry3);
                        externalDataMapEntry5 = externalDataMapEntry3;
                    }
                    continue;
                }
                externalDataMapEntry4 = externalDataMapEntry3.j();
                MemoryObserver.remove(externalDataMapEntry3);
            }
            if (l) {
                return -1L;
            }
            try {
                if (externalDataMapEntry2 == null) {
                    l2 -= externalDataMapEntry3.c();
                    continue;
                }
                externalDataMapEntry3.b();
                object = h;
                synchronized (object) {
                    if (externalDataMapEntry3.j() == externalDataMapEntry3) {
                        externalDataMapEntry3.b(externalDataMapEntry2);
                        ++i;
                        ++c;
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (l) continue;
                a.error(throwable);
                continue;
            }
            break;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(ExternalDataMapEntry<?, ?> entry) {
        b.blockOnLowMemory();
        MemoryObserver memoryObserver = h;
        synchronized (memoryObserver) {
            if (entry.f()) {
                return;
            }
            if (entry.i()) {
                --c;
            }
            MemoryObserver.b(entry);
            ++i;
            ++c;
            if (!entry.h().b() || entry.timeout() < j) {
                h.notifyAll();
            }
        }
        MemoryObserver.getBackgroundWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Thread[] getBackgroundWriter() {
        if (k == null) {
            MemoryObserver memoryObserver = h;
            synchronized (memoryObserver) {
                if (k == null) {
                    k = new Thread[2];
                    for (int i2 = 0; i2 < k.length; ++i2) {
                        MemoryObserver.k[i2] = new a(i2 + 1);
                        k[i2].start();
                    }
                }
            }
        }
        return k;
    }

    private static void b(ExternalDataMapEntry<?, ?> externalDataMapEntry) {
        switch (externalDataMapEntry.g()) {
            case FrequentlyChanged: {
                externalDataMapEntry.b(d);
                break;
            }
            case Normal: {
                externalDataMapEntry.b(e);
                break;
            }
            case RarelyUsed: {
                externalDataMapEntry.b(g);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markUse(ExternalDataMapEntry<?, ?> entry) {
        MemoryObserver memoryObserver = h;
        synchronized (memoryObserver) {
            if (entry.i()) {
                MemoryObserver.b(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ExternalDataMapEntry<?, ?> entry) {
        MemoryObserver memoryObserver = h;
        synchronized (memoryObserver) {
            if (entry.i()) {
                --c;
            }
        }
    }

    public static int getEntryCount() {
        return c;
    }

    static void a(long l2) {
        b.fireMemoryEvents(m, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopMemoryObserver() {
        l = true;
        Thread[] threadArray = h;
        synchronized (h) {
            Thread[] threadArray2 = k;
            k = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (threadArray2 != null) {
                for (Thread thread : threadArray2) {
                    ThreadUtils.stopThread(thread);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getMemorySize() {
        ExternalDataMapEntry[] externalDataMapEntryArray = new ExternalDataMapEntry[c];
        MemoryObserver memoryObserver = h;
        synchronized (memoryObserver) {
            int n2 = 0;
            n2 = MemoryObserver.a(d, externalDataMapEntryArray, n2);
            n2 = MemoryObserver.a(e, externalDataMapEntryArray, n2);
            n2 = MemoryObserver.a(g, externalDataMapEntryArray, n2);
            n2 = MemoryObserver.a(f, externalDataMapEntryArray, n2);
        }
        long l2 = 0L;
        for (ExternalDataMapEntry externalDataMapEntry : externalDataMapEntryArray) {
            if (externalDataMapEntry == null) continue;
            l2 += externalDataMapEntry.getMemorySize();
            externalDataMapEntryArray[var3_5] = null;
        }
        return l2;
    }

    private static int a(ExternalDataMapEntry<?, ?> externalDataMapEntry, ExternalDataMapEntry[] externalDataMapEntryArray, int n2) {
        ExternalDataMapEntry<?, ?> externalDataMapEntry2;
        int n3 = externalDataMapEntryArray.length;
        ExternalDataMapEntry<?, ?> externalDataMapEntry3 = externalDataMapEntry.j();
        while (externalDataMapEntry3 != externalDataMapEntry && n2 < n3 && (externalDataMapEntry2 = externalDataMapEntry3.j()) != externalDataMapEntry3) {
            externalDataMapEntryArray[n2++] = externalDataMapEntry3;
            externalDataMapEntry3 = externalDataMapEntry2;
        }
        return n2;
    }

    public static boolean checkMemory() {
        long l2 = MemoryObserver.a();
        return l2 <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMemoryListener(MemoryListener listener) {
        MemoryObserver memoryObserver = h;
        synchronized (memoryObserver) {
            if (m == null) {
                m = new CopyOnWriteArrayList<MemoryListener>();
            }
            m.add(listener);
        }
    }

    public static void setPercentageThresholds(double goodMemoryThreshold, double lowMemoryThreshold) {
        b.setPercentageThresholds(goodMemoryThreshold, lowMemoryThreshold);
    }

    static {
        d = new ExternalDataMapEntry();
        e = new ExternalDataMapEntry();
        f = new ExternalDataMapEntry();
        g = new ExternalDataMapEntry();
        h = new MemoryObserver();
        b = new FinalizerMemoryThreshold();
        long l2 = b.getMaxMemory();
        LOW_MEMEORY_THRESHOLD = Math.max(((double)l2 - 2.62144E8) / (double)l2, 0.85);
        b.setPercentageThresholds(0.7, LOW_MEMEORY_THRESHOLD);
        n = new ForkJoinPool(10);
    }

    private static class a
    extends Thread {
        a(int n2) {
            super("Heap Cache Writer " + n2);
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            AccessController.doPrivileged(() -> {
                while (true) {
                    try {
                        while (true) {
                            int n2;
                            int n3 = c;
                            b.incThreadCount();
                            try {
                                do {
                                    n2 = i;
                                    MemoryObserver.a(d);
                                    MemoryObserver.a(g, Integer.MAX_VALUE, null, false);
                                    MemoryObserver.a(e, Integer.MAX_VALUE, f, false);
                                } while (n2 != i);
                            }
                            finally {
                                b.decThreadCount();
                            }
                            MemoryObserver.a(b.exceedingGoodMemoryThreshold());
                            MemoryObserver memoryObserver = h;
                            synchronized (memoryObserver) {
                                if (n2 == i && n3 == c) {
                                    long l2 = MemoryObserver.a(Long.MAX_VALUE, d);
                                    l2 = MemoryObserver.a(l2, g);
                                    j = l2 = MemoryObserver.a(l2, e);
                                    h.wait(Math.max(1000L, l2 - System.currentTimeMillis()));
                                }
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        a.debug(this.getName() + " terminated");
                        MemoryObserver.stopMemoryObserver();
                        return null;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        System.gc();
                        System.runFinalization();
                        a.error("OutOfMemoryError in " + this.getName(), outOfMemoryError);
                        continue;
                    }
                    catch (Throwable throwable) {
                        a.error(throwable);
                        continue;
                    }
                    break;
                }
            });
        }
    }
}

