/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit;

import com.inet.pdfc.junit.ComparisonFailedException;
import com.inet.pdfc.junit.PDFComparer;
import com.inet.pdfc.junit.Result;
import com.inet.pdfc.junit.impl.ByteBufferInputStream;
import com.inet.pdfc.junit.impl.SupplierWithIOException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nonnull;

public class ResultPDF
extends Result {
    private PAGE_FORMAT pageFormat = PAGE_FORMAT.A4;
    private ORIENTATION orientation = ORIENTATION.portrait;
    private SIDE sides = SIDE.both;
    private boolean headerFooter = true;
    private boolean fitToPage = false;
    private boolean onlyDifferences = false;
    private boolean comments = true;
    private boolean exportOnlyIfDifferences = false;
    private String passwordBase64 = null;
    private boolean fontEmbedding = true;
    private SupplierWithIOException<OutputStream> streamProvider;

    public ResultPDF(@Nonnull @Nonnull SupplierWithIOException<@Nonnull OutputStream> streamProvider) {
        this.streamProvider = streamProvider;
    }

    public ResultPDF(@Nonnull File targetFile) {
        this.streamProvider = () -> new BufferedOutputStream(new FileOutputStream(targetFile));
    }

    @Override
    void setRequestParameters(@Nonnull Map<PDFComparer.Part, HttpRequest.BodyPublisher> parameters) {
        parameters.put(new PDFComparer.Part("result"), HttpRequest.BodyPublishers.ofString("pdf"));
        if (this.pageFormat != PAGE_FORMAT.A4) {
            parameters.put(new PDFComparer.Part("pageformat"), HttpRequest.BodyPublishers.ofString(this.pageFormat.name()));
        }
        if (this.orientation != ORIENTATION.portrait) {
            parameters.put(new PDFComparer.Part("orientation"), HttpRequest.BodyPublishers.ofString(this.orientation.name().toUpperCase()));
        }
        if (this.sides != SIDE.both) {
            parameters.put(new PDFComparer.Part("onlyside"), HttpRequest.BodyPublishers.ofString(this.sides.name().toUpperCase()));
        }
        if (!this.headerFooter) {
            parameters.put(new PDFComparer.Part("headerandfooter"), HttpRequest.BodyPublishers.ofString("false"));
        }
        if (this.fitToPage) {
            parameters.put(new PDFComparer.Part("fittopage"), HttpRequest.BodyPublishers.ofString("true"));
        }
        if (this.onlyDifferences) {
            parameters.put(new PDFComparer.Part("onlydifferent"), HttpRequest.BodyPublishers.ofString("true"));
        }
        if (!this.comments) {
            parameters.put(new PDFComparer.Part("fittopage"), HttpRequest.BodyPublishers.ofString("false"));
        }
        if (this.exportOnlyIfDifferences) {
            parameters.put(new PDFComparer.Part("exportifdiff"), HttpRequest.BodyPublishers.ofString("true"));
        }
        if (!this.fontEmbedding) {
            parameters.put(new PDFComparer.Part("fontembedding"), HttpRequest.BodyPublishers.ofString("false"));
        }
        if (this.passwordBase64 != null) {
            parameters.put(new PDFComparer.Part("password"), HttpRequest.BodyPublishers.ofString(this.passwordBase64));
        }
    }

    @Override
    void handleRequest(@Nonnull InputStream result) throws IOException, InterruptedException, ComparisonFailedException {
        try (OutputStream out = this.streamProvider.get();){
            ByteBufferInputStream.copyData(result, out);
        }
    }

    public void setPageFormat(PAGE_FORMAT pageFormat) {
        this.pageFormat = pageFormat;
    }

    public void setOrientation(ORIENTATION orientation) {
        this.orientation = orientation;
    }

    public void setSides(SIDE sides) {
        this.sides = sides;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public void setOnlyDifferences(boolean onlyDifferences) {
        this.onlyDifferences = onlyDifferences;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public void setExportOnlyIfDifferences(boolean exportOnlyIfDifferences) {
        this.exportOnlyIfDifferences = exportOnlyIfDifferences;
    }

    public void setPasswordBase64(String password) {
        this.passwordBase64 = password != null ? Base64.getMimeEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8)) : null;
    }

    public void setFontEmbedding(boolean fontEmbedding) {
        this.fontEmbedding = fontEmbedding;
    }

    public static enum PAGE_FORMAT {
        Auto,
        A3,
        A4,
        A5,
        B4,
        B5,
        Legal,
        Letter;

    }

    public static enum ORIENTATION {
        portrait,
        landscape;

    }

    public static enum SIDE {
        left,
        right,
        both;

    }
}

