/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit;

import com.inet.pdfc.junit.ComparisonFailedException;
import com.inet.pdfc.junit.PDFComparer;
import com.inet.pdfc.junit.Result;
import com.inet.pdfc.junit.impl.ByteBufferInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;

public class ResultCount
extends Result {
    private int differenceCount;

    @Override
    void setRequestParameters(@Nonnull Map<PDFComparer.Part, HttpRequest.BodyPublisher> parameters) {
        parameters.put(new PDFComparer.Part("result"), HttpRequest.BodyPublishers.ofString("count"));
        parameters.put(new PDFComparer.Part("format"), HttpRequest.BodyPublishers.ofString("html"));
    }

    @Override
    void handleRequest(@Nonnull InputStream stream) throws IOException, InterruptedException, ComparisonFailedException {
        String result = ByteBufferInputStream.readString(stream, StandardCharsets.UTF_8);
        try {
            this.differenceCount = Integer.parseInt(result);
        }
        catch (Exception e) {
            throw new ComparisonFailedException(ComparisonFailedException.ERROR_TYPE.resultError, (Throwable)e);
        }
    }

    public int getDifferenceCount() {
        return this.differenceCount;
    }
}

