/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.junit.ComparisonFailedException;
import com.inet.pdfc.junit.PDFComparer;
import com.inet.pdfc.junit.ResultCount;
import com.inet.pdfc.junit.impl.PdfData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;

@PublicApi
public class PdfcAssertHTTP {
    private static PDFComparer comparer = new PDFComparer();

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This is end user API. It will read a local file defined by the user of the programming API")
    public static void setPdfcConfiguration(String configName) throws IOException {
        if (configName == null) {
            comparer.setProfile((InputStream)null);
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(configName);){
                comparer.setProfile(fileInputStream);
            }
        }
    }

    public static void setPdfcConfigurationWithName(String nameOrID) {
        comparer.setProfile(nameOrID);
    }

    public static void setPdfcConfiguration(Properties settings) {
        comparer.setProfile(settings);
    }

    public static void setServicePath(String servicePath) {
        comparer.setServicePath(servicePath);
    }

    @Deprecated
    public static void setLogLevel(int level) {
    }

    public static void setCredentials(String user, String password) {
        comparer.setCredentials(user, password);
    }

    private static void testEquality(String message, PdfData expected, PdfData actual, boolean expectEquality) {
        try {
            ResultCount result = comparer.compare(expected, actual, new ResultCount());
            int differences = result.getDifferenceCount();
            if (expectEquality) {
                PdfcAssertHTTP.assertEquals(message, 0L, differences);
            } else {
                PdfcAssertHTTP.assertNotEquals(message, 0L, differences);
            }
        }
        catch (ComparisonFailedException e) {
            switch (e.getErrorType()) {
                case missingFirstDocument: {
                    PdfcAssertHTTP.fail("The 'expected' file is not set.");
                    return;
                }
                case missingSecondDocument: {
                    PdfcAssertHTTP.fail("The 'actual' file is not set.");
                    return;
                }
                case serverError: {
                    PdfcAssertHTTP.fail("Request failed with HTTP " + e.getHttpErrorCode() + ":" + e.getResponse());
                    return;
                }
                case authenticationFailed: {
                    PdfcAssertHTTP.fail("Server authentication failed");
                    return;
                }
                case resultError: {
                    PdfcAssertHTTP.fail("Result from server is not a number: " + e.getResponse());
                }
            }
        }
    }

    private static void fail(String failMessage) {
        if (PdfcAssertHTTP.isJUnit4()) {
            PdfcAssertHTTP.fail4(failMessage);
        } else {
            PdfcAssertHTTP.fail5(failMessage);
        }
    }

    private static void fail4(String failMessage) {
        Assert.fail((String)failMessage);
    }

    private static void fail5(String failMessage) {
        Assertions.fail((String)failMessage);
    }

    private static void assertEquals(String failMessage, long expected, long actual) {
        if (PdfcAssertHTTP.isJUnit4()) {
            PdfcAssertHTTP.assertEquals4(failMessage, expected, actual);
        } else {
            PdfcAssertHTTP.assertEquals5(failMessage, expected, actual);
        }
    }

    private static void assertEquals4(String failMessage, long expected, long actual) {
        Assert.assertEquals((String)failMessage, (long)expected, (long)actual);
    }

    private static void assertEquals5(String failMessage, long expected, long actual) {
        Assertions.assertEquals((long)expected, (long)actual, (String)failMessage);
    }

    private static void assertNotEquals(String failMessage, long unexpected, long actual) {
        if (PdfcAssertHTTP.isJUnit4()) {
            PdfcAssertHTTP.assertNotEquals4(failMessage, unexpected, actual);
        } else {
            PdfcAssertHTTP.assertNotEquals5(failMessage, unexpected, actual);
        }
    }

    private static void assertNotEquals4(String failMessage, long unexpected, long actual) {
        Assert.assertNotEquals((String)failMessage, (long)unexpected, (long)actual);
    }

    private static void assertNotEquals5(String failMessage, long unexpected, long actual) {
        Assertions.assertNotEquals((long)unexpected, (long)actual, (String)failMessage);
    }

    private static boolean isJUnit4() {
        try {
            return PdfcAssertHTTP.class.getClassLoader().loadClass("org.junit.Assert") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void assertPdfEquals(File expected, File actual) {
        PdfcAssertHTTP.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, File expected, File actual) {
        PdfcAssertHTTP.testEquality(message, new PdfData(expected), new PdfData(actual), true);
    }

    public static void assertPdfEquals(String expected, String actual) {
        PdfcAssertHTTP.assertPdfEquals(null, expected, actual);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This is end user API. It will read a local file defined by the user of the programming API")
    public static void assertPdfEquals(String message, String expected, String actual) {
        PdfcAssertHTTP.assertPdfEquals(message, new File(expected), new File(actual));
    }

    public static void assertPdfEquals(Path expected, Path actual) {
        PdfcAssertHTTP.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, Path expected, Path actual) {
        PdfcAssertHTTP.assertPdfEquals(message, expected.toFile(), actual.toFile());
    }

    public static void assertPdfEquals(URL expected, URL actual) {
        PdfcAssertHTTP.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, InputStream expected, InputStream actual) {
        String baseName = PdfcAssertHTTP.getBaseName();
        PdfcAssertHTTP.testEquality(message, new PdfData(baseName + "expected", expected), new PdfData(baseName + "actual", actual), true);
    }

    private static String getBaseName() {
        StackTraceElement[] stack;
        for (StackTraceElement el : stack = new Exception().getStackTrace()) {
            String shortName;
            String className = el.getClassName();
            if (PdfcAssertHTTP.class.getName().equals(className)) continue;
            if (className.contains(".") && (shortName = className.substring(className.lastIndexOf(46))).length() > 3) {
                return shortName + "-";
            }
            return className + "-";
        }
        return "";
    }

    public static void assertPdfEquals(InputStream expected, InputStream actual) {
        PdfcAssertHTTP.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, URL expected, URL actual) {
        PdfcAssertHTTP.testEquality(message, new PdfData(expected), new PdfData(actual), true);
    }

    public static void assertPdfNotEquals(File expected, File actual) {
        PdfcAssertHTTP.assertPdfNotEquals(null, expected, actual);
    }

    public static void assertPdfNotEquals(String message, File expected, File actual) {
        PdfcAssertHTTP.testEquality(message, new PdfData(expected), new PdfData(actual), false);
    }

    public static void assertPdfNotEquals(String expected, String actual) {
        PdfcAssertHTTP.assertPdfNotEquals(null, expected, actual);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This is end user API. It will read a local file defined by the user of the programming API")
    public static void assertPdfNotEquals(String message, String expected, String actual) {
        PdfcAssertHTTP.assertPdfNotEquals(message, new File(expected), new File(actual));
    }

    public static void assertPdfNotEquals(Path expected, Path actual) {
        PdfcAssertHTTP.assertPdfNotEquals(expected.toFile(), actual.toFile());
    }

    public static void assertPdfNotEquals(String message, Path expected, Path actual) {
        PdfcAssertHTTP.assertPdfNotEquals(message, expected.toFile(), actual.toFile());
    }

    public static void assertPdfNotEquals(String message, InputStream expected, InputStream actual) {
        String baseName = PdfcAssertHTTP.getBaseName();
        PdfcAssertHTTP.testEquality(message, new PdfData(baseName + "expected", expected), new PdfData(baseName + "actual", actual), false);
    }
}

