/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.PartitionKey;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.error.PersistenceException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.azure.cosmos.AzureCosmosEventLogPersistence;
import com.inet.persistence.azure.cosmos.AzureCosmosLocks;
import com.inet.persistence.azure.cosmos.AzureCosmosPersistenceEntry;
import com.inet.persistence.azure.cosmos.AzureCosmosPublishSubscribe;
import com.inet.persistence.azure.cosmos.AzureCosmosSearchIndexPersistence;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.events.NodeCounter;
import com.inet.persistence.spi.events.PersistenceListenerContainer;
import com.inet.persistence.spi.searchlistener.SearchListenerManager;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class AzureCosmosPersistence
implements Persistence {
    private static CosmosClient client;
    private static CosmosDatabase database;
    private static CosmosContainer fs;
    private static CosmosAsyncDatabase asyncDatabase;
    private static CosmosAsyncContainer asyncFs;
    private static String CLIENT_ID;
    private static AzureCosmosPublishSubscribe pubsub;
    private static NodeCounter nodeCounter;
    private final PersistenceListenerContainer listeners = new PersistenceListenerContainer();
    private final AzureCosmosLocks locks = new AzureCosmosLocks();
    private static SearchListenerManager searchListenerManager;

    private static void cleanup() {
        if (client == null) {
            return;
        }
        if (pubsub != null) {
            pubsub.stop();
            pubsub = null;
        }
        if (nodeCounter != null) {
            nodeCounter.onShutdown();
            nodeCounter = null;
        }
        CosmosClient oldClient = client;
        ForkJoinPool.commonPool().execute(() -> {
            try {
                Thread.sleep(110L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            oldClient.close();
        });
        client = null;
    }

    AzureCosmosPersistence(String uri) {
        int logLevel = PersistenceLogger.LOGGER.getLogLevel();
        PersistenceLogger.LOGGER.setLogLevel(4);
        Logger cosmosDbLogger = LogManager.getLogger((String)"Cosmos DB");
        int cosmosDbLogLevel = cosmosDbLogger.getLogLevel();
        cosmosDbLogger.setLogLevel(4);
        try {
            String[] keyValues;
            AzureCosmosPersistence.cleanup();
            String databaseName = "inet";
            CosmosClientBuilder builder = new CosmosClientBuilder();
            boolean hasAccountKey = false;
            block15: for (String keyVal : keyValues = uri.split(";")) {
                int idx = keyVal.indexOf(61);
                if (idx <= 0) continue;
                String key = keyVal.substring(0, idx);
                String val = keyVal.substring(idx + 1);
                switch (key) {
                    case "AccountEndpoint": {
                        builder.endpoint(val);
                        continue block15;
                    }
                    case "AccountKey": {
                        builder.key(val);
                        hasAccountKey = true;
                        continue block15;
                    }
                    case "DatabaseName": {
                        databaseName = val;
                    }
                }
            }
            client = builder.buildClient();
            client.createDatabaseIfNotExists(databaseName);
            database = client.getDatabase(databaseName);
            fs = AzureCosmosPersistence.getOrCreateContainer(AzureCosmosPersistenceEntry.getCosmosContainerProperties());
            asyncFs = CosmosBridgeInternal.getCosmosAsyncContainer((CosmosContainer)fs);
            asyncDatabase = asyncFs.getDatabase();
            pubsub = new AzureCosmosPublishSubscribe(this.listeners);
            pubsub.start(CLIENT_ID);
            nodeCounter = new NodeCounter(this);
            this.registerListener(nodeCounter);
            searchListenerManager = new SearchListenerManager(this);
        }
        catch (CosmosException ex) {
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
        finally {
            PersistenceLogger.LOGGER.setLogLevel(logLevel);
            cosmosDbLogger.setLogLevel(cosmosDbLogLevel);
        }
    }

    static CosmosDatabase getDatabase() {
        return database;
    }

    static CosmosAsyncDatabase getAsyncDatabase() {
        return asyncDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static CosmosContainer getOrCreateContainer(CosmosContainerProperties containerProps) {
        String id = containerProps.getId();
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)("getOrCreateContainer" + id));){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                try {
                    database.createContainerIfNotExists(containerProps);
                    CosmosContainer cosmosContainer = database.getContainer(id);
                    return cosmosContainer;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (CosmosException ex) {
                        StringBuilder builder = new StringBuilder("\nContainer: ").append(id);
                        builder.append(" of ");
                        for (CosmosContainerProperties cont : database.readAllContainers()) {
                            builder.append(cont.getId()).append(',');
                        }
                        try {
                            database.createContainerIfNotExists(containerProps);
                            Iterator iterator = database.getContainer(id);
                            return iterator;
                        }
                        catch (CosmosException e) {
                            builder.append("\n(").append(ex.getStatusCode()).append(")");
                            throw AzureCosmosPersistence.userFriendlyException(ex, builder.toString());
                        }
                    }
                }
            }
        }
    }

    static <T> T readItem(CosmosContainer container, String itemId, Class<T> itemType) {
        try {
            return (T)container.readItem(itemId, new PartitionKey((Object)itemId), itemType).getItem();
        }
        catch (CosmosException ex) {
            if (ex.getStatusCode() == 404) {
                return null;
            }
            throw AzureCosmosPersistence.userFriendlyException(ex);
        }
    }

    @Nonnull
    static CosmosContainer getFileSystem() {
        return fs;
    }

    @Nonnull
    static CosmosAsyncContainer getAsyncFileSystem() {
        return asyncFs;
    }

    static PersistenceException userFriendlyException(CosmosException ex) {
        return AzureCosmosPersistence.userFriendlyException(ex, null);
    }

    static PersistenceException userFriendlyException(CosmosException ex, @Nullable String details) {
        Object msg = "";
        try {
            HashMap map;
            Object obj;
            msg = BridgeInternal.getInnerErrorMessage((CosmosException)ex);
            int idx = ((String)msg).indexOf("{\"Errors\"");
            if (idx > 0 && (obj = (map = (HashMap)new Json().fromJson(((String)msg).substring(idx), HashMap.class)).get("Errors")) instanceof List) {
                msg = (String)((List)obj).get(0);
            }
            msg = (String)msg + "\n(" + ex.getStatusCode() + ")";
        }
        catch (Throwable idx) {
            // empty catch block
        }
        try {
            HashMap map = (HashMap)new Json().fromJson(ex.getDiagnostics().toString(), HashMap.class);
            List responseStatisticsList = (List)map.get("responseStatisticsList");
            if (responseStatisticsList != null && responseStatisticsList.size() > 0) {
                String exception;
                map = (HashMap)responseStatisticsList.get(0);
                if ((map = (HashMap)map.get("storeResult")) != null && (exception = (String)map.get("exception")) != null && !((String)msg).contains(exception)) {
                    msg = (String)msg + "\n" + exception;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (StringFunctions.isEmpty((String)msg)) {
            msg = ex.getMessage();
        }
        PersistenceLogger.LOGGER.debug((Object)ex);
        if (details != null) {
            msg = (String)msg + details;
        }
        return new PersistenceException((String)msg, (Throwable)ex);
    }

    static String escapeLikePattern(String value) {
        StringBuilder builder = null;
        int length = value.length();
        int idx = 0;
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '%': 
                case '[': 
                case '_': {
                    if (builder == null) {
                        builder = new StringBuilder(length);
                    }
                    builder.append(value, idx, i).append('[').append(ch).append(']');
                    idx = i + 1;
                }
            }
        }
        if (builder != null) {
            builder.append(value, idx, length);
            return builder.toString();
        }
        return value;
    }

    static SearchListenerManager getSearchListenerManager() {
        return searchListenerManager;
    }

    @Nonnull
    public PersistenceEntry resolve(@Nonnull String path) throws NullPointerException, IllegalArgumentException {
        return new AzureCosmosPersistenceEntry(path);
    }

    @Nonnull
    public EventLogPersistence getEventLogPersistence(String name) {
        return new AzureCosmosEventLogPersistence(name);
    }

    public <T> void registerListener(@Nonnull PersistenceListener<T> listener) {
        this.listeners.addListener(listener);
    }

    public <T> void sendEvent(@Nonnull T event) {
        AzureCosmosPublishSubscribe pubsub = AzureCosmosPersistence.pubsub;
        if (pubsub != null) {
            pubsub.send(event, CLIENT_ID);
        }
    }

    public int getNodeCount() {
        return nodeCounter.getNodeCount();
    }

    public void registerNodeListener(@Nonnull PersistenceListener<Boolean> listener) {
        nodeCounter.addListener(listener);
    }

    public <ID> SearchIndexPersistence<ID> getSearchIndexPersistence(@Nonnull String name) {
        return new AzureCosmosSearchIndexPersistence(name);
    }

    public ServerLock tryLock(@Nonnull String key) {
        return this.locks.tryLock(key);
    }

    public ServerLock tryReadLock(@Nonnull String key) {
        return this.locks.tryReadWriteLock(key, false);
    }

    public ServerLock tryWriteLock(@Nonnull String key) {
        return this.locks.tryReadWriteLock(key, true);
    }

    @Nonnull
    public ServerLock getReadLock(@Nonnull String key, long timeout) {
        return this.locks.getReadWriteLock(key, false, timeout);
    }

    @Nonnull
    public ServerLock getWriteLock(@Nonnull String key, long timeout) {
        return this.locks.getReadWriteLock(key, true, timeout);
    }

    static {
        CLIENT_ID = GUID.generateNew().toString();
        ShutdownManager.add((ShutdownFinalizer)new ShutdownFinalizer(){

            public void onShutdown() {
                AzureCosmosPersistence.cleanup();
            }

            public int order() {
                return 1000001;
            }
        });
    }
}

