/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit;

import com.inet.pdfc.junit.ComparisonFailedException;
import com.inet.pdfc.junit.PDFComparer;
import com.inet.pdfc.junit.Result;
import com.inet.pdfc.junit.impl.ByteBufferInputStream;
import com.inet.pdfc.junit.impl.SupplierWithIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResultLog
extends Result {
    private FORMAT format = FORMAT.text;
    private String log;
    @Nonnull
    private @Nonnull SupplierWithIOException<@Nonnull OutputStream> streamProvider;

    public ResultLog(@Nullable SupplierWithIOException<@Nonnull OutputStream> streamProvider) {
        this.streamProvider = streamProvider;
    }

    public ResultLog() {
    }

    public void setFormat(FORMAT format) {
        this.format = format;
    }

    @Override
    void setRequestParameters(@Nonnull Map<PDFComparer.Part, HttpRequest.BodyPublisher> parameters) {
        parameters.put(new PDFComparer.Part("result"), HttpRequest.BodyPublishers.ofString("log"));
        parameters.put(new PDFComparer.Part("format"), HttpRequest.BodyPublishers.ofString(this.format == FORMAT.text ? "html" : "json"));
    }

    @Override
    void handleRequest(@Nonnull InputStream stream) throws IOException, InterruptedException, ComparisonFailedException {
        if (this.streamProvider != null) {
            try (OutputStream out = this.streamProvider.get();){
                ByteBufferInputStream.copyData(stream, out);
            }
        } else {
            this.log = ByteBufferInputStream.readString(stream, StandardCharsets.UTF_8);
        }
    }

    @Nullable
    public String getLog() {
        return this.log;
    }

    public static enum FORMAT {
        json,
        text;

    }
}

