/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.id.GUID;
import com.inet.persistence.dynamodb.DynamoDbPersistence;
import com.inet.persistence.dynamodb.DynamoDbUtils;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.util.BaseLocks;
import com.inet.thread.CountedReadWriteLock;
import com.inet.thread.ServerLock;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.util.HashMap;
import javax.annotation.Nonnull;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;

class DynamoDbLocks
extends BaseLocks {
    private static final String TABLE_NAME = "locks";
    @Nonnull
    private static String tableName = "locks";
    private static final String LOCKKEY = "lockkey";
    private static final String LOCKVAL = "lockval";
    private static final String DATE = "lockdate";
    private static final int MINUTES_5 = 3005000;
    private HashMap<CountedReadWriteLock, DatabaseTimerLock> locks = new HashMap();

    DynamoDbLocks() {
    }

    static void createTable(DynamoDbClient client) {
        try {
            tableName = DynamoDbPersistence.getTablePrefix() + TABLE_NAME;
            AttributeDefinition[] attrs = new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(LOCKKEY).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(LOCKVAL).attributeType(ScalarAttributeType.S).build()};
            KeySchemaElement key = (KeySchemaElement)KeySchemaElement.builder().attributeName(LOCKKEY).keyType(KeyType.HASH).build();
            KeySchemaElement lock = (KeySchemaElement)KeySchemaElement.builder().attributeName(LOCKVAL).keyType(KeyType.RANGE).build();
            CreateTableRequest tableRequest = (CreateTableRequest)CreateTableRequest.builder().attributeDefinitions(attrs).keySchema(new KeySchemaElement[]{key, lock}).billingMode(BillingMode.PAY_PER_REQUEST).tableName(tableName).build();
            client.createTable(tableRequest);
            DynamoDbWaiter dbWaiter = client.waiter();
            dbWaiter.waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build());
            TimeToLiveSpecification timeSpec = (TimeToLiveSpecification)TimeToLiveSpecification.builder().enabled(Boolean.valueOf(true)).attributeName(DATE).build();
            UpdateTimeToLiveRequest timeToLiveRequest = (UpdateTimeToLiveRequest)UpdateTimeToLiveRequest.builder().tableName(tableName).timeToLiveSpecification(timeSpec).build();
            client.updateTimeToLive(timeToLiveRequest);
            PersistenceLogger.LOGGER.debug((Object)("Table '" + tableName + "' created"));
        }
        catch (ResourceInUseException ex) {
            PersistenceLogger.LOGGER.debug((Object)("Table '" + tableName + "' already exists"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerLock tryLock(@Nonnull String key) {
        CountedReadWriteLock readWriteLock = CountedReadWriteLock.tryReadWriteLockInstance((Object)key, (boolean)true);
        if (readWriteLock != null) {
            DatabaseTimerLock databaseLock;
            HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = this.locks;
            synchronized (hashMap) {
                databaseLock = this.tryGetDatabaseTimerLock(key, " ", readWriteLock);
            }
            if (databaseLock != null) {
                return () -> {
                    if (readWriteLock.unlock(true)) {
                        databaseLock.unlock();
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ServerLock tryReadWriteLock(@Nonnull String key, @Nonnull CountedReadWriteLock readWriteLock, boolean writeLock) {
        DatabaseTimerLock databaseLock;
        HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = this.locks;
        synchronized (hashMap) {
            databaseLock = this.locks.get(readWriteLock);
            if (databaseLock == null) {
                try (ServerLock totalLock = this.repeatTryLock("total:" + key);){
                    String lockval;
                    Object filter;
                    if (totalLock == null) {
                        ServerLock serverLock = null;
                        return serverLock;
                    }
                    HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>();
                    queryParams.put(":key", AttributeValue.fromS((String)key));
                    if (writeLock) {
                        filter = "lockkey=:key";
                        lockval = "write";
                    } else {
                        queryParams.put(":lock", AttributeValue.fromS((String)"write"));
                        filter = "lockkey=:key AND lockval=:lock";
                        lockval = GUID.generateNew().toString();
                    }
                    queryParams.put(":ttl", AttributeValue.fromN((String)String.valueOf(System.currentTimeMillis() / 1000L)));
                    filter = (String)filter + " AND lockdate>:ttl";
                    ScanRequest request = (ScanRequest)ScanRequest.builder().tableName(tableName).filterExpression((String)filter).expressionAttributeValues(queryParams).select(Select.COUNT).build();
                    int count = DynamoDbPersistence.getClient().scan(request).count();
                    if (count == 0) {
                        databaseLock = this.tryGetDatabaseTimerLock(key, lockval, readWriteLock);
                    }
                }
            }
        }
        if (databaseLock != null) {
            DatabaseTimerLock dbLock = databaseLock;
            return () -> {
                if (readWriteLock.unlock(writeLock)) {
                    dbLock.unlock();
                }
            };
        }
        readWriteLock.unlock(writeLock);
        return null;
    }

    private ServerLock repeatTryLock(@Nonnull String key) {
        for (int i = 0; i < 100; ++i) {
            ServerLock totalLock = this.tryLock(key);
            if (totalLock != null) {
                return totalLock;
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return null;
    }

    private DatabaseTimerLock tryGetDatabaseTimerLock(String key, String lockval, CountedReadWriteLock lock) {
        try {
            DatabaseTimerLock databaseLock = this.locks.get(lock);
            if (databaseLock == null) {
                databaseLock = new DatabaseTimerLock(key, lockval, lock);
                this.locks.put(lock, databaseLock);
            }
            return databaseLock;
        }
        catch (Exception e) {
            return null;
        }
    }

    private class DatabaseTimerLock {
        private final String key;
        private final String lockval;
        private final CountedReadWriteLock lock;
        private DefaultTimerTask timer = new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                long ttlSeconds = System.currentTimeMillis() / 1000L + 3005000L;
                HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
                item.put(DynamoDbLocks.LOCKKEY, AttributeValue.fromS((String)DatabaseTimerLock.this.key));
                item.put(DynamoDbLocks.LOCKVAL, AttributeValue.fromS((String)DatabaseTimerLock.this.lockval));
                item.put(DynamoDbLocks.DATE, AttributeValue.fromN((String)String.valueOf(ttlSeconds)));
                DynamoDbUtils.putItem(tableName, item);
            }
        };

        private DatabaseTimerLock(String key, String lockval, CountedReadWriteLock lock) throws Exception {
            this.key = key;
            this.lockval = lockval;
            this.lock = lock;
            long currentTimeSeconds = System.currentTimeMillis() / 1000L;
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            item.put(DynamoDbLocks.LOCKKEY, AttributeValue.fromS((String)key));
            item.put(DynamoDbLocks.LOCKVAL, AttributeValue.fromS((String)lockval));
            item.put(DynamoDbLocks.DATE, AttributeValue.fromN((String)String.valueOf(currentTimeSeconds + 3005000L)));
            HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>();
            queryParams.put(":ttl", AttributeValue.fromN((String)String.valueOf(currentTimeSeconds)));
            PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(tableName).item(item).conditionExpression("attribute_not_exists(lockdate) OR lockdate<:ttl").expressionAttributeValues(queryParams).build();
            DynamoDbPersistence.getClient().putItem(request);
            DefaultTimer.getInstance().scheduleAtFixedRate(this.timer, 60000L, 60000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock() {
            this.timer.cancel();
            HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
            item.put(DynamoDbLocks.LOCKKEY, AttributeValue.fromS((String)this.key));
            item.put(DynamoDbLocks.LOCKVAL, AttributeValue.fromS((String)this.lockval));
            DynamoDbUtils.deleteItem(tableName, item);
            HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = DynamoDbLocks.this.locks;
            synchronized (hashMap) {
                DynamoDbLocks.this.locks.remove(this.lock);
            }
        }
    }
}

