/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.ui.fields.values.MemberEntry;
import com.inet.usersandgroups.api.ui.fields.values.MembershipFieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MembersGroupFieldDefinition
extends GroupFieldDefinition<List<MemberEntry>> {
    private GroupType a;
    private boolean b;

    public MembersGroupFieldDefinition(String groupKey, GroupType groupType, String fieldKey, int prio) {
        super(groupKey, fieldKey + "_" + groupKey, "fieldtype_members", prio);
        this.a = groupType;
    }

    public MembersGroupFieldDefinition(String groupKey, GroupType groupType, String fieldKey, int prio, boolean onlyShowMembers) {
        super(groupKey, fieldKey + "_" + groupKey, "fieldtype_members", prio);
        this.a = groupType;
        this.b = onlyShowMembers;
    }

    public void setOnlyShowMembers(boolean onlyShowMembers) {
        this.b = onlyShowMembers;
    }

    @Override
    public MembershipFieldValue getFieldValue(UserGroupInfo groupInfo) {
        Object object;
        ArrayList<MemberEntry> arrayList = new ArrayList<MemberEntry>();
        ArrayList<MemberEntry> arrayList2 = null;
        boolean bl = false;
        if (groupInfo != null) {
            arrayList = this.a(groupInfo);
            if (groupInfo.getParentID() != null) {
                object = ServerPluginManager.getInstance();
                for (GroupTypeDef groupTypeDef : ((ServerPluginManager)object).get(GroupTypeDef.class)) {
                    UserGroupInfo userGroupInfo;
                    if (!this.a.equals(groupTypeDef.getGroupType()) || !(bl = groupTypeDef.inheritsMembershipsFromParent()) || (userGroupInfo = UserGroupManager.getRecoveryEnabledInstance().getGroup(groupInfo.getParentID())) == null) continue;
                    arrayList2 = this.a(userGroupInfo);
                }
            }
        }
        object = new MembershipFieldValue(arrayList, "activeuseronly", Arrays.asList(this.a.getName()), bl, false, arrayList2);
        ((FieldValue)object).setVisibleInPreview(!arrayList.isEmpty() || bl);
        ((MembershipFieldValue)object).setOnlyShowMembers(this.b);
        return object;
    }

    private ArrayList<MemberEntry> a(UserGroupInfo userGroupInfo) {
        ArrayList<MemberEntry> arrayList = new ArrayList<MemberEntry>();
        Set<GUID> set = userGroupInfo.getMemberIDs();
        for (GUID gUID : set) {
            UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(gUID);
            if (userAccount == null) continue;
            Set<MembershipType> set2 = userGroupInfo.getMembershipTypes(gUID);
            if (set2 == null || set2.isEmpty()) {
                arrayList.add(MemberEntry.ofGroupMember(userAccount, this.a));
                continue;
            }
            set2.stream().forEach(membershipType -> arrayList.add(MemberEntry.ofGroupMember(userAccount, this.a, membershipType)));
        }
        return arrayList;
    }

    @Override
    public List<MemberEntry> convertFromString(String value) {
        return (List)new Json().fromJson(value, (Type)new JsonParameterizedType((Type)((Object)ArrayList.class), new Type[]{MemberEntry.class}));
    }

    @Override
    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        Collection<MembershipType> collection;
        List list = (List)value;
        HashMap hashMap = new HashMap();
        HashMap<String, MembershipType> hashMap2 = new HashMap<String, MembershipType>();
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        for (GroupTypeDef object : serverPluginManager.get(GroupTypeDef.class)) {
            if (!this.a.equals(object.getGroupType())) continue;
            collection = object.getMembershipTypes();
            if (collection == null) break;
            for (MembershipType membershipType : collection) {
                hashMap2.put(membershipType.getKey(), membershipType);
            }
        }
        for (String string : hashMap2.keySet()) {
            hashMap.put(string, new ArrayList());
        }
        if (hashMap2.isEmpty()) {
            hashMap.put("", new ArrayList());
        }
        for (MemberEntry memberEntry : list) {
            collection = (ArrayList)hashMap.get(memberEntry.getMembershipType());
            ((ArrayList)collection).add((MembershipType)((Object)memberEntry.getGuid()));
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            this.a(userGroup, userGroupUpdateData, (ArrayList)hashMap.get(entry.getKey()), (MembershipType)entry.getValue());
        }
        if (hashMap2.isEmpty()) {
            this.a(userGroup, userGroupUpdateData, (ArrayList)hashMap.get(""), null);
        }
    }

    private void a(UserGroupInfo userGroupInfo, UserGroupUpdateData userGroupUpdateData, ArrayList<GUID> arrayList, MembershipType membershipType) {
        Set<MembershipType> set;
        Map<GUID, Set<MembershipType>> map = userGroupUpdateData.getMembersToAdd();
        Map<GUID, Set<MembershipType>> map2 = userGroupUpdateData.getMembersToRemove();
        Set<Object> set2 = Collections.emptySet();
        if (userGroupInfo != null) {
            Set<GUID> set3 = set2 = membershipType != null ? userGroupInfo.getMemberIDs(membershipType) : userGroupInfo.getMemberIDs();
        }
        if (arrayList != null) {
            for (GUID gUID : arrayList) {
                if (set2.contains(gUID)) continue;
                set = map.get(gUID);
                if (set == null) {
                    set = new HashSet<MembershipType>();
                    map.put(gUID, set);
                }
                if (membershipType == null) continue;
                set.add(membershipType);
            }
        }
        for (GUID gUID : set2) {
            if (arrayList != null && arrayList.contains(gUID)) continue;
            set = map2.get(gUID);
            if (set == null) {
                set = new HashSet<MembershipType>();
                map2.put(gUID, set);
            }
            if (membershipType == null) continue;
            set.add(membershipType);
        }
    }

    @Override
    public String getLabel() {
        return null;
    }
}

