/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin;

import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginListener;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.base.TempAccountCleaner;
import com.inet.authentication.base.TempAuthenticationProvider;
import com.inet.authentication.stayloggedin.FieldStayLoggedIn;
import com.inet.authentication.stayloggedin.StayLoggedInTakeoutDataProvider;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigurationManager;
import com.inet.config.internal.LicenseCallbackPluginServlet;
import com.inet.config.migrator.AuthenticationConfigurationMigrator;
import com.inet.config.recovery.RecoveryLauncher;
import com.inet.http.PluginServlet;
import com.inet.http.error.JsonErrorHandlerProvider;
import com.inet.http.error.ServletErrorHandlerProvider;
import com.inet.http.websocket.WebSocketServlet;
import com.inet.id.GUID;
import com.inet.logging.SecurityEventLog;
import com.inet.notification.NotificationGroup;
import com.inet.notification.SystemNotificationGroup;
import com.inet.permissions.AnonymousAuthenticationProvider;
import com.inet.permissions.Permission;
import com.inet.permissions.PermissionCategory;
import com.inet.persistence.crypto.CryptoAlgorithmFactory;
import com.inet.persistence.crypto.aes.AESAlgorithmFactory;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.InetApplicationDescription;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.image.UserAvatar;
import com.inet.plugin.veto.VetoPower;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.takeout.BooleanTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.CurrencyTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.DateTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.DateTimeTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.DoubleTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.EmptyTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.IntegerTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.LinkTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.LoginTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.MultilineTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.SelectTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.StringListTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.StringTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.TakeoutDataProvider;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.TimeRangeTakeoutDataRenderer;
import com.inet.usersandgroups.api.takeout.TimeTakeoutDataRenderer;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.GrantFirstUserAllPermissionsListener;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpSessionListener;
import javax.annotation.Nonnull;

@PluginInfo(group="system", id="inetcore", version="25.10.219", flags="core;designer")
public class InetcoreServerPlugin
implements CoreServerPlugin,
ServerPlugin {
    public static final String PLUGIN_ID = "inetcore";
    private static final String CATEGORY_ADMINISTRATION = "administration";

    @Override
    public void registerExtension(ServerPluginManager spm) {
        Permission.createCategory(CATEGORY_ADMINISTRATION, 6000, "com.inet.permissions.i18n.Translations", PermissionCategory.class);
        UsersAndGroups.getFieldsForRegistration().forEach(userField -> spm.register(UserField.class, userField));
        UsersAndGroups.getGroupTypeDefinitionsForRegistration().forEach(groupTypeDef -> spm.register(GroupTypeDef.class, groupTypeDef));
        UsersAndGroups.getPredefinedUserGroupsForRegistration().forEach(predefinedUserGroup -> spm.register(PredefinedUserGroup.class, predefinedUserGroup));
        spm.register(VetoPower.class, UserManager.getVetoPower());
        spm.register(VetoPower.class, UserGroupManager.getVetoPower());
        spm.register(LoginListener.class, new a());
        spm.register(UserEventListener.class, new UserEventAdapter(){

            @Override
            public void userAccountBeforeDeleted(UserAccount userAccount) {
                UserGroupManager.getInstance().removeUserFromAllGroups(userAccount.getID());
            }
        });
        if (!ConfigurationManager.isRecoveryMode()) {
            spm.register(UserEventListener.class, new GrantFirstUserAllPermissionsListener());
        }
        spm.register(TakeoutDataRenderer.class, new EmptyTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new StringTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new LoginTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new SelectTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new StringListTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new CurrencyTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new MultilineTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new DoubleTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new IntegerTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new DateTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new LinkTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new BooleanTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new TimeTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new DateTimeTakeoutDataRenderer());
        spm.register(TakeoutDataRenderer.class, new TimeRangeTakeoutDataRenderer());
        spm.register(NotificationGroup.class, new SystemNotificationGroup());
        if (ServerPluginManager.IS_SERVLET_API) {
            InetcoreServerPlugin.a(spm);
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        configurationManager.addConfigurationMigrator(new AuthenticationConfigurationMigrator());
        spm.register(UserField.class, FieldStayLoggedIn.INSTANCE);
        spm.register(TakeoutDataProvider.class, new StayLoggedInTakeoutDataProvider());
        spm.register(CryptoAlgorithmFactory.class, new AESAlgorithmFactory());
        spm.register(UserField.class, UserAvatar.FIELD_AVATAR_PROVIDER);
        spm.register(UserField.class, UserAvatar.FIELD_AVATAR_METADATA);
    }

    private static void a(ServerPluginManager serverPluginManager) {
        serverPluginManager.register(AuthenticationProvider.class, new AnonymousAuthenticationProvider());
        serverPluginManager.register(AuthenticationProvider.class, new TempAuthenticationProvider());
        serverPluginManager.register(ServletErrorHandlerProvider.class, new JsonErrorHandlerProvider());
        serverPluginManager.register(PluginServlet.class, new LicenseCallbackPluginServlet());
        WebSocketServlet.INSTANCE.register(serverPluginManager);
        TempAccountCleaner tempAccountCleaner = new TempAccountCleaner();
        serverPluginManager.register(HttpSessionListener.class, tempAccountCleaner);
        serverPluginManager.register(ServerPluginManagerListener.class, tempAccountCleaner);
        serverPluginManager.register(LoginListener.class, tempAccountCleaner);
    }

    @Override
    public void init(ServerPluginManager spm) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void restart() {
    }

    @Override
    public RecoveryLauncher getRecoveryLauncher() {
        return new RecoveryLauncher();
    }

    @Override
    public ApplicationDescription getApplicationDescription() {
        return new InetApplicationDescription();
    }

    private static class a
    implements LoginListener {
        private GUID a;
        private long b;
        private final MemoryStoreMap<String, Long> c = new MemoryStoreMap(1800, false);

        private a() {
        }

        @Override
        public void userLoggedIn(@Nonnull UserAccount userAccount, @Nonnull LoginProcessor login) {
            Comparable<GUID> comparable;
            UserManager userManager = UserManager.getInstance();
            if (userManager instanceof LoginListener) {
                ((LoginListener)((Object)userManager)).userLoggedIn(userAccount, login);
            }
            if (ServerPluginManager.IS_SERVLET_API && LoginManager.isTokenLoginSource(login.getLoginSource()) && (comparable = this.c.put(login.getLoginID(), System.currentTimeMillis())) != null) {
                return;
            }
            comparable = userAccount.getID();
            if (comparable.equals(this.a)) {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - this.b;
                this.b = l2;
                if (l3 < 2000L) {
                    return;
                }
            } else {
                this.a = comparable;
            }
            (login instanceof BaseUserManager.NonSessionLoginProcessor ? SecurityEventLog.AutoLogin : SecurityEventLog.UserLogin).log(new Object[0]);
        }
    }
}

