/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions.url;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.BaseErrorCode;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import java.io.File;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class URLPermissionChecker {
    private static List<@Nonnull PluginPermissionChecker> a = ServerPluginManager.getInstance().get(PluginPermissionChecker.class);
    private static HashSet<String> b;
    private static final ConfigValue<Boolean> c;
    private static final ConfigValue<Boolean> d;
    private static final ConfigValue<Boolean> e;
    private static final ConfigValue<Boolean> f;
    private static final ConfigValue<String[]> g;
    private static final I18nMessages h;

    private static void a() {
        if (b == null) {
            try {
                InetAddress[] inetAddressArray;
                b = new HashSet();
                b.add("localhost");
                b.add("127.0.0.1");
                b.add("127.0.1.1");
                b.add("0:0:0:0:0:0:0:1");
                b.add("[0:0:0:0:0:0:0:1]");
                String string = NetworkFunctions.getLocalHostName();
                b.add(string.toLowerCase());
                for (InetAddress inetAddress : inetAddressArray = InetAddress.getAllByName(string)) {
                    String string2 = inetAddress.getHostAddress().toLowerCase();
                    b.add(string2);
                    if (inetAddress instanceof Inet6Address) {
                        int n2 = string2.lastIndexOf("%");
                        if (n2 > 0) {
                            string2 = string2.substring(0, n2);
                        }
                        b.add(string2);
                        b.add("[" + string2 + "]");
                    }
                    b.add(inetAddress.getHostName().toLowerCase());
                }
            }
            catch (Exception exception) {
                LogManager.getApplicationLogger().error(exception);
            }
        }
    }

    public static URL checkReportLocation(@Nonnull String reportUrl) throws IllegalArgumentException, AccessDeniedException {
        URL uRL = IOFunctions.getURLFromString(reportUrl);
        if (StringFunctions.isEmpty(reportUrl) || uRL == null) {
            throw new IllegalArgumentException(h.getMsg("urlInvalid", reportUrl));
        }
        URLPermissionChecker.checkReportLocation(uRL);
        return uRL;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "PATH_TRAVERSAL_IN"}, justification="This is the security check")
    public static void checkReportLocation(@Nonnull URL url) throws AccessDeniedException {
        String[] stringArray;
        boolean bl;
        if (!c.get().booleanValue()) {
            return;
        }
        for (PluginPermissionChecker object2 : a) {
            if (!object2.checkReportLocation(url)) continue;
            return;
        }
        URLPermissionChecker.a();
        Object object = url.getProtocol();
        if ("jar".equals(object)) {
            try {
                URLConnection throwable = url.openConnection();
                url = ((JarURLConnection)throwable).getJarFileURL();
                object = url.getProtocol();
            }
            catch (Throwable bl2) {
                LogManager.getApplicationLogger().error(bl2.getMessage() + "- while checking Report Location of " + String.valueOf(url), bl2);
            }
        }
        boolean bl3 = bl = ((String)object).equals("file") || ((String)object).equals("persistence");
        if (d.get().booleanValue() && bl) {
            return;
        }
        if (e.get().booleanValue() && ((String)object).equals("jndi")) {
            return;
        }
        boolean bl4 = false;
        bl4 = f.get();
        if (bl4 && URLPermissionChecker.isLocalHost((String)(stringArray = url.getHost()))) {
            return;
        }
        stringArray = g.get();
        if (stringArray.length > 0) {
            Object object2;
            int n2;
            String string = url.toString();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                try {
                    object2 = stringArray[n2];
                    if (bl && ((String)object2).startsWith("file:")) {
                        File file;
                        File file2 = new File(url.getFile());
                        if (!URLPermissionChecker.a(file2, file = new File(((String)object2).substring(5)))) continue;
                        return;
                    }
                    if (string.equals(object2)) {
                        return;
                    }
                    if (((String)object2).endsWith(":") && string.startsWith((String)object2)) {
                        return;
                    }
                    if (!string.startsWith((String)(((String)object2).endsWith("/") ? object2 : (String)object2 + "/"))) continue;
                    return;
                }
                catch (IOException iOException) {
                    LogManager.getApplicationLogger().error(iOException);
                }
            }
            if (url.getUserInfo() != null) {
                try {
                    n2 = string.indexOf(url.getUserInfo());
                    object2 = new URL(string.substring(0, n2) + string.substring(n2 + url.getUserInfo().length() + 1));
                    URLPermissionChecker.checkReportLocation((URL)object2);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    LogManager.getApplicationLogger().error(malformedURLException);
                }
            }
        }
        if (LogManager.getApplicationLogger().isDebug()) {
            LogManager.getApplicationLogger().debug("Report location invalid!");
        }
        throw new AccessDeniedException(BaseErrorCode.IllegalPath, url);
    }

    static boolean a(File file, File file2) throws IOException {
        String string = file.getCanonicalPath();
        Object object = file2.getCanonicalPath();
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        return string.startsWith((String)object);
    }

    public static boolean isLocalHost(String host) {
        URLPermissionChecker.a();
        host = host.toLowerCase();
        return !StringFunctions.isEmpty(host) && b.contains(host);
    }

    static {
        c = new ConfigValue(ConfigKey.REPOSITORY_ENABLED);
        d = new ConfigValue(ConfigKey.FILELOCATION_ENABLED);
        e = new ConfigValue(ConfigKey.JNDILOCATION_ENABLED);
        f = new ConfigValue(ConfigKey.LOCALHOST_ENABLED);
        g = new ConfigValue<String[]>(ConfigKey.REPOSITORY){

            @Override
            protected String[] convert(@Nonnull String strValue) throws IllegalArgumentException {
                if (strValue.length() > 0) {
                    return strValue.split("[;,]");
                }
                return new String[0];
            }
        };
        h = new I18nMessages("com.inet.permissions.i18n.URLPermissionChecker", URLPermissionChecker.class);
    }
}

