/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions.url;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.permissions.url.EntryList;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Iterator;
import java.util.Set;

@InternalApi
public class PermissionUrlObject {
    static final int ENTRY_TYPE_ROLE = 1;
    static final int ENTRY_TYPE_USER = 2;
    private EntryList a = new EntryList();

    public void addRolePermission(GUID roleId, int permissionType) {
        this.a(1, roleId, permissionType);
    }

    public void addUserPermission(GUID userId, int permissionType) {
        this.a(2, userId, permissionType);
    }

    void a(int n2, GUID gUID, int n3) {
        if (n2 == 2) {
            this.getPermissions().addUserPermission(gUID, n3);
        } else if (n2 == 1) {
            this.getPermissions().addGroupPermission(gUID, n3);
        }
    }

    public void removeRolePermission(GUID roleId, int permissionType) {
        this.b(1, roleId, permissionType);
    }

    public void removeUserPermission(GUID userId, int permissionType) {
        this.b(2, userId, permissionType);
    }

    void b(int n2, GUID gUID, int n3) {
        if (n2 == 2) {
            this.getPermissions().removeUserPermission(gUID, n3);
        } else if (n2 == 1) {
            this.getPermissions().removeGroupPermission(gUID, n3);
        }
    }

    public String toString() {
        GUID gUID;
        Object object = new String();
        Iterator<GUID> iterator = this.getPermissions().getUserIds().iterator();
        while (iterator.hasNext()) {
            object = (String)object + "   <type=user ";
            gUID = iterator.next();
            object = (String)object + "id=" + String.valueOf(gUID) + " ";
            object = (String)object + "permission=" + this.getPermissions().getUserPermission(gUID) + ">\n";
        }
        iterator = this.getPermissions().getGroupIds().iterator();
        while (iterator.hasNext()) {
            object = (String)object + "   <type=role ";
            gUID = iterator.next();
            object = (String)object + "id=" + String.valueOf(gUID) + " ";
            object = (String)object + "permission=" + this.getPermissions().getGroupPermission(gUID) + ">\n";
        }
        return object;
    }

    public int getUserPermission(GUID userId) {
        return this.getPermissions().getUserPermission(userId);
    }

    public int getRolePermission(GUID roleId) {
        return this.getPermissions().getGroupPermission(roleId);
    }

    public GUID[] getRoleIds() {
        Set<GUID> set = this.getPermissions().getGroupIds();
        return set.toArray(new GUID[0]);
    }

    public GUID[] getUserIds() {
        Set<GUID> set = this.getPermissions().getUserIds();
        return set.toArray(new GUID[0]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PermissionUrlObject) {
            GUID[] gUIDArray;
            GUID[] gUIDArray2;
            PermissionUrlObject permissionUrlObject = (PermissionUrlObject)obj;
            GUID[] gUIDArray3 = permissionUrlObject.getUserIds();
            if (gUIDArray3.length != (gUIDArray2 = this.getUserIds()).length) {
                return false;
            }
            EntryList entryList = this.getPermissions();
            for (int i2 = 0; i2 < gUIDArray2.length; ++i2) {
                if (!entryList.a.containsKey(gUIDArray2[i2])) {
                    return false;
                }
                if (this.getUserPermission(gUIDArray2[i2]) == permissionUrlObject.getUserPermission(gUIDArray2[i2])) continue;
                return false;
            }
            GUID[] gUIDArray4 = permissionUrlObject.getRoleIds();
            if (gUIDArray4.length != (gUIDArray = this.getRoleIds()).length) {
                return false;
            }
            for (int i3 = 0; i3 < gUIDArray.length; ++i3) {
                if (!entryList.b.containsKey(gUIDArray[i3])) {
                    return false;
                }
                if (this.getRolePermission(gUIDArray[i3]) == permissionUrlObject.getRolePermission(gUIDArray[i3])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean checkAccess(int rightsToCheck) {
        int n2 = this.getAccess();
        return (n2 & rightsToCheck) == rightsToCheck;
    }

    public int getAccess() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            return 0;
        }
        if (userAccount.getAccountType() == UserAccountType.Administrator) {
            return 7;
        }
        int n2 = 0;
        GUID[] gUIDArray = this.getRoleIds();
        if (gUIDArray != null) {
            n2 |= this.getRolePermission(UsersAndGroups.GROUPID_ALLUSERS);
        }
        if (n2 == 7) {
            return n2;
        }
        GUID gUID = userAccount.getID();
        n2 |= this.getUserPermission(gUID);
        Set<UserGroupInfo> set = UserGroupManager.getInstance().getGroupsForUser(gUID);
        for (UserGroupInfo userGroupInfo : set) {
            n2 |= this.getRolePermission(userGroupInfo.getID());
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.getPermissions().getEntriesCount() == 0;
    }

    public EntryList getPermissions() {
        return this.a;
    }

    public void setPermissions(EntryList permissions) {
        this.a = permissions;
    }
}

