/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.utils;

import com.inet.http.servlet.SessionStore;
import com.inet.http.utils.Browser;
import com.inet.lib.core.OS;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserAgent {
    public final OS os;
    public final Browser browser;

    public UserAgent(@Nullable String userAgentStr) {
        this.os = OS.parseOS(userAgentStr);
        this.browser = Browser.parseBrowser(userAgentStr);
    }

    public static String getUserAgent() {
        return UserAgent.getUserAgent("");
    }

    @Nonnull
    public static String getUserAgent(@Nonnull String identifier) {
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        String string = applicationDescription.getApplicationName() + "/" + applicationDescription.getVersion().toString();
        string = string + " (";
        Object object = System.getProperty("os.name", "").trim();
        if (!((String)object).isEmpty()) {
            String string2 = System.getProperty("os.version", "").trim();
            if (!string2.isEmpty()) {
                object = (String)object + "/" + string2;
            }
            string = string + (String)object + "; ";
        }
        string = string + "Java/" + System.getProperty("java.version");
        if (!StringFunctions.isEmpty(identifier)) {
            string = string + "; " + identifier;
        }
        string = string + ")";
        return string;
    }

    public static boolean isBot() {
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null) {
            return new UserAgent((String)httpServletRequest.getHeader((String)"User-Agent")).browser == Browser.Bot;
        }
        return false;
    }
}

