/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemorySize;
import com.inet.classloader.I18nMessages;
import com.inet.field.FieldUtils;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.Scope;
import com.inet.logging.LogManager;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldValidationException;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class Field<VALUE>
implements MemorySize {
    public static final I18nMessages MSG = new I18nMessages("com.inet.field.i18n.BaseField", Field.class);
    private String a;
    private VALUE b;
    @Nonnull
    private final Class<VALUE> c;
    @Nonnull
    private final Type d;
    private FieldType<VALUE> e;
    private SearchTag f;

    public Field(@Nonnull String key, VALUE defaultValue, @Nonnull FieldTypeFactory typeFactory) {
        Field.throwIfInvalidKey(key);
        this.a = key;
        this.b = defaultValue;
        this.c = FieldUtils.getValueTypeViaReflection(this.getClass());
        this.d = FieldUtils.getGenericTypeViaReflection(this.getClass());
        this.a(typeFactory);
    }

    public Field(@Nonnull String key, VALUE defaultValue, @Nonnull FieldTypeFactory typeFactory, @Nonnull Class<VALUE> valueClass) {
        Field.throwIfInvalidKey(key);
        this.a = key;
        this.b = defaultValue;
        this.c = valueClass;
        this.d = Objects.requireNonNull(valueClass);
        this.a(typeFactory);
    }

    private void a(@Nonnull FieldTypeFactory fieldTypeFactory) {
        this.e = this.findFieldType(fieldTypeFactory);
        this.f = this.e.createSearchTag(() -> this.getLabel(), fieldTypeFactory);
        Objects.requireNonNull(this.e);
        if (!this.a.equals(this.e.getKey())) {
            throw new IllegalArgumentException("Keys of Field and fieldType must be equal!");
        }
    }

    @Nonnull
    public final String getKey() {
        return this.a;
    }

    @Nonnull
    public final FieldType<VALUE> getFieldType() {
        return this.e;
    }

    public final SearchTag getSearchTag() {
        return this.f;
    }

    protected FieldType<VALUE> findFieldType(FieldTypeFactory typeFactory) {
        return typeFactory.create(this, this.a, () -> this.getLabel());
    }

    @Nonnull
    public FieldType<VALUE> createFieldType() {
        throw new UnsupportedOperationException("Must override createFieldType in " + String.valueOf(this.getClass()) + " when using custom FieldType factory");
    }

    @Nonnull
    public FieldType<VALUE> createFieldType(Object dependency) {
        throw new UnsupportedOperationException("Must override createFieldType in " + String.valueOf(this.getClass()) + " when using custom FieldType factory");
    }

    @Nonnull
    public Class<VALUE> getValueType() {
        return this.c;
    }

    @Nonnull
    public Type getGenericType() {
        return this.d;
    }

    public VALUE getValidOrDefaultValue(VALUE value, @Nullable GUID entryID) {
        try {
            this.validate(value);
            return value;
        }
        catch (FieldValidationException fieldValidationException) {
            String string = entryID != null ? String.format("Value of the field \"%s\" defined for entry with ID \"%s\" is invalid. Default value will be used instead. Reason: %s", this.getKey(), entryID, fieldValidationException.getMessage()) : String.format("Value of the field \"%s\" is invalid. Default value will be used instead. Reason: %s", this.getKey(), fieldValidationException.getMessage());
            if (value == null) {
                LogManager.getApplicationLogger().debug(string);
            } else {
                LogManager.getApplicationLogger().warn(string);
            }
            return this.getDefaultValue();
        }
    }

    public void validate(VALUE value) {
        if (value != null && !this.getValueType().isAssignableFrom(value.getClass())) {
            throw new FieldValidationException(UsersAndGroups.MSG.getMsg("fieldvalidation.invalidvaluetype", value.getClass()));
        }
    }

    public VALUE getDefaultValue() {
        return this.copyValue(this.b);
    }

    public void setDefaultValue(VALUE value) {
        this.b = value;
    }

    public VALUE copyValue(VALUE value) {
        if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof GUID) {
            return value;
        }
        throw new IllegalArgumentException("You need to implement copyValue in class: " + this.getClass().getName());
    }

    public String toString() {
        return this.getKey();
    }

    @Override
    public long getSizeInMemory() {
        return 0L;
    }

    public abstract String getLabel();

    public final String getLabel(Locale locale) {
        try (Scope scope = ClientLocale.scope(locale);){
            String string = this.getLabel();
            return string;
        }
    }

    public static String throwIfInvalidKey(String key) {
        String string = null;
        if (key == null) {
            string = UsersAndGroups.MSG.getMsg("fieldvalidation.null", new Object[0]);
        } else if (key.trim().isEmpty()) {
            string = UsersAndGroups.MSG.getMsg("fieldvalidation.notEmpty", new Object[0]);
        }
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
        return key;
    }

    public boolean renderDisplayValueInReporting() {
        return false;
    }
}

