/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.json.FastStringReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

@InternalApi
public class EncodedReader
extends Reader {
    private static final char OLD_DECODING = '~';
    static final char START_XOR = 'G';
    private boolean init;
    private boolean oldDecoding;
    private Reader reader;
    private int xor;

    public EncodedReader(Reader input) {
        this.reader = input;
    }

    public EncodedReader(InputStream input) {
        this(new UTF8StreamReader(input));
    }

    @Override
    public int read() throws IOException {
        if (!this.init) {
            return super.read();
        }
        if (this.oldDecoding) {
            return this.reader.read();
        }
        int ch = this.reader.read();
        if (ch < 0) {
            return -1;
        }
        char c = (char)(ch ^ this.xor);
        this.xor = c;
        ch = c;
        this.xor &= 0xFF;
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ch;
        int i = 0;
        if (!this.init) {
            if (len == 0) {
                return 0;
            }
            this.init = true;
            ch = this.reader.read();
            if (ch < 0) {
                return -1;
            }
            switch (ch) {
                case 91: 
                case 123: {
                    this.oldDecoding = true;
                    cbuf[off] = (char)ch;
                    return this.reader.read(cbuf, off + 1, len - 1) + 1;
                }
                case 126: {
                    int count;
                    this.oldDecoding = true;
                    StringBuilder builder = new StringBuilder();
                    builder.append((char)ch);
                    char[] buffer = new char[1024];
                    while ((count = this.reader.read(buffer)) > 0) {
                        builder.append(buffer, 0, count);
                    }
                    char[] result = new char[builder.length()];
                    int pos = 0;
                    int j = result.length - 1;
                    while (j >= 0) {
                        result[pos] = (char)(builder.charAt(j) - '\u0001');
                        --j;
                        ++pos;
                    }
                    this.reader.close();
                    this.reader = new FastStringReader(String.valueOf(result));
                    break;
                }
                default: {
                    this.oldDecoding = false;
                    this.xor = 71;
                    char c = (char)(ch ^ this.xor);
                    cbuf[off + i] = c;
                    this.xor = c;
                    this.xor &= 0xFF;
                    ++i;
                }
            }
        }
        if (this.oldDecoding) {
            return this.reader.read(cbuf, off, len);
        }
        while (i < len) {
            ch = this.reader.read();
            if (ch < 0) {
                return i == 0 ? -1 : i;
            }
            char c = (char)(ch ^ this.xor);
            cbuf[off + i] = c;
            this.xor = c;
            this.xor &= 0xFF;
            ++i;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public boolean isOldDecoding() throws IllegalStateException {
        if (!this.init) {
            throw new IllegalStateException("No data read");
        }
        return this.oldDecoding;
    }
}

